(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    486741,      11077]
NotebookOptionsPosition[    470404,      10570]
NotebookOutlinePosition[    470823,      10586]
CellTagsIndexPosition[    470780,      10583]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 3", "Title",
 Editable->False,
 CellChangeTimes->{{3.393757273997875*^9, 3.393757275404125*^9}}],

Cell["Planar Poisson Point and Line Processes", "Subtitle",
 Editable->False,
 CellChangeTimes->{{3.412063760241573*^9, 3.412063773831114*^9}}],

Cell["\[Copyright]W.W.Sampson, Manchester, 2008", "Subsubtitle",
 Editable->False,
 CellChangeTimes->{{3.412935407213834*^9, 3.412935418490048*^9}}],

Cell[CellGroupData[{

Cell["3.2 Point Poisson Processes", "Section",
 Editable->False,
 CellChangeTimes->{{3.393757277966625*^9, 3.39375728316975*^9}, {
  3.4120638354096594`*^9, 3.4120638370720496`*^9}}],

Cell[CellGroupData[{

Cell["3.2.1 Clustering", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.395476063888075*^9, 3.395476065610552*^9}, {
  3.412063839585664*^9, 3.4120638411278815`*^9}}],

Cell[TextData[{
 "We generate a plot of 1000 random ",
 StyleBox["x",
  FontSlant->"Italic"],
 ",",
 StyleBox["y ",
  FontSlant->"Italic"],
 "pairs with ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["y ",
  FontSlant->"Italic"],
 "drawn",
 StyleBox[" ",
  FontSlant->"Italic"],
 "from a uniform distribution on the interval [0, 10]. On first inspection, \
we observe that the points are clustered:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120638741553726`*^9, 3.412064010861947*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NCentres", " ", "=", " ", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xyPairs", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "10"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"NCentres", ",", " ", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"xyPairs", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", "NCentres", "]"}]}], "Input",
 CellChangeTimes->{{3.393752350904125*^9, 3.393752455966625*^9}, {
   3.393752535310375*^9, 3.393752558310375*^9}, {3.393752675076*^9, 
   3.393752720826*^9}, {3.39375275866975*^9, 3.393752868466625*^9}, {
   3.393753428622875*^9, 3.393753452372875*^9}, {3.39375349098225*^9, 
   3.393753528872875*^9}, {3.3937535617635*^9, 3.393753604966625*^9}, {
   3.393753685247875*^9, 3.393753791841625*^9}, {3.393753840716625*^9, 
   3.393753846701*^9}, {3.39375388673225*^9, 3.39375391854475*^9}, 
   3.393753955701*^9, {3.393757384326*^9, 3.39375740398225*^9}, {
   3.393757537341625*^9, 3.393757539529125*^9}, {3.39375774804475*^9, 
   3.39375776066975*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwVmXc81e8bxu09DgfncM7hDGlJg4TUc0VJoiR9k5XSVGloGVmVNBQlKUIR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     "]]}, {}},
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  PlotRange->{{0, 10}, {0, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.3938435140327454`*^9, 3.3938480281236897`*^9, 
  3.3938480822014494`*^9, 3.3938487632908077`*^9, 3.394187944823618*^9, 
  3.3942546396360483`*^9}]
}, Open  ]],

Cell["\<\
By adding gridlines to our plot, we can observe qualitatively that the number \
of points in contiguous regions of the same area differs between regions:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412064029829221*^9, 3.4120640786494207`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grids", " ", "=", " ", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", " ", "10"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"xyPairs", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"grids", ",", " ", "grids"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.393752350904125*^9, 3.393752455966625*^9}, {
   3.393752535310375*^9, 3.393752558310375*^9}, {3.393752675076*^9, 
   3.393752720826*^9}, {3.39375275866975*^9, 3.393752868466625*^9}, {
   3.393753428622875*^9, 3.393753452372875*^9}, {3.39375349098225*^9, 
   3.393753528872875*^9}, {3.3937535617635*^9, 3.393753604966625*^9}, {
   3.393753685247875*^9, 3.393753791841625*^9}, {3.393753840716625*^9, 
   3.393753846701*^9}, {3.39375388673225*^9, 3.3937539253885*^9}, 
   3.393753969701*^9, {3.393753999997875*^9, 3.393754169310375*^9}, {
   3.39375420904475*^9, 3.39375426366975*^9}, {3.393757549591625*^9, 
   3.39375757685725*^9}, {3.3937576868885*^9, 3.39375771804475*^9}, {
   3.3938442192668223`*^9, 3.393844233036622*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwVmXc81e8bxu09DgfncM7hDGlJg4TUc0VJoiR9k5XSVGloGVmVNBQlKUIR
GqJSSRLJSGUnq8wio+w9fuf3lz+Mz+c8z31f1/v9wtl52Ga3kICAQIewgMD/
v366kZQjsY2Nwcf6Vu8r+4hp/oTo+3ANPNVY+cZNZpqwur9EKG4UxuDWVy83
Sf4ijfpqE3fSlCGxlblV2lcIt07udtJ7Kg/NXylTtSJMtHrsWbSkXwBfiw7Q
ST8Lyy0XRU39oWBq8+fDz74Io15s03X1yzz89jkQ9s2fjfcmi1/tC+Ci6nnL
ufUaNMyUZbaMHhLHHA+jjy0JAiiu1hOTN6DB0bvF3j96kNSUekzcOyuB+Rvz
uwS8meBIvG9mEXkYp7QeX76HjdErsQ1LxKVgdGklbTKThpwWQ3uSo4QO1tW/
+VITJNrWZL5CuyLc6ftKHmqy0fTn3JwzltmEdjthZew2SQhSVv+8dUsDLmtV
/7Q/zCar99XN2WolD6U/B8/PcVBE6/fTttftFWG59+ydfFUW2gq3KuyJ1UAk
6zXJkRdFVEhCIe2rOAZ3pu/ek6uA1S0jt+VfNBOh1392WZhSsSbKaPOcYBYa
3LM+P1khgLodw1dOFitjwwGj2LgAFbxbc9pg2Ut1/Ku7eMLrFA/39+8xqsma
Isd17foFriuhSf3evCi2FCTMV7We7Z4hgd+TZP1jlfE+/eJKvTBFHBNTfn5q
lRjmUYxS4v8pY57h+OnZRSp4nRZ+yPmpMgTTvcRETDjY1WKdbf9YDTKPDq2w
bBHF0KxxqbYHqrAIFJa4L8RE7LCHraCPFPbdSNsgtbuGrK77UxByu4f8Lj4k
MSzFQOXD1sb4xxRIf6AcO7iVhyK/d6VNeizE6R+/mJElhenN3lMVj9iwuXm1
ZdZCLmp0KgZJMQNbNWKvmKsLwNPNNXSzKAdZ8sm1SeVqCN9ZVNL3QBA5DznM
X4WKoDhc0CpeIYhzIYXlXYtpSFzser39iQpCXc+7138rIEcbLZ07G7lgHbuQ
3JZFQ1rasV7dB91EfePHAyFJY+TQiquJgb9oUN8nGfrWfYaIXBirtmlRQn/p
5pu0vzIozs9TupDbT652jaZU7x4mF3eZP7z/SghXtmeHuWergqLTtWl+2ndy
undccnenMtyznP2rU0aIn/6JSq0EKp6rLWqpuTFA6PFHntZZ8vfH3MLF3Z5/
j57fn8dulESKn5vuEEUFKxoClE9t5mIyMjd/qFEZlt92N//8pQG7oROLvId4
GF2a9C0ltZE8d2XO+T4mCp+sE6IyX1SRszHJJv6zBEaMdY0KrgmhQDoyfVZX
HzH+lOImIiYJ+021Na8X8rDkQk6HKUsSF+PF9poJsNFWbhdzeDkHAnJCv5e4
KOP64YFLHrks7NE+G+9QyIXAgPrY5ro+skgkxSNmuQx8lB5KaTdr4MHvnHmN
79kIFdxbPS9LEe3X3ue9bpRAPa/3RftsLnL675yce0cDJm+pJx487CNyX/bl
XjspjE1liz80GKkiMipW7AWVA62HZuyB93TcT7z/PCBvkhydZfYzYb0sXOL3
tG27+pfoP981cNGEB4+jQ3tKDRjQ/remarcwFRM1hw2ix6TgJLAqc/lvaVzZ
o3vqOD9/uA9lltrv1MC8M16Pz8vQELX6QXuJmRy4b019vNcrIEFV2/XJghli
8PVKetHcBvI3wiaWaszBU7/sxGlLRQhkH7j28GwVcd17Skt3TA1PXj80mUXX
gNH4ZCYnUwUUwQPFIbupGLpNseBtUYGBgVtd63wu3IScShzjNJB1j3V34oIK
1hg1/9BLVwX9Rmq0VtM3Mrp1rsrCdfVkxEv2lsRtDWh6ePaUJVCwYneM1fPz
CmAX2Eb6utaQRRmufdYfWJA7EjD3j4EIEsKlLmtP8sAPvvIP5AMZOGOnXbmd
BYHUkpqytw0k0PB1x/MEFr7eONsytZ6LZQvs6z9H8SDhe3HL2/BKcn7ujLx3
kRBs2vYERJgoY9WRnDvcO7JI1Pm8WFZ/ipi+ORfJdpOHwbLYNR4vukiMzhzv
Ok8KJjfF5E/FsJC2g2N1XeoX6e6UHTJu+Ueayhs2cHiicAul9TYxxkkXNfvC
Wj0mNmw89H00VBrhc9enFhRNkrTnE2HV5dWkwJ9DZgxFMXy3sPzLdzbCS054
323kIfnFRt2UU79I4dbdSi+GWND/OJ967RYbtj82zH/UTMexYHPL8+8UkCnH
cLFZTEGca4RZoFYhec6QtHdKo2L9vL43Jyq5uLjvZfdhTUnY/ul2PnFYEslG
N9R+KTeRJ48bbataadjZuvuH8+oZQmmbn+lUME7cwwQ27uieJFnF7c1B6Qro
1Ugo/VilCv0Ml7trXjHxIzNPPSedjeSKDyldb9Sheyx35fbV/H3st11kIM7G
hxdyraG7RcGV3Hd2nAjjaU9FQ72ZAjpmidD11iuibGN9d8EFJSR8v1PwMVMd
LzZvXpcaz4NBDmcJpUUVv9cozvK3HyHMo/7fnLoZuEQJPPzOhosNZ4bcd95g
YcVbju+39aqYKXC2tVtAwcGdHZEe95WQ+U2t35UtjaaiN33zIl6TE5pvjE19
KHDhib4psBDEGytJUatFXGhtcmHdbmZDmeOUs9pGGYtuNV0S0Osi3JSB9MGG
IWL8fYmvUpoGjB2WXrrZqoQjRn8VhpI4+DBHskp/fIZs9nPRKB9monGnn841
tjz8z/RPXr2silHtwWO9h+ho6ZV+qETGibRG4mf1Lzx4KUbVbLcShNeroH1W
x4aJSiMvKn89G/rt5y6UX5giekTl3nqVNvLb4EX0bmkWQtbtQryhGKQNszPf
toni00vZ/O1CbOg9XPfA1GKQXPfaOxXC/7nnE51i68rpEBM/e1x47hA596Jh
4slRJSwp3dHak8IATih8F/EoJBS9niCHui4ikjctkb9cFcE5BtkRExxUjIrq
RQUOkquNZ2+eMhFBj46t/9FJNijL710wfC2M+PObPC9U8fDK1zJ1VTwTSxj1
UrUVSjj34R6l6wcNnIUtPd8TNbB/tt+GURkKjuW/LZqfoI7TNKMP0WDgYVaO
1/UReaTK3LmgeZ2LyJCjwps2zpCs4WOcU2E0/Oqn6WU8UAd7dOWrP785aFuy
HjPrmdj8xbZn7LkSesmSsKF4DnrDBVmsWikkFC4JblEfJJMXDzQL3ZcE5T8G
mZjHRPYm/X2VuWI4U+g7oLtWFQUCtPFoP/69/o4xnfzGgv/vohseSx8Tw/uO
xXuruJCUW3O28ZAcjHedstbv42H28u6Fl7W4iDk3nKo1wMHtwUylg55cNM3I
Ny3/JAauxpnOBZmSyGlfIFm3WR0qCRt3xN7if//yxrALD74TmYurMvdaKCO4
fe5xW/49xhxyY3zmcPFX8VsF2SSIxD8f9XJHWfB81urrLcuE721R2y+6gvDs
rewrt5GHCv3c/EcmivBLdLgUX60MAYN0jUM/GbgSYvivprOF2Jw+Ipr2UB4f
VD94ukYyYXBtldHFGlUkr6GssZGrJ4EsbzoR52D4trZsvGI/ORaptCP4iDI2
b9E+TBK5SD8/8uzXZwoeP/7VJPgfD+yu+nT9n2qIPJf489BJGoJh8U+6sYLY
L6zcqvaRBgx+Ur448JCUHNFaLryTDvvRIMvDW2j4IpAf0S5JhWy1VhjdVx36
TtuEdftp6H7h+/1nrAyenPV32HRREl7zg3b+N48N//MJyc7xcnhy8UBNvSAP
e0qqLDLvq+PpPPszjrZMFC20WdVf00JuvkzxMrmtBvrgBR/7W1RoL6t8NcdR
DZY7t5tJWMsg7sSp7t9XM4lEkY+gyMYBcpoWNfzmGA/TXiZvK06xkW64Zzhc
RgUuXWERabUs9ESI9rqt4+E/M/lJk68c1Ht81IhdJokvTKHAz4xewg412XPs
LBvW0aUP1v7LJVvtXivHdVGQv2mn/voSFr7vr5DOuMHESsd2gcM6bKRYL/mV
8ZCNYem708USLASdfnNC9QkVkUf3MUO+NpPARY/X/Mij46qC6e6Dz/qJyD+t
KN290yQh9sJhpY8MhH9e96fttBK8LH5WSLbOkM+OuttWCYhg5kH5Jm65GIbn
RugdLNXAHt1/7zPGhLHRMC2yPIIDt6zzjnJHuQgfcX8aIsvP/bGnQ2lrmTi1
Pb2px4EFRYmD/ks/cVDUfULggQ4FVUxf/zELdez8ZnnvvN8EsbkmfblQUASd
esmyNe80EOxxal94lQbCP2StDLn7h7zofPO1CSwk7bYvYbsxEVigPn72Of/c
dY7eONHJhW1LhFbvZgmMXyzrHnGgwLjy4ciuK0r4vZUxO3grBaUKN5xqoIGM
9pHDLxUp4C4R9xexHCdFK+QMJKqVkMJ5x/m9Qh4R44+UJ3KnidPMjSjx86oo
8WUGbHjOgfGb00t3mg+T03mGJ49tmSE+L7TXzurpJwJnVpkGxHL4XOC+5tZ7
DWjHrliwzlAAbjfLX9q6TpD7SwSkvM6KIP6QROVYPwc68p5LMoZGicAiZ2p9
rhn5fU2ij0yo4cpWzYi4F0xQrj7/7TjCw7mdvn0aKirY5h/TqGAqhLQ49dYT
K/h8F0sp0ZzoIKHqHoKmc7uIf5nRlv7D/aQhw7jip6Y47tUyehWn6Hi0O5jG
zOVB3O9zUMwFDQgYRp5K2fiQ3MwSvFNYwcXUT077q34x+K/7U/n9oSgu/efR
llTeR8ytLzf+WEhBr5OQ3MC8fJK5b2/K7qxBcnCMVqj6hIEO28r+wotKeNSx
x+4oTQyVU9UPjFdxseL8H/Mb/JzZc6exN2DhNDHJ/7Tq0iUVuL/8L1rKm43e
B3t8e9wlEf3ozFs9fm4bcSISds+nQ/2z17HKsXFSn7a18XsPEznGzNjqDHUc
SbwdsNdfAcbuglKrTMXgWxV4O3J8mIztWtKoVCyPtHyuuXhYK1EabraIW9FD
jERXfX32bITIfYTOq4cDZMe5px2L+PzUafKvcnHkKOksGHCjSNOxgRJkWJ6k
gIAYwyu/RrnYtZwn8qGhm9TJX7guK6KC64Hno+av7SOXJg/aopGNn9s2Lsp7
owKv8z3/3f/ChM/tysF9NuoY1dwacZVKgVDzU1HmDllc0Y36+vrMLzItriLw
lZ8nesMbRpvCqFCcz/5xbgsXvyXL9Gec2dBcsORaSy8XH1yXPTKKGCBp4i6L
erPFIbGYLe3d1E1K35/YobVNCtGlttVnBylIXbA/Z4EPHf5zfRZ9rqPB//ie
Y+l2XURrsOfnxaN8ztzoYGVvT4VNUdfz7wwuTrmrPZhuVITT2kqZr+kcaOJo
3uoScYSp3lOXeM2E2kod0ftfZdElfGPVa1FBlO4ldMuzAti0+3jc7svSOOrz
9uKpX1L40K+RWuPLgbuQxw2tJhZY1dPzFAJ5iK6/P+Fsw+cii8UJYZk8LMz8
qnplQhTRO9jB2gsUMNfz1F3Nj6pwT4hZWRNKR8bLO9p7DzBQLFdjNGqmBLuJ
U88OMitJi2ezyH+zWJBkXnHJDBeHngj0tIYUkUB+/gu0U0acvFOUhbIKsvZ0
1Kq4stHwNrnAzJMGe8tNPZ+cBJFBzzszm9+7RRhzE/RpIhJr77v1LGQhXm2j
X6WTAKJyO9bRfirgzlujyef3aCiIHHvhbKAOxw3cptJBeWhXXrh96/MI8apt
Meyw4cDx2qjJsoM8LP5s1kY7RINxXH+DWxgbvEOcTJ0gfm6dHbWcWfGDeD0e
pJi18ufSy1u9g6YIwUtP3z9ni8J66RntsOECMppzKN2YCKHF8EefdjMXBQv1
5NPzNeCoV76kyoYJiVO+a4KG1BAb8kqyb5wGT2em/LHLdNxY21MU00mDbzBj
6lkEFXPz113NqKZiu0Ja/qtevqcNPJxcOvsvqdvrL1W/VxYfSmx2ms7je0Xy
iNcOhiquuo6EXqMx8M/nLyV4KRXHtxkaa31XRx01MZv5VQ3wFBbam9VBqgN3
0KqDmcAQ61dgnhIOrTcsluhi4Q42F31MlsTfuMRNlaZKSLo3/kjhNL9/gw+p
S7JKiF14+tY2SRom/lv9IaxbCe1H875diWZgJC+EnbVZFpnbX/lxPsvCv4+z
NF68hCwzkp/S1GRg8/mdKtfvKWB6VUnYejobb5NtG5MqleBPE1y4zD6H2C8R
HjrOpSN8fsnUYXEFrDV0ldr9RQZKX227rY/2kcVTz/3T5BRQM/A617iwjmyT
6o5oVxaCjnj+m5taSog0DOzy4/vX6uNnolc6DpGI6kLlyHMK6JlOMJ/P9/bY
LdOVVmVSWHSwVPhxRz6RqAmVEDzJhU6haGnHDAWKrfomT6tk8TqyYYWavAwC
Ij42BtnS+Z7ry5PfNUM05zyWS2UroTUl+XjZTwoOBG9MnHtXGCutCwvLr7Jg
vCNfUt5vjCwv7Xf6Xq8Ea8HvUxJ+Gng7tsmNJymEVR6LHiQ3ScLtTofSoIw0
etuviOSm1ZFaKZeT2TV8fpP9ZCzjxMODyhqffz1c9CZaZjsMKKDbeLjtOV0V
ToLfnIxjKWj6Lux76isT75uTc46aczGnap7OuV2TZPd+bnGaizxYCQYpa4oV
EJxiMJFbIYXerEW7Qt40kFPPft67LyiDqt2eFtkifM7KP+706T6fUwXumBWs
lsQytxGNChEGnnoOvnP8qoonm3cVJkVNkZOyHrTF97jwynpX8/O8OgRvH/G7
vkoNWzv91ZbPkoUVLTjJiN+LutpXzUxieFjr797dFsHFTxl/E3KJibNbQx9R
OkSwssnb9tknNqo5RUf1GIr4GPrv1kpvJvJd7+rOd5JD/Zraf48ochBZrKvM
DGQg1fCT7p1ZkshYPm0q3FlJzO7kNbz8rojVL18WN/5pJuflNkecq+FCSWif
XZ2bINp2x9wvzaZiSc62H2EmKhhw2V5FTspAe4+QitbNESKpFfS+oV8UbZp3
3j8vaSYdS/dU+wypoNE13nn2BTZyNhe7xTWqYGZGlL3psDKSWXOzbwZNkbRt
TsWvJprJmhg/C/JMDFd23tfcgXZiFWVZypPi5/gf7rJoVy4yfqQeCikbJhaM
Z9fMnNRgrtHudoHv74+NBJSF1RWgpGWb8bCTAsF5AnafXBRgbU7XeZeUS+y5
qm6cYzTMXKRWXn0tgzT/rE3M4C9ks7f2gcIyeexjGu+6uVoKOpRjZ+pHOfDM
8Zwv8k8S9qu94MbnBBehn7NGP4jibKMS4/0RDRSlSHtF85/7PL59ZN4dVXws
eE79EU3Fmie899qrOZCTMv22bYcqgqiTFhdDhLByr+vY8mQujH7I+hkFsdAv
IuFu2q+AVPkdc/ap0fAqbLGP3QoWlE0XaARYsrHEulUjvpyNepP045ojotj1
6IJbwQcqdqammTtcUwf90dSHZINaosmOW9a/RBWudo8FRTyVMRFjfcXynxoy
7rPCxWb1EJe6R3NtrNtJnKb40jvtGcTLQbtl13Zp2HVdpGv2K+FXeRdr+QgH
nXtl3nyu5nPyAd/mdGURJGt3JlzeSMfq1c3a6rd/k47bj8xWGioiw1rpelga
G5GtLkdb/qlgV+y0h9zZCbLHO756QlkAqeEvfmvdlMKmmxdCnrSoQW+90w7p
hzxQVJIOXE1ho7vCNX3pNxVIOJ9vqHLUQI+6u/KTKTGcXLjtjPUZeVy+pH9z
zWtxlF39EqN8kgeN9B1jlk852J3k4/W2VgUFdy0WK5jRkJwyq49xXRn0F5qs
vCo24rxmz+01oCP23/MPG15KYWO4pfdOFWEku7Z7ZL1vJ3qTHREHG+hYIJnA
67rCReva9+tWPaBBmsZWOlaqiMd7UncsbmNioGvF+8f7JVCx5G3g5x5FyOhe
/4/noIZpbaU1f5pp0J8UuSPzjgbHLwHmwf48lOU9lM8Z42J1syw76f4IsY5P
NWSuF4SdXFxh3V41ZM0xCPYPmCTFvpc4Yk/YSJbIGd2zk4MYuZcGTmoq6F4R
q5nh9Iv8rgz3s+LzY/k2O/3w3crIf6khU65NgUjT/HWXphlQnDVtovZcCjIa
Z9msd0xo7XnnNE9UEeWji7NtCQdl53d5nA2mI7rYLedL1B9irK7cMl9fFKd2
neX9DJDFlLLb1SknMRTlTnTXH68ifgku3heZqpj41pdbeEIKy+TGApXmqWOA
oeJgdEUW6VMH378PU8L9zze+01Op+MZNbHgypYB5ZVnjtV1M7Pnxe9yc79c1
n86sceLnzV/VjJu/DvaRLfu8J2RaxfGUuvqKjaEkxtfZRSf94u+99gvvdx/4
3tqH3pTCfqJQ26XDYbORXVyZ90NNEW5XTE9ITSvjo3varGI7fn/Y72mRI3y/
nG0WHcHn9X2+XsI6K8vJ8ZMH/zQz+8j8K+ezN9zgQjpkltAVKxUoVuna6NmI
Y65j0ortZixMGb2c/eI6v69380ZqldVxdfvTgIs0HsbtPL5JFrKhq/pG526B
OCA5WaGZ8In0arB3fynk84LD6bKR098IxY0OvxhFZFVZCZkVzZCVnSkLv3CH
iIOyieDeh3zOPLJ2f8Y6aYTOywhbYSaMgLSNZklHuMiR8lvg35xEesOn5Y/W
NxGu6aYEx4vTJLpoO413nu/h/5IOPBCigrF8vrFPtQzse5wbSwQ5SKBzSoYf
NZPQixfLO66pwvQHb6eDPQ271KvPEzkO5ggqC84+3kz8OF83fnPj+8+W5+/u
6g0SCtVl6WSELPatDn7llURHzj+rWS89ubA84nbaIYkGI7GdA03fNbCVDEjd
EqejNLFOZhXfH5uEdge4KyoiMHdW33prHp42/3nG7FOF19LFQlOSDFDLHrJ/
veFgzPh+WNobLjB3/rDeS0XkThfX5nzj4QpHTjrjAg9zfny2vJ7I56iXr0Tu
zufg+N9+hm4vFfpRC3jVLTw4OmxkUw9IoleQR79U/oG4b32tXx/K7xex1qHK
3+I4GB3vKPBqitQm6n1qWstDsQJzNL2OjXPnN2lczaUg+JpH4lXHGfLRodvx
QrgqCmYbZi4sU4KPqF7Q+AEOWNvOF1XP4uHJu3U9S2mqGJX35+z9MkWod8+/
raVyscNZl3vtjgq+sCqXeF2SQug4Blq2jZLF/rNjhBZpwEdto75YXTcJi1m1
0vaxKhZZN2fPlvhJuG0LQ+jzlXG8aolqLOF/3lMH1746+Jt8Cz30deFaCnx2
f80yPNFPst/dnzRzVYb1KnfjnMtqEHobPUdeY5QsMl4sWG6eT1ac99q06LUg
zq2UNjO0U4f7u4i64zIMlGwoDr2iS4XBeYNe50XtJE1S7cEPw2JicDiqTPO7
LHhF+Tlr7wggUiTfKilHDR97f7ntWiqPnJMHwuuCaGj8rOfTu1YB4Tp6ahHT
UySdqIZ1GUlge8yeD9HvlHF0JMoy6R/fT9S/faAa8tBwOPfLERc+77x5pBKs
KQ+tL+YjtQmK+C9HuGa0Xgrh7QUhLckcdM9i8bQyBEAL7jhotJYDEwv1XTvL
OVD82m9FiiTRfWXLpaI/ijDqPPbC3GKK7K2l6EnzPctXyFR/riADcft457uK
VOGifbVgv4IqOoXlX179j43fERoFB0ZYsPh0WVXwWC/xvXLoP5urDAR3CDua
6LPw1zr30Bh/34J676tPR6jDYtZnZjR//mx77FMG3bh45LxK7D1hIcL7+ayh
q3wvu7ay/8zGfKIrKV97aoUMKlb71A6JsGG85k9ozVNhjAbuDLXJ0EBmuWvl
dn4+d2jQjJtneLCxT5hXJyUBY+nK1GrhXjKnK5BwlRlwK1HT0y+TgWg6jr7V
VMWb8HORw1xFCCQtXGn3+Cc548kojKCpo8LyqKo6tY/Qv/S8CFGjYPLufnXX
HAYWhRbazHvJwu/KqvSZQxxsW77NxLKRBl6zbBXvuxK2omvFazU6upPUVL4F
dZGIIInrX3eOEuuo+f3h8QNkT85h1ipxNZg8u+QfvYc/J2XPbErsBeG+foPF
SjcabAePEl0+T1j2+RVlGash7TEsR8vzidrM0XNGVvx8rnug8v4b3xMT3J9I
P1eFgKLRopjEo+TD5eKn8gY8IOyn9dKvZaRY0Fw3uFIBWXNtPemHVHGd9VP0
dy8/f+958Ri/pgk+N0zzZopI2m0xP5tEOeyS65aVN50ms1IEvuXzzzPRbPS/
Z6vloNd9PNLPXBXjxc9V/PO50Np5pryhWwNuZ+ICTO6qY8WllGi7PBZm2Kdc
Wux4yGa4hb1T5kDb99ZoQh0HCxdbLlZ5KQ/RkUuuUsJ87l0bc3WTkDB+dMTk
H+9SQ6DY+v0VHsJotH5f8nw+FVFs56vmkUII184YjOPPZZkftjb30fjzdeBc
b6sgHm8UjlquJQL2qzHhA/znp11QiT7syYNlZEzdySNq8KeW7Gq4w8/NlfTN
opRGEvJv+c18D0kcdMgv02ziweJxgIxzIw8PS5eJbtoni927pB6JXeWgsTjX
+qY2F7/jP8i4pk4Q7/1LxvuXSIIrKblA0EoBjvStzkbTHDw0Nu1ecVYZhXm3
4j3vyqI+a41UZoUi1FyPzxLh9/NWxrxZXon8nP1YKVYbyYDBf6yTgc8YuL7D
gNbjSIW1XZnNe3EesmQOPtO62UIk/RRPlkAcpftOOP8UUYHnJ6b9N4oGohLs
8gc0FfCkxMBKKYQN+oLl6X91KojNW7MIge8UyCdabmErymA8eWFQDN8Hay11
u7c7chChyd2pwfcsc8XeIr1tsqh7+sIle0QNHfafPifNVsJ2Um+neEUay6+V
v94yKIihU6Pf2oP4+Z78+Om2IQ1o9c+t3FE8SqKGImOr8qRx6bBHFOPoEJkw
W/1xIFIVOQXM2c5lFFyoDJ2RCVNEftKIXGy9CgTUZFbfHggkEi7SWbfyqPh+
8LXlnasqyAtTND3wWhLRgg5Gd+cqQqVxzekOKGChttSGRiUu0pe3XV5eK47a
HYwFhbfouL7AujZ3uSQ+SBmbLZqnCPJhYPShtzqOHBLwjn7bQoxM7v5+sFwV
Ri4zUhJrWago23S4tEEGi156mZ5QlsB82uxZzsfFobxZTSfWUAYx9zZF7Fkk
h9Vhudcy+Pzwn53AcmUTGvbQnKQ/8Hl672Un4bk5srAbFhx7wz/nY1e9pP97
qoEXLYYZdp7qsNFZ9Fc4nIE2DZGv4as7SQNHyLkjWByGugZvr6eKw+DUCRfe
tCqWtxQ459kzYSDB89W3nCZOuuHLqY5M2HG7777XVITjPrfyDKoanHKvB7V8
koZZwB2/uTITRHCOlZF3jwQSD8pd7BVVRyn1Fn3uTw1oi5UenGMqg5qvK16w
QIXh2dZgxmph6P3bJTAWyYHvzeW+dTtEIPBxtFAuZj8hF9V37P3E75moFsWD
blLIun8y2lS9g5BeVed7BcIoKppVf2aSC7vJxra/PmKYsyzf3fZxA6ELe6ot
eVxL9MfPDF5PUQf+/TK5eqObsBeKMLnqXPyo2T3f/RIFj6iMAfOVXBQOXDQ6
tZoCSc4N9Q4bLkLefM3oWSOBk9tSXsjxOTA55gUvUr2CFCVURG1W5GDg3srP
H9aq4TJ9nPuI78XWpOj6YikOlvWxGla+FUBfwam1bw6xEZ5svKaxdoxou/yR
EWNQ8WbFT4pUtBxce62O3r7GQ4ZLUdXbW1wEM4Y0nR5WkoIdL0aEDveSHnHF
narl8hDafblX4pAGDH7G/XKOLyNeFuKXQgNV0PHqp+LKC2oQ+29SwvfOCIm5
5udUaDdMJKtTzj/dzufyJy/8zIP497y4SrU0Wg2O4WvKPw/K4dhl16b1nzho
DnjWsyZEASeZ82cfd2ehxEpoZaB8PxkQ1k24k8KAS7V8Rl+kEp66ZW3Q7pSC
j2H0t/PFksjZXm59JDqO/Nd6ef9BNSr/91d9C2xSArtf99od/rll7H3bcCuV
h9MCtHrF/VXk57q+8NRYFcSv9Pe/F8fDXzHP3b6GvSRSoVdLjTNAmn5u7Ksp
UsOZ3qSLpaoSONdXvOlhgyK8rxb8+CdCg5ypUf3fV1wkC8scjtzGz8dUXfu1
c0rJ/lnrTogYcHAkfcHpTVQhTLZ8Uyl8rw6TSa87o8V0rAxuja/RkcPHc/eU
2Zgil380xy6ECGb5W2ZnVKuhLKqhfXWOBr4pDDzosJZDVfXDghw6BwfUd+5n
lrLRfyplbB0/x4MHQzZFDEpgXjgCrzNVsLx1TvJgniDmbT6xMWwdG04JZw64
pkrjzCP95qooKuZknul7e3aQ6EjecJq8TAe7UWWhVY0qXtsnT5i2s5Gh6HVL
ypWGhgpt+rFEVTjVD2a+7WRDzJN50LBwnPS6rrLS0KRiwsL82egPQQR7v4w9
+YsDd3pcmo4qC/HhFp9HFbhocVzndZuqgkV323RGDJRhz70TM90sApei00ve
uP4hBy22G4fliqA0+9uaEBVxyCbP+5cRKwkXyqm1Y3xPLt7Yv8NMhoJd4jfW
Lz/KP8fVuzKqJOUQKrNO5bN/C3Ff++cTLVIEaxcfCTrF3+8r68+LN36WhaD5
9TButwC+OnT79cyVQZ7w8eCjT0RQaxzyIuy6As6EXe9VeiWIOcc3F9luEYP1
snhpzGcg4Y5w2sykGpIHFEOb+PthszjByq6Qirzt4/FmalIwPGgUN3FCAgLB
i/O/Lo8nlv6nQjqOc+Cg5anT+44HgUeHHJ57xpLi3B+r1OYq4fd+ocMvzjGR
PTz0quEwF4vuCPGoJf/I3mIa+y+fa265NQRW8J/zTSBPa85GSQT6SXRvCFCH
/d2EI5xgHjxPPL/2REsU/8XbvbkvNcOfZ633p00mSJnFpmcO23mo/SiZVmvL
793K8Yc3ddTRm3Mu1LBHBinnK8I6IQD1W91LGGMcpKl9+KQXUkXi3J+W/+Pv
c5zUzzUDTzqI88HwDTW/eLhvYDE+XCUHrstqnZdXxXH/1RXmTCUdBoFCIlV8
nhmrC55qu873i4hrpqk+opi1PfiHk68Y+hkMy5u9HHRe1OIdUuRhi0qJBtwZ
6FF6K9q6iorBSaUbRUUMPFrta6S/nQpYvdSTaebBZZ2sr9X3P4S/97nHywZJ
yc7gWTYLGfjwIiiQt5UNF07Ja7nT38nk3wzRn93txE50w5lIrVbyoTf2aUkN
D8vN9x0z/U6F3OMk5k1p/jwt7MqbzP5DSrd6fL5zQgz7chqDFAyV8WRW4oxc
rTB0WDfvt55TB0VvbCKQIg+dA/d+Ry6mQcVH4eujOjW+1wy2XnPtJOFpVea2
T1motR16cIDCQUa2qdXsCRaSPhQ829/NhNysyfEafo9myVw2DmijIufz0c6g
ueoYHn3p0dqsjEvvOBRmzihRezvi5f2Xi6qa8k2fvWdIqoeNcpmrOsKzbFac
pPP34EDUfl1ZDpINJd9LxrMxTinK1HFUQiVtiar1BA/+xlNLV1TWEKXda0Sa
nyph7H2okPA1GeyStxcuCFWBbWvuOdjzPdedaCR4iyNT80Ry4FdVRB14Qquq
5vN5QRM3z18ea1N/Sf+JocEjyC4iwloIiXs09rb8UINRasm1je+4sG7RbPgZ
zsaEt0+cbIk4eLcfb7aYx0H23nqBvjwl9Ir7bKAO1ZNHxS7vRW4MkmcbT255
MCoO3fOLLG5RWVgcYFORr8vnIys7x5ONXBzcEHdrMlgJR03qHuxs5cByWVKn
SvcYSaY3GdVXK2Nz94+4T37SmPg7r2fuYhW4zQGjUJCHoIMiVKEJPqf9t/WM
Uu8MubhY+/VcbyY2hMjUJ86dJMEeCn1WMXXkzaX6LapDQmDOd54qqWLAX/1D
an1lBXk5vaJC5S1/rra7frqd/45QfYKoFylSiCiLCpRewMO5v7amGybGCFID
LIrX8Ps/5avho21sDLv4Xd1czcPb9gqzDbtY6Ez881z3lzK0nhJl1fUcSLPK
0l/v5sJ4wQT3tCsbDrfUrJqe8/eFOoCrLVQsGktQLpcfJUlssd81ZyQwcToj
U5IqhaDAKqHxeSIwPHp3hcULLhqePNAWOcFF6JTQRod1itgw0ROwqXKSJIzN
X2SqoIKDS3JbZ81mY53Rgln2ubKoeJ2WE/9cBv6j0pqu8xMIp3mVYOYFOdg+
4eksfyuN0hLrdN1SWWTZKUzFltKQ/Vhbj1nOhOwfrRWPi/n7ftTaLkK0nWQ8
1r6hZNxB0ldf0b2ZxEF7slpgC//ztihMqHj5S8Dsy4INTnw+l1lsSLcI4ufY
UFe8vSA/R9wS7d+OdhPxfgvdmC00xNxaikEaD/InNa5cWq+I4fPS1GuzKYjy
KPLZGC2KNefvVXpny+CgUMCT4cIe4m8np11Qx0D6ugOuRYUTpPpH/a+0eGXc
HjgrZCipjlAbeZX23SVEQV3PgLuLg6v3ItmbPyhiS93k9qI9QhjTPbw+0EgN
Zj3+ov0xbIiMOGrGnuLieoSUUHshAyvneUon7GUh8vTSRcJHfpMlnbe3VLTJ
IcO7LVVSVAouUzLFAR3KUCtsdd4no46TuTTrB68GiH6tc5ua1SjZYhsU13dB
AC7hf1amyoyS5NYleuubNEDb1T1bIE0eZdsYc4fOfSFN2/bPXDkrimV2u5Jy
k/gctO/W0tKtXMSpiepv0x0jOX93706+rYSBHaWbjy/kv6fV+KSEshAigrNf
367QQE303WnGk3Zikvx4ZGUOP4c+3V8wRuOg/+3Rc6teKUM99loOS0YSkd4/
Yoz6OXgacTDT+rUsTmv7bZDl+1fxsO+3NnkR3Lf1+bV5Lgv7mGXBhrrKuFO9
269rWBzZIb+UPF4yENTSkZTYLAmhJrpWgkkfubFAnbI5Xgoxlnely2JYYC6p
LY6yGSf0ylbeHl8aMqJXprRZqCJSJjSHYtVFHGLX/nZmSeHnMJf704rPU76v
94YrDZEQ9SjnbjEa4tlmgsszJaD//O3sY/w5qjy50kexi43rmg6W50OpuLPK
IS2R7+VzU2Pf/5jkQESQve4tlb+PcpK1Ve3vyT5vzgGXTDamR3f75c8fJJGL
XQ60DtQRrZ2brf3lOXiXGThH9CMXEg7fe3Ilh8no0s1h1id+kOGlzxYtpivi
g5zB+6IqGmo8wziHOngYHlwn2VjKhe7QBCONw0BTPE12SPcXSVZ2uXaqaoZ0
nNVdkL6KDaUdmj4TaeNEOC+0oq1UCJq/Hpj4/BBGSaLSwYa7Qsj0yXXiyPaT
cFb0xaFdDNTo7lT9+YSHO+f+czkpzkJwJ+V7Jt8nO8wWGTp+EwdVdNFS92Ia
LHrPTsz5zYI7O/x6tAoLbm+WbQpumiR1dSsEH/mow3dxX82zdiZcUhs1ck4p
g2vC6J+spcI+enDV2U5FmB9wOhIQMkPikqqM49dlEyFtZvSBSiXsu9Mu2LKr
h6RrbSsVPKCGVr+/lpnruDgqsT17l5UYalIPFmXaCsCaq7nu7L4uYk89rey7
bobQ84rrEqubSELRvuvzIij47+t8ibXPJSDeomsQ9FgV4W/fUZaemyZ2/T26
MfU/iQQJyVgvT8eBDTZxw+/Z+Oj4r/v+WQp0qr5OHD3PQFxOuLCYARPOY7+4
v/q5KNk/lKuaPU5ezl7s+qOZguO7iwYSV7USd7GQVx4MBk6faQ8xtlZH9p0d
fvdqB0haTBR1du0QyTxWZH06n4PpmiwR5RweLIs1KDL6HWSRu0Hd2uv5xGi2
tHteZz95vXOt06L5fN6Yycti9Apjftqu9WEHhfAx75FDgCV/Lma72nlOqeKI
8dsDf9YXk7a8p/RqAVVMm1ZHXrg4RK5+yfpsaDVARmWe7T9cLoTHH0YVvJ8o
IaGb1+2wShnm2m9Xs17wIGFiZNV0spKMMBbqV76Ugem9nJeqrQpIdC91XZaj
iCAfj7z/FCmgbFmm7ijCRFT//U/L34tAOKH/2xJ+vlUY3Z7XTediOnr6XH0i
FwqXemi17jQ4V24/djJQDcee3Fa6bEDFFp4iWXCGChEdu0n5AxyIX7pxxriH
34f3a30zAxQwXXRg7Ow1NgYuptyfsOZ7SPKyoPhuYUhr9Dyw2ywHzrFrBwv4
fNeUYZVjZi6F3qBhLScyTj7mLzUI3zxBnG5YEoevbPiM+3au5P/dstwOxe/z
FFCUbz23drqXSPgafkra1Ui45av3tn8VQequzuhUPhdIDNYmb2ooJwWnrwUs
TBLFLqOxKqXDimDGqelvLKKB/kP/hpG+KkJjNvnmjuURFyuTLJ+AMfJke7tt
nN00abnmFr5jtxo6WgL32lRSMRwQd+BvizCS9n051eXEQ5vZCAko4CKNaG8w
quPve/ndn0/DeVA1tXywdFQeJx0zaQKrR4jHiK9cfjQbaStOqHRd7SMmedus
X36lYzRKeKuJCxNHOoMWpfLnbp+0e/nDF/z3dnE/cclKDWzFwoC9dBUEH//s
NDzK96n9tkaij6hY8V3hzfdKKdCD0wO6POSx8/q3Zp49D7/qpQIc1aWg11tV
aB7RRp5ViG13iOXAZXZ0+7AJEw/nBia8uayCp0ynxZYiLFyNyzx8UF4J1+RX
dkrdUgI6FpxMSfhK6jT6ts1NFEZb+DEPj3MchM5dH1DRVE4cpqJ2WtwRwbGa
ylNZr5jQe294pN68mVi/pMdmCHHwb3L/Tk15OXi9aCiztlXBkLTrx/REfv5e
mqoiDnSUXT7r2RDJww7fz5H3UyXRqfN3t9saGmYMrhi0BPDP8fR63i7nP4TB
3SGurs33+J0fP63N5MGu7t0DnQlVLM8JqK97wu8T05C2Y3FcVJ+MF9W/yIPO
Umao0cY+Mqmk8/0Vj4uYpS8uXXvDgMrDZVuth6mIY3Qwi7/y+0Hjcx43kIei
ewIaY2PTpF7NWZ8hy8C7F9t20Mw1sLr/0YsddcoIX9O2UT65m1Cyy03cnv4g
5z6MX5YVZMGU8zjmYZMiFB9HDFcuZeL+pbjS+jEVqJnoN61xlEC3xvv+sVv8
Xlzi1OqSOEr2LxeVvVGijr8LNc2MzTg4aJv2pCi2k1i0BKzfYaEAAzOybYb/
fkUxjqKTc/m+eVsm2yGYiqnnd0+r2jJxdaHM/T8vGHAUdx34ckgR0ztVJg/Q
KHD8du7z2uLfJKT7ePWTVyyMlm/JO2ogi7WC+b1HfsmBOpO++ayfEloC3oU9
GmHh6W1P/bxUDibXZ+dyx8eJlt5UbqIFD/XNzzqP8f069fMCCfPr8pCi7Qhw
z6fCXyw0TzmhgMRpubgZ7WXDUVM6xfQ4D0qlSoUZ72UhQdFwbTRSwvY5Pvfl
3YQQXnTezqrs//9vKkk/zFPB0l+8AF6kGH4fYuslCFGQcXZaVNi1hqTR3SRf
hXaQWAEBhY9lbNz9s0Wzf58iQo9fs19zWQK28XEsoVIOimqeUEaGv5NAeckz
GrvUsUt6wqfTcITs3D81O7+onzxabvszjKWMzNoItSouE2drf5gbtbBxLmzZ
uc836AiwPXSI7s6G9vqQk9pD6rCrl9g/yfhHqs1XpPif5uKTd9LMoR00aEtE
dnFXjJMmRkTAaz1+f3ca265Yz8CeIx+GzrPUYdL7ZCRdQQbu+74d/sY/h1dW
WjUGn9Xx62NQ89cjPCgOS2z5cZ2FgsB9ijStURLt3jjt/Y+H36pf24fVpBFc
KJ5c6M5ETNuu25tu8L2pyn8rbT0dO187m2bnKsBs8+OMqkVKkKh8XUG510n2
P5tTvDRTGo7SiY2rujh4nTtaX+3IgR1dL7JdQxpL/rzVcBiThdbezW9CtFkw
2xqt9NJLGK6H26doJzg456ReouNMR5Tof1vrKIq4ZKlL/z6bCuW/jx3Hxqno
O17scfczf39k2Ct+FjMw2HPZJLRBBdoRC8sMbw8Rw8aq7qRRLp6+fjb3Xd8Y
2RNouG/iLh2DI90DMQWjxKrh7J68X2wclwl8/secjd8hH/7E7VOGyeqrnVM3
uRB6EVB156cYrp65X4JWNagNDjG8MqfJp3uFsyr65fB+xr9gSxkPF98ZzWLf
kkdbRbO0ThMd7eae3qtdqNjQeV3eroiL1di8LOXeDAlp2iDKEqGjur7KWLGa
P0d/3gnN+kbFF273J41HGqAIZtqtGFHDpSLeq8CtNAya9jVsZIihau3HMwZ9
EnB2VZ85I8BB30mnDWqK8shJPlS2eL8KguZoy+RyhOF+0OPWX0P+figbbZTa
qobQjjCVOVo9RIX9Mb0xboJILFjxorDgLynbnulV0aYIvpIXF7wQR1GpQbQo
v4fCBTwqu75QUTa91mfAsJ30pfxMaLsjhOGt+QcULvDzfvTV+V3X+sncyD5T
1X08dBYkz5NZqgTVUz1bU8fEkRAz2kjLnyCnms3r915Xg5XnqbOb+HzCOple
8aCajpufZERNbihhDludPdo5QDIdv088f0ND62+KW5SYHIJEKxreeg8R+sPX
DinLVPEqcZNuRisL+u3GVhlWHLhvk9Of+cDF4OmQO1+ucaEo3jqqBhHkfF9o
uiH6D5n0Y9lm8b22JpryvP7QN8I0ebqH06YMhVu9v27aSeHNP13FKr6fNCVa
N3Q+Z6OBt/94dKoM2I+GDoXETRK7FRQt/btsXHRIn2V0Qg4qUsknnL+q4ab4
3doTj7hwUvqi4fWei3f5qqWjpyTx9vNN3eUFTAxYOjRodFHRdJjt/yyGA4u2
qrcfDIUg0X+uJOo+E61OMedk1Pm87+6ppuo/TXbOtXmZzOebb6W7nDz5e9FW
9alGNVQY9fpndp67JIHpLSGBwSv6yTGT15VuV+RgbjQ1+yKbi+SqwkOhg2yM
mSmFCUzIYXmrVqf5P1EkO62kfJPn3/ejTaXh6nKIyrTbMH+NKPSeHp36zu9F
3/aTKn1NQlDp6nC7sK+XVLwMra01YyJO2vjRtW1c3PVIC2u/SEd6y/of/7IU
8cSgfst6ZRVUCQ2ILPivn/Te1M6/o60O7tjn2FvaHGTXr/lOn+DA7JnFkEy+
OtQjfiuKvegj2by3D2Jf8lAsrBfJ+zhNKu/leLpny+Hl7BVHWrpEse2Pr9GG
78qY9mDkR3urofPEzKMLvkqgkwcv/h2sJoudrFrPRgjhr8CnOySEjXy90uXs
egmkPxiiBs5iIYN6xmF03i+yOKh1egGHB9vxfr+r+lzsXaYX/vgqHX91pgQ3
lMvhYVOGVLgxG8EXqXWxZQ1EWjz1WQrf47M9Vq5/7UNFRPXgfpNHM8Ql5fp4
6+wpslIjJPZGuyx22on47XdUwz2b0NPKHC4WLeDez60tJpF1aQ5HU5qJfVlX
99cLGphe63kgeDsFmQ9Xm0ycYoJ9L5FiMsXFqEYkLfiDMoLsv6wVGlCG3qre
osL/ZKC+z6i825mDJl6Jx1K2Ov5TXmF2fz4DfeLmJavvSCPyxT+LHb/pWD6Q
/Oky4XtZUkfLz1FleHQeZZv7SOJ4jHl7gV0fkXP2996jxu/RnZLB6Xl8f33q
kxrky0Vo9Irc6W1qSLLj1mvwOS6D1abOu9FF0r9LFsv9o0GTe2lruGYTESsO
UcmcUQT9NGW97C1F6DJkVl3IV8QG4+/pbzs4GG6XX+X7mAqJgg0bVh4aJha3
JR3sb3ORt0p7U8JsDtBql6JVIIbaiOFNtXkS+NhUfCppqJmkKji7zZLl4NL9
X4fDjogj2los3PwCBUUr7oW/+6yEuCA/xubV/4gdbWxlNLWd/HoZfMmIIYWe
oo5rR39LYuVtyT4xPg/ISIXXnzFtJaMh/mW6Wr/I9MTR7Hfr1ZA8L8tEb68a
HOdct97hwUCudF/PvcMccE89Pfk4VBKSNrIeXzxF8VF9SnWHiwauprYaO6bI
49C29v8WtHJhI7z2nI2sIMJtTyyzt2gm6jtqErYksjDTkqtwJ48Hh8FFKz/S
VfFkONN99TYq7pbFxwx/5PP99JW6Vn4eb7n76e9MiRCmQ9rZBX1M6FvdHp8X
p4GfzpbRoe84yHHOaLrR2ERmj0wwL4mxcXD0qOiCI6Mk8VPBDufto2Qvz71D
fzvfI0cLVhncZ0FDx3u2UocwEr2TSpyPqOAwusVF58pjn6DKqE0xBYdmHzbL
uyCAlIK0x8tN5RHm+r6OOsBDyEjxMoVaKTzVkpszd5YGaKZhOumbuIiVkwk9
lCWLC2vOdbStVIFXjULWsS5x6G/Re8TUEcGT5vBVbZEMBL87akY/N0TqFsQO
XCznwa10o2f/IR7ERF8eFfZkwnsvZ+zeFVGE5lcs/lvfTcoOy8iZVnGwMcnl
uHSeGvRe2XR6bWDCLtTRL99IGTO1o/KCYMP8THmh/zcWLEyzohJuKyDJ2/PK
DmU+p492eD3n89vlAOfxQ8858N3zQyE+kY1QD9ELXox6khMQPznfI46krXx3
chafa75smqygv58kaWXXpQWb24nO0sxFg6IcWC/dNHXuUj+RU9r6+0+0Ija+
3vW5t4aFe8Mz27hHZPBxxdfnEXyuWrPU1ckAHEQaKzUFWXPxaPlS/+oxKizm
/R3ZT+GCe/Xur9t/6FA7K6/RnCiPi+IqfrcSxJBpKejtaSUA/9Ds9D1zmsj/
AKniTns=
     "]]}, {}},
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  GridLines->{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 
   9, 10}},
  PlotRange->{{0, 10}, {0, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.393844699787778*^9, 3.3938447243931584`*^9}, 
   3.393848028364035*^9, 3.3938480826020255`*^9, 3.3938487636413116`*^9, 
   3.394187949760717*^9, 3.3942546397962785`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "We use the command ",
 StyleBox["BinCounts", "Input"],
 " to count the number of points occurring within each square of our graphic. \
We output the result as a grid that has been manipulated using ",
 StyleBox["Reverse", "Input"],
 " and ",
 StyleBox["Transpose", "Input"],
 " so that the locations of our counts correspond to those in the plot we \
have just generated:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412064091788314*^9, 3.412064202777909*^9}, 
   3.4123245830771217`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"counts", " ", "=", " ", 
   RowBox[{"BinCounts", "[", 
    RowBox[{"xyPairs", ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Reverse", "[", 
    RowBox[{"Transpose", "[", "counts", "]"}], "]"}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.393752350904125*^9, 3.393752455966625*^9}, {
   3.393752535310375*^9, 3.393752558310375*^9}, {3.393752675076*^9, 
   3.393752720826*^9}, {3.39375275866975*^9, 3.393752868466625*^9}, {
   3.393753428622875*^9, 3.393753452372875*^9}, {3.39375349098225*^9, 
   3.393753528872875*^9}, {3.3937535617635*^9, 3.393753604966625*^9}, {
   3.393753685247875*^9, 3.393753791841625*^9}, {3.393753840716625*^9, 
   3.393753846701*^9}, {3.39375388673225*^9, 3.3937539253885*^9}, 
   3.393753969701*^9, {3.393753999997875*^9, 3.393754169310375*^9}, {
   3.39375420904475*^9, 3.39375426366975*^9}, {3.393757549591625*^9, 
   3.39375757685725*^9}, {3.3937576868885*^9, 3.39375771804475*^9}, {
   3.3938442192668223`*^9, 3.393844233036622*^9}, 3.393845408536909*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"7", "12", "9", "8", "9", "9", "6", "12", "11", "13"},
    {"10", "7", "14", "14", "7", "7", "11", "11", "5", "12"},
    {"11", "6", "11", "11", "12", "17", "7", "9", "14", "8"},
    {"10", "14", "7", "11", "4", "9", "8", "8", "13", "11"},
    {"10", "11", "7", "13", "10", "9", "13", "14", "13", "10"},
    {"11", "5", "10", "13", "14", "6", "13", "11", "12", "8"},
    {"4", "7", "9", "17", "5", "9", "16", "11", "14", "6"},
    {"14", "8", "9", "10", "11", "7", "3", "11", "6", "11"},
    {"9", "11", "11", "14", "7", "7", "8", "8", "16", "7"},
    {"14", "8", "8", "14", "7", "7", "14", "11", "7", "16"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 CellChangeTimes->{3.3938454097486515`*^9, 3.3938467279341087`*^9, 
  3.39384802853428*^9, 3.3938480827221985`*^9, 3.393848763771499*^9, 
  3.39418797182244*^9, 3.3942546399765377`*^9}]
}, Open  ]],

Cell[TextData[{
 "We flatten the structure of the list ",
 StyleBox["counts", "Input"],
 " and use total to check that we have captured each of the points we \
initially generated. We then determine the maximum and minimum number of \
points in a square for our sample and compute the mean and variance:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120642409327726`*^9, 3.412064318524344*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"counts", " ", "=", " ", 
   RowBox[{"Flatten", "[", "counts", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", "counts", "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Min", "[", "counts", "]"}], ",", 
   RowBox[{"Max", "[", "counts", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mean", "[", "counts", "]"}], ",", 
   RowBox[{"Variance", "[", "counts", "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.393752350904125*^9, 3.393752455966625*^9}, {
   3.393752535310375*^9, 3.393752558310375*^9}, {3.393752675076*^9, 
   3.393752720826*^9}, {3.39375275866975*^9, 3.393752868466625*^9}, {
   3.393753428622875*^9, 3.393753452372875*^9}, {3.39375349098225*^9, 
   3.393753528872875*^9}, {3.3937535617635*^9, 3.393753604966625*^9}, {
   3.393753685247875*^9, 3.393753791841625*^9}, {3.393753840716625*^9, 
   3.393753846701*^9}, {3.39375388673225*^9, 3.3937539253885*^9}, 
   3.393753969701*^9, {3.393753999997875*^9, 3.393754169310375*^9}, {
   3.39375420904475*^9, 3.39375426366975*^9}, {3.393757549591625*^9, 
   3.39375757685725*^9}, {3.3937576868885*^9, 3.39375771804475*^9}, {
   3.3938442192668223`*^9, 3.393844233036622*^9}, 3.393845408536909*^9, {
   3.3938470505880623`*^9, 3.3938471037444973`*^9}, {3.3938472096167345`*^9, 
   3.393847242554096*^9}, {3.3938474911315327`*^9, 3.3938475200731487`*^9}, {
   3.3938479154116173`*^9, 3.39384793540036*^9}, 3.393848032319723*^9}],

Cell[BoxData["1000"], "Output",
 CellChangeTimes->{{3.3938472316984863`*^9, 3.3938472429847155`*^9}, 
   3.393847520704056*^9, 3.3938479363116703`*^9, 3.393848028594366*^9, 
   3.3938480827822847`*^9, 3.3938487638416*^9, 3.394187990899872*^9, 
   3.394254640036624*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "17"}], "}"}]], "Output",
 CellChangeTimes->{{3.3938472316984863`*^9, 3.3938472429847155`*^9}, 
   3.393847520704056*^9, 3.3938479363116703`*^9, 3.393848028594366*^9, 
   3.3938480827822847`*^9, 3.3938487638416*^9, 3.394187990899872*^9, 
   3.3942546400666676`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", 
   FractionBox["320", "33"]}], "}"}]], "Output",
 CellChangeTimes->{{3.3938472316984863`*^9, 3.3938472429847155`*^9}, 
   3.393847520704056*^9, 3.3938479363116703`*^9, 3.393848028594366*^9, 
   3.3938480827822847`*^9, 3.3938487638416*^9, 3.394187990899872*^9, 
   3.3942546401167393`*^9}]
}, Open  ]],

Cell[TextData[{
 "The command ",
 StyleBox["Tally", "Input"],
 " counts the occurrence of each element in our list ",
 StyleBox["counts", "Input"],
 ". From the output we observe that one zone contains 3 points, two zones \
contain 4 points, five zones contain 12 points, ",
 StyleBox["etc",
  FontSlant->"Italic"],
 "."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120643359494*^9, 3.412064353875176*^9}, {
  3.412064393832632*^9, 3.412064431056157*^9}, {3.41206449567908*^9, 
  3.4120645438783875`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"barcounts", " ", "=", " ", 
  RowBox[{"Sort", "[", 
   RowBox[{"Tally", "[", "counts", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.3938473587111216`*^9, 3.393847361625312*^9}, {
  3.3938480416932015`*^9, 3.3938480684717073`*^9}, {3.393848744714096*^9, 
  3.3938487528057313`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.3938480832930193`*^9, 3.3938487639717875`*^9, 
  3.394187995786899*^9, 3.3942546401567965`*^9}]
}, Open  ]],

Cell[TextData[{
 "To obtain a bar chart of our data, we use ",
 StyleBox["BarChart", "Input"],
 " to plot the second element of our list (the frequency) and use the first \
element of our list to generate labels for the bars: "
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412064574943056*^9, 3.412064649730595*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"barcounts", " ", "=", " ", 
  RowBox[{"Transpose", "[", "barcounts", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"barcounts", "[", 
    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
   RowBox[{"BarLabels", "\[Rule]", 
    RowBox[{"barcounts", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"barcounts", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.3938473587111216`*^9, 3.393847361625312*^9}, {
  3.3938480416932015`*^9, 3.3938480684717073`*^9}, {3.3938487478686323`*^9, 
  3.393848749531022*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", ",", "9", ",", 
     "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "16", ",", "17"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "5", ",", "15", ",", "10", ",", "10", ",", 
     "7", ",", "18", ",", "5", ",", "7", ",", "12", ",", "3", ",", "2"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.3938479757383633`*^9, 3.3938480291051006`*^9, 
  3.393848083463264*^9, 3.393848764442464*^9, 3.3941880112691617`*^9, 
  3.3942546406975746`*^9}],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0.615, 0}, {1.385, 1}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{1.615, 0}, {2.385, 2}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{2.615, 0}, {3.385, 3}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{3.615, 0}, {4.385, 5}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{4.615, 0}, {5.385, 15}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{5.615, 0}, {6.385, 10}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{6.615, 0}, {7.385, 10}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{7.615, 0}, {8.385, 7}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{8.615, 0}, {9.385, 18}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{9.615, 0}, {10.385, 5}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{10.615, 0}, {11.385, 7}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{11.615, 0}, {12.385, 12}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{12.615, 0}, {13.385, 3}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{13.615, 0}, {14.385, 2}]}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->None,
  AxesOrigin->{0.3999999999999999, 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->{{{1, 
      FormBox["3", TraditionalForm], 0}, {2, 
      FormBox["4", TraditionalForm], 0}, {3, 
      FormBox["5", TraditionalForm], 0}, {4, 
      FormBox["6", TraditionalForm], 0}, {5, 
      FormBox["7", TraditionalForm], 0}, {6, 
      FormBox["8", TraditionalForm], 0}, {7, 
      FormBox["9", TraditionalForm], 0}, {8, 
      FormBox["10", TraditionalForm], 0}, {9, 
      FormBox["11", TraditionalForm], 0}, {10, 
      FormBox["12", TraditionalForm], 0}, {11, 
      FormBox["13", TraditionalForm], 0}, {12, 
      FormBox["14", TraditionalForm], 0}, {13, 
      FormBox["16", TraditionalForm], 0}, {14, 
      FormBox["17", TraditionalForm], 0}}, Automatic},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.3999999999999999, 14.6}, All},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{1, 
      FormBox["3", TraditionalForm], 0}, {2, 
      FormBox["4", TraditionalForm], 0}, {3, 
      FormBox["5", TraditionalForm], 0}, {4, 
      FormBox["6", TraditionalForm], 0}, {5, 
      FormBox["7", TraditionalForm], 0}, {6, 
      FormBox["8", TraditionalForm], 0}, {7, 
      FormBox["9", TraditionalForm], 0}, {8, 
      FormBox["10", TraditionalForm], 0}, {9, 
      FormBox["11", TraditionalForm], 0}, {10, 
      FormBox["12", TraditionalForm], 0}, {11, 
      FormBox["13", TraditionalForm], 0}, {12, 
      FormBox["14", TraditionalForm], 0}, {13, 
      FormBox["16", TraditionalForm], 0}, {14, 
      FormBox["17", TraditionalForm], 0}}, Automatic},
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.3938479757383633`*^9, 3.3938480291051006`*^9, 
  3.393848083463264*^9, 3.393848764442464*^9, 3.3941880112691617`*^9, 
  3.394254640887848*^9}],

Cell[BoxData["100"], "Output",
 CellChangeTimes->{3.3938479757383633`*^9, 3.3938480291051006`*^9, 
  3.393848083463264*^9, 3.393848764442464*^9, 3.3941880112691617`*^9, 
  3.3942546409279056`*^9}]
}, Open  ]],

Cell["\<\
To obtain a better understanding of our point process, we must consider more \
than the 1000 points we have generated so far. In the following code we \
generate 10 000 points and investigate the influence dividing our region into \
contiguous squares of different sizes:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412064698931342*^9, 3.4120648304805007`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NCentres", " ", "=", " ", "10000"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xyPairs", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "10"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"NCentres", ",", " ", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"counts", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"BinCounts", "[", 
      RowBox[{"xyPairs", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "10", ",", 
         RowBox[{"10", "/", "Nsquares"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "10", ",", 
         RowBox[{"10", "/", "Nsquares"}]}], "}"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"Nsquares", ",", " ", "10", ",", " ", "100"}], "}"}]}], "]"}]}],
   ";"}]}], "Input",
 CellChangeTimes->{{3.393752350904125*^9, 3.393752455966625*^9}, {
   3.393752535310375*^9, 3.393752558310375*^9}, {3.393752675076*^9, 
   3.393752720826*^9}, {3.39375275866975*^9, 3.393752868466625*^9}, {
   3.393753428622875*^9, 3.393753452372875*^9}, {3.39375349098225*^9, 
   3.393753528872875*^9}, {3.3937535617635*^9, 3.393753604966625*^9}, {
   3.393753685247875*^9, 3.393753791841625*^9}, {3.393753840716625*^9, 
   3.393753846701*^9}, {3.39375388673225*^9, 3.39375391854475*^9}, 
   3.393753955701*^9, {3.39375433260725*^9, 3.393754557279125*^9}, {
   3.393754592185375*^9, 3.393754647560375*^9}, {3.393754700216625*^9, 
   3.393754909451*^9}, {3.39375504279475*^9, 3.393755042966625*^9}, 
   3.3937550777635*^9, 3.393755131154125*^9, 3.39375516335725*^9, {
   3.39375545241975*^9, 3.393755458622875*^9}, {3.393755499076*^9, 
   3.393755514701*^9}, {3.3941881856398945`*^9, 3.394188188804445*^9}, {
   3.3941884016204596`*^9, 3.39418840303249*^9}, {3.394189095237832*^9, 
   3.394189133112293*^9}, {3.394189565463984*^9, 3.39418959165164*^9}, {
   3.3941903840810976`*^9, 3.394190384812149*^9}, {3.3941904437969646`*^9, 
   3.3941904454893985`*^9}, {3.394190518714691*^9, 3.3941905388836927`*^9}, {
   3.394190848098322*^9, 3.394190865162859*^9}, {3.3941909317586193`*^9, 
   3.394190933000405*^9}}],

Cell[TextData[{
 "The computation of mean and variance is much quicker if we use numerical \
precision, so we apply ",
 StyleBox["N", "Input"],
 " after flattening our sublists for each size of square considered and then \
compute the mean and variance:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120648546853056`*^9, 3.412064955510285*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FC", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"counts", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", " ", 
        RowBox[{"Length", "[", "counts", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"MeanVar", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Mean", "[", 
        RowBox[{"FC", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
       RowBox[{"Variance", "[", 
        RowBox[{"FC", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "1", ",", " ", 
       RowBox[{"Length", "[", "FC", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.393752350904125*^9, 3.393752455966625*^9}, {
   3.393752535310375*^9, 3.393752558310375*^9}, {3.393752675076*^9, 
   3.393752720826*^9}, {3.39375275866975*^9, 3.393752868466625*^9}, {
   3.393753428622875*^9, 3.393753452372875*^9}, {3.39375349098225*^9, 
   3.393753528872875*^9}, {3.3937535617635*^9, 3.393753604966625*^9}, {
   3.393753685247875*^9, 3.393753791841625*^9}, {3.393753840716625*^9, 
   3.393753846701*^9}, {3.39375388673225*^9, 3.39375391854475*^9}, 
   3.393753955701*^9, {3.39375433260725*^9, 3.393754557279125*^9}, {
   3.393754592185375*^9, 3.393754647560375*^9}, {3.393754700216625*^9, 
   3.393754909451*^9}, {3.39375504279475*^9, 3.393755042966625*^9}, 
   3.3937550777635*^9, 3.393755131154125*^9, 3.39375516335725*^9, {
   3.39375545241975*^9, 3.393755458622875*^9}, {3.393755499076*^9, 
   3.393755514701*^9}, {3.3941881856398945`*^9, 3.394188188804445*^9}, {
   3.3941884016204596`*^9, 3.39418840303249*^9}, 3.394189095237832*^9, {
   3.3941912676516094`*^9, 3.394191270545771*^9}}],

Cell["\<\
A plot of the variance against the mean has close to unit gradient:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4120649675876513`*^9, 3.412065015226152*^9}, {
   3.4120650472221603`*^9, 3.412065048403859*^9}, 3.4123245858310814`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{"MeanVar", ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"AbsolutePointSize", "[", "4", "]"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Mean\>\"", ",", " ", "\"\<Variance\>\""}], "}"}]}], ",", 
     " ", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], ",", " ", 
   RowBox[{"LogLogPlot", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0.1", ",", " ", "100"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.393755201404125*^9, 3.3937552228885*^9}, {
  3.393755561529125*^9, 3.393755601576*^9}, {3.394188325130472*^9, 
  3.3941883389904013`*^9}, {3.394188373600168*^9, 3.3941883809407234`*^9}, {
  3.3941884279883747`*^9, 3.394188537455781*^9}, {3.3941905599640045`*^9, 
  3.3941905651915216`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], AbsolutePointSize[4], PointBox[CompressedData["
1:eJwtkXk4FHgcxmfcx5RMoskqSopypFJT6fubsdosK0YIIy1RjrIixqOTypOy
SYcoWbMU0qAoiZzlHE25JcZgIudgDsOMbav3ed7n/fd9P6+edzDFVwaDwXh8
8/+p6Vz0uiAQjwys+YvMcDzqOzVafj5LHV3eNJkTUqiOGKpJJXaCZYjeWBB2
eYM66tYh2nlRliGFC8cC5FyXIcXP6yvNT6uhE/lLPBMq1NDKml1nUtyXIuOw
u4RdpCWIxmZPIcoSJGjacKsmAoe8ndkBk244NNFzcvNvAThks0UayQpWRV5/
GFDS6lWRZLyR456ogkpO09emCFXQ1vhxIalCGd3hmyqH9SujWQH/rb9ICRXH
Ir9skjKqrXPD9BKVkHZP8qhHkBIKH9sy0xCjiBBPalI3o4h8xfn8iDYFVF6u
vLhIVESTRLGUbKKA8Ka6D4p8FVDpav7K1Hh5dORosHzUMXlkYdt8TnFGDj1p
UbUxOiuHllVkkdQPy6GI0Eu2bGM5RDhEdHVulkWOIVksnU5ZpPu4bIFmJYse
T05YzRvIIrrkmadRmQyy5hZkru6RQReqfULW7JZBp00SKSEBMqiQYyi/ogyL
1v7uur9whQwK3OkzyiRjEb/yq+mBUCxqDCraj2/CoJpN2nue38AiisZFMeMQ
Br031L25PACDXl4t1//KWgQTDU1Pgj4GqdJT350SSIFbZ3A/9MMiOIXE7c7S
kwKJ5C4Wh0vhB38J2AQ7b2EYSCBcGFwril0A+WJa+xdtCcw9511PqJqH4msT
6mqV83Bc5HKZiZ0HIgrB73SZhzTXV9hIazGYtlaXtbuLQTtaW/ZI/BxsjmE8
NYgUg+Sh/xdKlwj8qol+hulz0DLkt2a9oQhCqcyoQq4QukuOjeWeEcIBRNuO
i/mW0K9f3SKAjfkpLoIIIfz4QwAfNP19nr7lQ36GH1v5Oh9W+eOo2FA+xMlO
mQvHZmG0i/6PwyE+YF/oWY45zIKjCss5vX0WzlLp0saXMzBVuqao+dwMaBV8
VIvSm4FLOtJfLRamwWyf66W++GlIM3Z4kzwwDUNtliz2Ag+e2Siq1TtNAzmc
lnfsJA/0I5vX24zwgEsNUTvMmYKD0bldN/154Pid/xTwz09GpjZNwbUEE5V4
+iSgVddEF8wnISe6g7bu3gRsGmkIXX1lAh69X2csuTkOmXMC1e33x2FtSkqt
8MYYkLUaHwXFjYNsCT56+uYoWEokwnXGo8DTfK7ZnPQVJG07Mmx9RiFmb2tW
UPoIHK2y8Xl1bQSYJ+7lFTCGgdvbQNbKGwFG5nLOxfIvkENJDLRnf/nJkwv2
nywrfTlcqB9UjKSODgFOy4z4J20Ijn9WG9uuMAQPCjsuWiwMAp9ifnWn/iBo
vSAm1wQPQkJanK299QA4Klj3bE0bgMRP29S9/TmQ+c6px7eSAztY+254JfRD
/Cmv67v7+iHVOHHf1hI2uPnhiCpG/ZDwGU3fZvaBhp7ozuuDbHAIK0QGm3tB
wzI3wpXQ+3N/D6Reyd+4l9wLniQVvWFRN1Dznb0y/uoBgqBdr8OvC34hL61K
cumGKLx9Q2ZXB+imXzXbbdsJG4Y/77BwbAc5lqt3ErkdIkh3kwKZrZBu5DJ/
hdAGA3OnCEb2LYA1ypqL5XyEkCzvQZeWD/C+FRe3Y5gFFeELKp1UFiQb23Ht
ut8DK/YZ1rCNCeNuOvhS82bw+N6nAcYqKUrZ7Q3AXCH9941+HWDS6BF9A/UQ
uDHK6vyht3BdXcmll1MLZ7K9zKS3qsBpRtdQV7UG9rxpUFjLKAfKnkmT2OEK
sCQ0eehYlYDhrQcMj22vIHdpZ/tDbiFIjoOPN60YaDrKrGdmeeB5hjD20IIB
4ifsUrn8DMhZwxus8M+GzNbgvdZ3bgO1MLzOA/83YH6qtNy2djotCP4DKSLA
rw==
      "]]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxNxXlIk2EcAOA5z2VNM9IIxTxQGzbxaCqJW8dMyKkrnAeS1ijnlfeRWkF2
DGqiObSZmc2UaRN1MN1U+ozQNHCaBzHENKLhNMQDc7oxKvj8fe8fD4/Hzbyr
t8gkEin2n/9nVk7I+rLJIwe7Si+tpGQQa8YxXys+cZBzfwcvhdjUK31njCau
0VW2sn2IFVz6S+2yBWzyrX9qwSNuGp7T7viRYC1Gkw66m7GDS9Pa1bUGI3x6
ykHVI92D2anlJGXxLlymng6wPLEDv83zFCaNbcHBFwtp4uYNeGCSnxEo/A1r
45aO2PquwKvVHJu1hZ+YHp/by5B8vP0di8fP1XzhRCnnsTv4E8kREYt149hn
/Lm7Ay+a2TJsFj+Cv8RWp/UzGfjGEWqwVjfJ3Md/Xtii5vZ8Y4rw3T2NLZT6
ZZiSHOKQGvYL9kooWPsh0jO98R37NHvzrHXYWe8yaOZuwt2n4mKflW/DZ4QN
Rs3kDsyeWbrub9yFo2LCF1iJ+3BcroQeKzPBG/nG0JKvZjhyhtHdKSaxDo5f
zJe0yy1g3Tn6phtGhgsURfObK5Zw9MlB8YzZCj7WJFym+tvANPsk2yS2LTw6
1SVxS7aDE+SPVZGPKHBgxQ1FzqtDMDl9NOzPhD2cKJHTTFuHYcMn8S7VjgqL
bKy590Ic4FC3oQtVPo6wPl3pZOghbujdlnmwj8L6coWcO03M4ChLAzKcYGlJ
24PzyNSWOuE1ZN16blMZcmOtzwcM2TDbaB0vIB5KqRDnZxL7VQteP0QWv+d1
iJFzTEEqFbJry9oCKYv4/o9UrzrkVcoV/zZkXlD4WSUyvfr4ZS3ykrcmyyOb
OIYzXBSMrCrpqmIj1449qclENq0XN1YiC1z4rSLkOSa38w0yS8BU9CH/BSGt
SLU=
      "]]}}},
  Axes->True,
  AxesLabel->{
    FormBox["\"Mean\"", TraditionalForm], 
    FormBox["\"Variance\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  FrameTicks->{{{{0, 
       FormBox["1", TraditionalForm]}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox["2", TraditionalForm]}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox["5", TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["10", TraditionalForm]}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox["20", TraditionalForm]}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox["50", TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox["100", TraditionalForm]}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox["200", TraditionalForm]}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox["500", TraditionalForm]}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{0, 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox["\" \"", TraditionalForm]}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {{{0, 
       FormBox["1", TraditionalForm]}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox["2", TraditionalForm]}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox["5", TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["10", TraditionalForm]}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox["20", TraditionalForm]}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox["50", TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox["100", TraditionalForm]}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox["200", TraditionalForm]}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox["500", TraditionalForm]}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{0, 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox["\" \"", TraditionalForm]}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{0., 4.605170185988092}, {0., 4.616020202012157}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{0, 
      FormBox["1", TraditionalForm]}, {
      NCache[
       Log[2], 0.6931471805599453], 
      FormBox["2", TraditionalForm]}, {
      NCache[
       Log[5], 1.6094379124341003`], 
      FormBox["5", TraditionalForm]}, {
      NCache[
       Log[10], 2.302585092994046], 
      FormBox["10", TraditionalForm]}, {
      NCache[
       Log[20], 2.995732273553991], 
      FormBox["20", TraditionalForm]}, {
      NCache[
       Log[50], 3.912023005428146], 
      FormBox["50", TraditionalForm]}, {
      NCache[
       Log[100], 4.605170185988092], 
      FormBox["100", TraditionalForm]}, {
      NCache[
       Log[200], 5.298317366548036], 
      FormBox["200", TraditionalForm]}, {
      NCache[
       Log[500], 6.214608098422191], 
      FormBox["500", TraditionalForm]}, {1.0986122886681098`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.791759469228055, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9459101490553132`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.4011973816621555`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.6888794541139363`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.0943445622221, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.248495242049359, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.382026634673881, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.499809670330265, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.703782474656201, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.991464547107982, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, {{0, 
      FormBox["1", TraditionalForm]}, {
      NCache[
       Log[2], 0.6931471805599453], 
      FormBox["2", TraditionalForm]}, {
      NCache[
       Log[5], 1.6094379124341003`], 
      FormBox["5", TraditionalForm]}, {
      NCache[
       Log[10], 2.302585092994046], 
      FormBox["10", TraditionalForm]}, {
      NCache[
       Log[20], 2.995732273553991], 
      FormBox["20", TraditionalForm]}, {
      NCache[
       Log[50], 3.912023005428146], 
      FormBox["50", TraditionalForm]}, {
      NCache[
       Log[100], 4.605170185988092], 
      FormBox["100", TraditionalForm]}, {
      NCache[
       Log[200], 5.298317366548036], 
      FormBox["200", TraditionalForm]}, {
      NCache[
       Log[500], 6.214608098422191], 
      FormBox["500", TraditionalForm]}, {1.0986122886681098`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.791759469228055, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9459101490553132`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.4011973816621555`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.6888794541139363`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.0943445622221, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.248495242049359, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.382026634673881, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.499809670330265, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.703782474656201, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.991464547107982, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellChangeTimes->{3.394191531240632*^9, 3.3942546455545588`*^9}]
}, Open  ]],

Cell[TextData[{
 "We saw in Chapter 2 that the Poisson distribution has variance equal to the \
mean. When ",
 StyleBox["NSquares", "Input"],
 " = 50, the expected number of points per square is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"10000", "/", 
     SuperscriptBox["50", "2"]}], " ", "=", " ", "4"}], TraditionalForm]]],
 ". The data for ",
 StyleBox["NSquares", "Input"],
 " = 50 occurs at element 41 of our list, so we compare a bar chart of those \
data with the probability function for the Poisson distribution with mean 4. \
The agreement is excellent:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120650219257855`*^9, 3.4120652593271523`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"barcounts", " ", "=", 
   RowBox[{"Sort", "[", 
    RowBox[{"Tally", "[", 
     RowBox[{"FC", "[", 
      RowBox[{"[", "41", "]"}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"barcounts", " ", "=", 
   RowBox[{"Transpose", "[", "barcounts", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"frequencies", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"barcounts", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "/", 
     RowBox[{"Length", "[", 
      RowBox[{"FC", "[", 
       RowBox[{"[", "41", "]"}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PoissonFrequencies", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "+", "1"}], ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"PoissonDistribution", "[", "4", "]"}], ",", " ", "x"}], 
        "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "13"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"BarChart", "[", 
    RowBox[{"frequencies", ",", " ", 
     RowBox[{"BarLabels", "\[Rule]", 
      RowBox[{"barcounts", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", "PoissonFrequencies", "]"}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", " ", "True", ",", "False", ",", " ", "False"}], 
     "}"}]}], " ", ",", " ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Number of points\>\"", ",", " ", "\"\<Frequency\>\""}], 
     "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.394190778187795*^9, 3.3941907930291357`*^9}, 
   3.39419090838501*^9, {3.3941937543272734`*^9, 3.39419383334089*^9}, {
   3.394193881830614*^9, 3.3941939176320944`*^9}, {3.3941940029948397`*^9, 
   3.3941940456962414`*^9}, {3.394194127323616*^9, 3.394194147382459*^9}, {
   3.394194379726554*^9, 3.3941944296383233`*^9}, {3.3941944820336637`*^9, 
   3.3941947499088497`*^9}, {3.394194787643109*^9, 3.3941947916088114`*^9}, {
   3.394195165546507*^9, 3.3941951674692717`*^9}, {3.394195432129835*^9, 
   3.3941955087199664`*^9}, {3.394254481288355*^9, 3.3942545010267377`*^9}, {
   3.394254635409971*^9, 3.3942546371424627`*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{0.615, 0}, {1.385, 0.0164}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{1.615, 0}, {2.385, 0.068}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{2.615, 0}, {3.385, 0.156}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{3.615, 0}, {4.385, 0.1884}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{4.615, 0}, {5.385, 0.2048}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{5.615, 0}, {6.385, 0.1516}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{6.615, 0}, {7.385, 0.1024}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{7.615, 0}, {8.385, 0.0672}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{8.615, 0}, {9.385, 0.028}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{9.615, 0}, {10.385, 0.0076}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{10.615, 0}, {11.385, 0.0068}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{11.615, 0}, {12.385, 0.0016}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{12.615, 0}, {13.385, 0.0008}]}, 
    {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
     RectangleBox[{13.615, 0}, {14.385, 0.0004}]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{1., 0.01831563888873418}, {2., 0.07326255555493671}, {3., 
      0.14652511110987343`}, {4., 0.19536681481316456`}, {5., 
      0.19536681481316456`}, {6., 0.15629345185053165`}, {7., 
      0.1041956345670211}, {8., 0.059540362609726345`}, {9., 
      0.029770181304863173`}, {10., 0.0132311916910503}, {11., 
      0.0052924766764201195`}, {12., 0.00192453697324368}, {13., 
      0.00064151232441456}, {14., 0.00019738840751217228`}}]}}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->None,
  AxesOrigin->{0.3999999999999999, 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->{True, True, False, False},
  FrameLabel->{
    FormBox["\"Number of points\"", TraditionalForm], 
    FormBox["\"Frequency\"", TraditionalForm]},
  FrameStyle->{},
  FrameTicks->{{{1, 
      FormBox["0.`", TraditionalForm], 0}, {2, 
      FormBox["1.`", TraditionalForm], 0}, {3, 
      FormBox["2.`", TraditionalForm], 0}, {4, 
      FormBox["3.`", TraditionalForm], 0}, {5, 
      FormBox["4.`", TraditionalForm], 0}, {6, 
      FormBox["5.`", TraditionalForm], 0}, {7, 
      FormBox["6.`", TraditionalForm], 0}, {8, 
      FormBox["7.`", TraditionalForm], 0}, {9, 
      FormBox["8.`", TraditionalForm], 0}, {10, 
      FormBox["9.`", TraditionalForm], 0}, {11, 
      FormBox["10.`", TraditionalForm], 0}, {12, 
      FormBox["11.`", TraditionalForm], 0}, {13, 
      FormBox["12.`", TraditionalForm], 0}, {14, 
      FormBox["13.`", TraditionalForm], 0}}, Automatic},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.3999999999999999, 14.6}, All},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{1, 
      FormBox["0.`", TraditionalForm], 0}, {2, 
      FormBox["1.`", TraditionalForm], 0}, {3, 
      FormBox["2.`", TraditionalForm], 0}, {4, 
      FormBox["3.`", TraditionalForm], 0}, {5, 
      FormBox["4.`", TraditionalForm], 0}, {6, 
      FormBox["5.`", TraditionalForm], 0}, {7, 
      FormBox["6.`", TraditionalForm], 0}, {8, 
      FormBox["7.`", TraditionalForm], 0}, {9, 
      FormBox["8.`", TraditionalForm], 0}, {10, 
      FormBox["9.`", TraditionalForm], 0}, {11, 
      FormBox["10.`", TraditionalForm], 0}, {12, 
      FormBox["11.`", TraditionalForm], 0}, {13, 
      FormBox["12.`", TraditionalForm], 0}, {14, 
      FormBox["13.`", TraditionalForm], 0}}, Automatic},
  TicksStyle->{}]], "Output",
 CellChangeTimes->{{3.394190784306594*^9, 3.394190793850317*^9}, 
   3.394190908595312*^9, {3.3941937559496064`*^9, 3.3941937688581676`*^9}, {
   3.3941938171576195`*^9, 3.3941938284338336`*^9}, {3.394193907417406*^9, 
   3.394193918252987*^9}, {3.39419402652868*^9, 3.3941940460968175`*^9}, {
   3.3941941351849203`*^9, 3.3941941480634384`*^9}, {3.394194390271717*^9, 
   3.3941944308700943`*^9}, {3.39419451639307*^9, 3.394194545104355*^9}, 
   3.394194606913232*^9, {3.394194642344179*^9, 3.394194683673608*^9}, {
   3.394194714938565*^9, 3.3941947505097136`*^9}, 3.394195170203203*^9, {
   3.3941954342128305`*^9, 3.394195437978245*^9}, {3.394195480970064*^9, 
   3.394195519695749*^9}, 3.394254645774875*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Whereas the expected number of points ",
 StyleBox["per unit area ",
  FontSlant->"Italic"],
 "is unaffected by the size of the squares (inspection zones) that we use to \
partition the plane, the variance of the number of points per unit area ",
 StyleBox["is ",
  FontSlant->"Italic"],
 "affected and decays exponentially with the size of the squares."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120652943274803`*^9, 3.412065410674779*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sides", " ", "=", " ", 
   RowBox[{"10", "/", 
    RowBox[{"Range", "[", 
     RowBox[{"10", ",", " ", "100"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FCpua", " ", "=", " ", 
   RowBox[{"FC", "/", 
    SuperscriptBox["sides", "2"]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.3942566572973022`*^9, 3.394256690014347*^9}, {
   3.394256725605525*^9, 3.3942568277423906`*^9}, {3.3942588117953186`*^9, 
   3.3942588453635874`*^9}, 3.394267815772402*^9, 3.412065265175562*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Varpua", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Variance", "[", 
      RowBox[{"FCpua", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "1", ",", " ", 
       RowBox[{"Length", "[", "FCpua", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"sides", ",", "Varpua"}], "}"}], "]"}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "True", ",", " ", "False", ",", "False"}], "}"}]}], 
   ",", " ", 
   RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Size of inspection zone\>\"", ",", " ", "\"\<Variance\>\""}], 
     "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.3942566572973022`*^9, 3.394256690014347*^9}, {
   3.394256725605525*^9, 3.3942568277423906`*^9}, {3.3942588117953186`*^9, 
   3.3942588453635874`*^9}, 3.394267815772402*^9, 3.3942679364659505`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwtkws0lGkYx5HYSmFXUYROtLVbe3YSyw49z6mIGc6exqmtpq1NI1NuscXR
BUUui12rSZidchdNuabMhblhUmqGkEsqJ5m0o+Jss5Vqh97/eb7znvc95/u+
5/n/f++KoEhGsJGBgQFT/8ysn/UKfKx/Oar23oWzi7UW6Nr1z4cK9uKVqhmN
Q/EQa51mJAj703kP0nka6OwFeq57MN4IH2wMH3wGLgxvhm3oIdw+q1GI0B8L
k9j4+ftPIc1LttFcHobdXTMaAacB0C5wjcZou/You/YnYM1kHQ5afQzjFo66
cvoeg/22VzFNDbHk/ceQ7uY8wGHH4cWxOH0NQ43h5JGJ7JOk34fwdg+bRzdM
QPHzgMjj3YPA1tjpBo+dJv0PwKM3vkO9Y2ewIH9G/eDqm7TB3TKZzPMAOD2W
KZ6iZNx0Yp7WuaEPWEJHZe/ps2S+Xojn0+xWTqTiyWX7myoseyFQedn7B/bv
ZN4eKPBXZ6SKMrCMw6CtKbsPQWdMp6xO/UH6vw9vK5Vd4n3ZGHwuwK2f1Q3N
/uZzixV/ET+6YI+fdWJXfA7mOPnpqwus9HIyP0/8UcM9VjfXLYyDMqu3fFt/
NVwIFpmp5+YSv1RwlntQS+28gNkmh/SlgofLvSIttuSR/6vg6SLe4q2iPHR3
SJqiuN8D46yBBD8ql/h5F8Sa7V+ys7gYtXXIMlbRCV7Gah+jeB7xtxM+BPh5
JrIv4mw7UXeAHnHvpU5aSPy+DZrUZOkFZhGG3491G6feBluz1o3j7wqJ/x0Q
vrLn0lrTYkxre6fa6dABNerowkMpJSSPW2AzVWk9Na8El87qFnyY1j0OWF9K
8lFCAK4TcKvLcHLHG4/SVUq4vHdh7WF+OcmrHW6oPDeExpbjZ47bofqF4JpL
aAXJrw1eH+ygVxhXon8Ihdd6tA22lPFoO7WVJM82sI938nhmdQVVRxi60dpW
UNI280ps+STfVnA0Hkivm+DjLQt+Sed7BZiocyLG+HyStwJ2fPwi01Z3Fa28
t+lLAS84fdMv51cT/xXwmv4ibU1CDVpRa7+i1soh8zuBJjCghvAgh6dmjPl/
RtViYXTMgpZlcvBPujvicKqW8CGDDY+2ecwpqcM1r11o05kyyHA8UbGUX0d4
kcGHngxj+dp6HMPixW6mMkgbTtwtPlxP+JGCzeka5lWPBsy0oQQp0qTQvj7U
eZ/RdcKTFEaDdfSwwutoOSspFKwal8tcGwlfEuDTfuobbm/EHfGb/j5/SQK+
cq+RhOM3CG8S2Eih5rosuYlsx2+W97tI4Fx2rkHfrptkfglU5Ruu1lxpwp2l
Zp4PC1rAV8lUuXgICI8t8K/PrxT7CgFyXvkEjvU1Q7JNS/U/NkLCZzN8n1Cg
akgXov2smmHaMEFSsltEeBVDUdwzVk69CN919hY9ChOD6Ml41dfOYsKvGB6o
G+ceWNCMd/Yv+i1PLoIjPx7Qlpu2EJ5FQOW+/y+dq9/LVuhLBEYMh2tBwRLC
txDOW79p7BmSYKptxM0nKULQfaoR05ZICe9C+DY0kGISIsXV1UWilEkBFM+J
oY5mSQn/ArgW9XGyDmW4rJE76scSALM5k5n2s4zcBwF8Ovv+TMqEDCmRIb53
BptgeVUFw2S+nNyPJoixqI9OzJfj/zYctf0=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->{0.2, 0},
  Frame->{True, True, False, False},
  FrameLabel->{
    FormBox["\"Size of inspection zone\"", TraditionalForm], 
    FormBox["\"Variance\"", TraditionalForm]},
  PlotRange->{{0.1, 1.}, {0., 10035.003500350034`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.3942679492843823`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2.2 PDF for separation of pairs of points", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.3943669594339857`*^9, 3.3943669673553762`*^9}, {
  3.412065418015334*^9, 3.4120654190968895`*^9}}],

Cell[TextData[{
 "To determine the probability density of the separation of pairs of points \
we apply Pythagoras' theorem stochastically. With reference to Figure 3.1, we \
seek first the probability density of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["X",
    FontSlant->"Italic"], " ", "=", " ", 
   RowBox[{"|", 
    RowBox[{
     SubscriptBox[
      StyleBox["x",
       FontSlant->"Italic"], "1"], "-", 
     SubscriptBox[
      StyleBox["x",
       FontSlant->"Italic"], "2"]}], "|", " ", 
    RowBox[{"where", " ", "the", " ", 
     StyleBox[
      SubscriptBox["x", "i"],
      FontSlant->"Italic"], " ", "have", " ", "uniform", " ", "probability", 
     " ", "density", " ", "on", " ", "the", " ", 
     RowBox[{"interval", " ", "[", 
      RowBox[{"0", ",", " ", 
       StyleBox["d",
        FontSlant->"Italic"]}], "]"}]}]}]}]], "Text",
  CellChangeTimes->{{3.4120691237238817`*^9, 3.4120692092268286`*^9}, {
   3.4120692848055058`*^9, 3.4120693254639697`*^9}, {3.412069356548667*^9, 
   3.412069381003832*^9}, {3.4120698319422493`*^9, 3.412069836809248*^9}},
  FontFamily->"Arial"],
 ". The final line checks that the pdf we have obtained integrates to unity:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120698481155057`*^9, 3.4120699431922193`*^9}, 
   3.4123246005222063`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pdfx", " ", "=", " ", 
   RowBox[{"1", "/", "d"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdfX", " ", "=", " ", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      SuperscriptBox["pdfx", "2"], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x1", ",", " ", "X", ",", " ", "d"}], "}"}]}], "]"}], " ", "+",
     " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      SuperscriptBox["pdfx", "2"], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x1", ",", " ", "0", ",", " ", 
        RowBox[{"d", "-", "X"}]}], "}"}]}], "]"}]}]}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"pdfX", ",", " ", 
   RowBox[{"{", 
    RowBox[{"X", ",", " ", "0", ",", " ", "d"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.394447117105056*^9, 3.3944471688694897`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"d", "-", "X"}], ")"}]}], 
  SuperscriptBox["d", "2"]]], "Output",
 CellChangeTimes->{3.3944471762000303`*^9, 3.395397697252387*^9, 
  3.395466222196418*^9, 3.3954674368429937`*^9, 3.39546846563232*^9, 
  3.3954689855198812`*^9, 3.395470015791339*^9, 3.3954701511659985`*^9}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.3944471762000303`*^9, 3.395397697252387*^9, 
  3.395466222196418*^9, 3.3954674368429937`*^9, 3.39546846563232*^9, 
  3.3954689855198812`*^9, 3.395470015791339*^9, 3.3954701521173663`*^9}]
}, Open  ]],

Cell[TextData[{
 "The pdf of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Y",
    FontSlant->"Italic"], " ", "=", " ", 
   RowBox[{"|", 
    RowBox[{
     SubscriptBox[
      StyleBox["y",
       FontSlant->"Italic"], "1"], "-", 
     SubscriptBox[
      StyleBox["y",
       FontSlant->"Italic"], "2"]}], "|", " "}]}]], "Text",
  CellChangeTimes->{{3.4120691237238817`*^9, 3.4120692092268286`*^9}, {
   3.4120692848055058`*^9, 3.4120693254639697`*^9}, {3.412069356548667*^9, 
   3.412069381003832*^9}, {3.4120698319422493`*^9, 3.412069836809248*^9}},
  FontFamily->"Arial"],
 "is, of course:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412069961468499*^9, 3.412069996949518*^9}, 
   3.412070116090835*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfY", "=", 
  RowBox[{"pdfX", "/.", 
   RowBox[{"X", "\[Rule]", "Y"}]}]}]], "Input",
 CellChangeTimes->{{3.394447180766597*^9, 3.3944471893789806`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"d", "-", "Y"}], ")"}]}], 
  SuperscriptBox["d", "2"]]], "Output",
 CellChangeTimes->{3.3944471904505215`*^9, 3.3953977033812*^9, 
  3.395466223858808*^9, 3.3954674379145346`*^9, 3.395468467104437*^9, 
  3.3954689861608033`*^9, 3.3954700160416994`*^9, 3.3954701524278126`*^9}]
}, Open  ]],

Cell[TextData[{
 "We now derive the probability density of the random variable ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["X", "sq"], " ", "=", " ", 
    SuperscriptBox["X", "2"]}], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120700402317553`*^9, 3.412070075933091*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pdfXsquared", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      SqrtBox["Xsq"], ",", " ", "Xsq"}], "]"}], "pdfX"}], "/.", 
   RowBox[{"X", "\[Rule]", 
    SqrtBox["Xsq"]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"PowerExpand", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{"pdfXsquared", ",", " ", 
    RowBox[{"{", 
     RowBox[{"Xsq", ",", " ", "0", ",", " ", 
      SuperscriptBox["d", "2"]}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.394447202357643*^9, 3.3944472499661007`*^9}, 
   3.3957254977943344`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"d", "-", 
   SqrtBox["Xsq"]}], 
  RowBox[{
   SuperscriptBox["d", "2"], " ", 
   SqrtBox["Xsq"]}]]], "Output",
 CellChangeTimes->{3.394447250747224*^9, 3.39539772582347*^9, 
  3.3954662239188943`*^9, 3.395467437974621*^9, 3.395468467164523*^9, 
  3.395468986230904*^9, 3.395470016131829*^9, 3.3954701525780287`*^9}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.394447250747224*^9, 3.39539772582347*^9, 
  3.3954662239188943`*^9, 3.395467437974621*^9, 3.395468467164523*^9, 
  3.395468986230904*^9, 3.395470016131829*^9, 3.395470155482205*^9}]
}, Open  ]],

Cell[TextData[{
 "and the pdf of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Y", "sq"], " ", "=", " ", 
    SuperscriptBox["Y", "2"]}], TraditionalForm]]],
 " is therefore:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412070089752963*^9, 3.4120701106430016`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfYsquared", "=", " ", 
  RowBox[{"pdfXsquared", "/.", 
   RowBox[{"Xsq", "\[Rule]", "Ysq"}]}]}]], "Input",
 CellChangeTimes->{{3.394447318925259*^9, 3.394447334647867*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"d", "-", 
   SqrtBox["Ysq"]}], 
  RowBox[{
   SuperscriptBox["d", "2"], " ", 
   SqrtBox["Ysq"]}]]], "Output",
 CellChangeTimes->{3.394447340205859*^9, 3.395397732453003*^9, 
  3.3954662298374047`*^9, 3.3954674422207265`*^9, 3.3954684719313774`*^9, 
  3.3954689877330637`*^9, 3.3954700166726065`*^9, 3.3954701557025213`*^9}]
}, Open  ]],

Cell[TextData[{
 "To determine the probability density of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["r", "2"], "=", " ", 
    RowBox[{
     SuperscriptBox["X", "2"], "+", 
     SuperscriptBox["Y", "2"], " "}]}], TraditionalForm]]],
 "we must perform our integration over two intervals. For the first integral \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns an output in the form of an ",
 StyleBox["If ", "Input"],
 "statement:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120701727523108`*^9, 3.4120702672582035`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"pdfXsquared", " ", 
    RowBox[{"(", 
     RowBox[{"pdfYsquared", "/.", 
      RowBox[{"Ysq", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"Rsq", " ", "-", " ", "Xsq"}], ")"}]}]}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"Xsq", ",", " ", "0", ",", "Rsq"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.3944425228788834`*^9}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"Rsq", ">", "0"}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], " ", "\[Pi]"}], "-", 
     RowBox[{"4", " ", "d", " ", 
      SqrtBox["Rsq"]}], "+", "Rsq"}], 
    SuperscriptBox["d", "4"]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       SuperscriptBox["d", "4"]], "-", 
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["d", "3"], " ", 
        SqrtBox[
         RowBox[{"Rsq", "-", "Xsq"}]]}]], "-", 
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["d", "3"], " ", 
        SqrtBox["Xsq"]}]], "+", 
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["d", "2"], " ", 
        SqrtBox[
         RowBox[{"Rsq", "-", "Xsq"}]], " ", 
        SqrtBox["Xsq"]}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"Xsq", ",", "0", ",", "Rsq"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"Rsq", "\[LessEqual]", "0"}]}]}], "]"}]}], "]"}]], "Output",
 CellChangeTimes->{3.3944425260434337`*^9, 3.3944474343712626`*^9, 
  3.394447598427163*^9, 3.395397891221301*^9, 3.3954662322108173`*^9, 
  3.395467444594139*^9, 3.3954684743448477`*^9, 3.395468991127946*^9, 
  3.395470018915832*^9, 3.395470158216136*^9}]
}, Open  ]],

Cell[TextData[{
 "A closed form is returned in the output if we specify appropriate \
assumptions, in this case, as suggested by the previous output, we require \
that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "sq"], TraditionalForm]]],
 " is real and greater than zero:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412070285314166*^9, 3.4120703436881037`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfRsquaredInterval1", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"pdfXsquared", " ", 
     RowBox[{"(", 
      RowBox[{"pdfYsquared", "/.", 
       RowBox[{"Ysq", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"Rsq", " ", "-", " ", "Xsq"}], ")"}]}]}], ")"}]}], ",", " ", 
    
    RowBox[{"{", 
     RowBox[{"Xsq", ",", " ", "0", ",", "Rsq"}], "}"}], ",", " ", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"Re", "[", "Rsq", "]"}], ">", "0"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.3936525886371856`*^9, 3.393652615485792*^9}, {
   3.393652663154336*^9, 3.39365267326888*^9}, {3.3936527088800864`*^9, 
   3.3936527439304867`*^9}, {3.393652950227126*^9, 3.3936529551341825`*^9}, {
   3.393653008230531*^9, 3.3936530240332546`*^9}, {3.3936530759679327`*^9, 
   3.393653080584571*^9}, {3.3936546589841986`*^9, 3.393654670610917*^9}, {
   3.3936549864650927`*^9, 3.393655023428243*^9}, {3.3936550723285584`*^9, 
   3.393655076023872*^9}, {3.393655153815731*^9, 3.393655185070674*^9}, {
   3.393655277974262*^9, 3.3936552825408287`*^9}, {3.393655562002675*^9, 
   3.393655603632536*^9}, {3.3936561916180177`*^9, 3.3936562136997695`*^9}, {
   3.3936566258924737`*^9, 3.393656640583598*^9}, {3.3936566724394045`*^9, 
   3.393656680951645*^9}, {3.393661426525445*^9, 3.393661443900429*^9}, {
   3.3936639866967907`*^9, 3.3936639876782017`*^9}, {3.3936645102295933`*^9, 
   3.393664513213885*^9}, 3.393665103292376*^9, {3.393665183437619*^9, 
   3.3936652072919197`*^9}, {3.393665434748987*^9, 3.393665449880746*^9}, {
   3.3936655381576815`*^9, 3.3936655466398783`*^9}, {3.3936656011182146`*^9, 
   3.3936656038621597`*^9}, {3.393666162645651*^9, 3.393666193610176*^9}, {
   3.393669936972867*^9, 3.3936699378941917`*^9}, {3.3936700070336094`*^9, 
   3.3936700074241714`*^9}, {3.3936736038055134`*^9, 
   3.3936736104751043`*^9}, {3.3936737205934467`*^9, 3.393673724168587*^9}, 
   3.3936754363105264`*^9, {3.3936754947946224`*^9, 3.393675516315568*^9}, {
   3.3944413208103933`*^9, 3.394441329583008*^9}, {3.394447912648992*^9, 
   3.394447918867934*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[Pi]"}], "-", 
   RowBox[{"4", " ", "d", " ", 
    SqrtBox["Rsq"]}], "+", "Rsq"}], 
  SuperscriptBox["d", "4"]]], "Output",
 CellChangeTimes->{{3.3936661668617134`*^9, 3.39366619596356*^9}, 
   3.3936699385050707`*^9, 3.3936700080951357`*^9, {3.393675504368389*^9, 
   3.393675518138189*^9}, 3.393737087421875*^9, 3.3938230147261906`*^9, 
   3.394441342020893*^9, 3.3944413756392336`*^9, 3.394441430448045*^9, {
   3.3944479224731183`*^9, 3.394447933529016*^9}, 3.3953979013458595`*^9, 
   3.395466233352459*^9, 3.39546744575581*^9, 3.3954684755866337`*^9, 
   3.39546899229963*^9, 3.395470020147603*^9, 3.39547015956808*^9}]
}, Open  ]],

Cell["Similarly, for the second interval:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4120703693850546`*^9, 3.4120703746225853`*^9}, 
   3.4123246054092336`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pdfRsquaredInterval2", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"pdfXsquared", " ", 
      RowBox[{"(", 
       RowBox[{"pdfYsquared", "/.", 
        RowBox[{"Ysq", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"Rsq", "-", "Xsq"}], ")"}]}]}], ")"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"Xsq", ",", " ", 
       RowBox[{"Rsq", "-", 
        SuperscriptBox["d", "2"]}], ",", 
       SuperscriptBox["d", "2"]}], "}"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", "<", 
       SuperscriptBox["d", "2"], "<", "Rsq", "<", 
       RowBox[{"2", " ", 
        SuperscriptBox["d", "2"]}]}]}]}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"pdfRsquaredInterval2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"pdfRsquaredInterval2", ",", " ", 
    RowBox[{"d", ">", "0"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.393675530966635*^9, 3.3936755708840337`*^9}, {
   3.3936756999896784`*^9, 3.393675708471875*^9}, {3.3936758178691807`*^9, 
   3.39367581820967*^9}, 3.393676244903226*^9, {3.394441392583598*^9, 
   3.394441395397645*^9}, {3.394441438028946*^9, 3.394441457446867*^9}, {
   3.394441610747302*^9, 3.3944416251480093`*^9}, {3.394441677853797*^9, 
   3.3944416893703566`*^9}, {3.3944428331450243`*^9, 
   3.3944428391436496`*^9}, {3.3944428878036194`*^9, 
   3.3944428924002285`*^9}, {3.3944429393577504`*^9, 3.394442960648365*^9}, {
   3.3944429916930046`*^9, 3.394442999634424*^9}, {3.3944435351845074`*^9, 
   3.3944435451087775`*^9}, {3.394443907990576*^9, 3.394443908721627*^9}, 
   3.394444525328264*^9, {3.394448529856493*^9, 3.3944485630341997`*^9}, {
   3.394448743563789*^9, 3.39444875656248*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Rsq", "-", 
    RowBox[{"4", " ", "d", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["d", "2"]}], "+", "Rsq"}]]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["d", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"d", " ", 
         SqrtBox[
          FractionBox["1", "Rsq"]]}], "]"}], "-", 
       RowBox[{"ArcSin", "[", 
        FractionBox["d", 
         SqrtBox["Rsq"]], "]"}]}], ")"}]}]}], 
   SuperscriptBox["d", "4"]]}]], "Output",
 CellChangeTimes->{3.393675668284088*^9, 3.393675787325261*^9, 
  3.3936758972533293`*^9, 3.3936762910896387`*^9, 3.393737130546875*^9, 
  3.393823058609291*^9, 3.394441600071952*^9, 3.3944416612399073`*^9, 
  3.3944417342849407`*^9, 3.3944428577904625`*^9, 3.394442928892702*^9, 
  3.3944429747386255`*^9, 3.3944434217013264`*^9, 3.3944485510269346`*^9, 
  3.3944486079387693`*^9, 3.394448803399829*^9, 3.394448859280181*^9, 
  3.395397968432325*^9, 3.395466281561781*^9, 3.3954674918220496`*^9, 
  3.3954685210820527`*^9, 3.3954690374445457`*^9, 3.395470070369819*^9, 
  3.395470205484104*^9}]
}, Open  ]],

Cell[TextData[{
 "So we combine the outputs of the two previous integrals in a ",
 StyleBox["Piecewise", "Input"],
 " function to give the pdf of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["R", "sq"], "=", " ", 
    SuperscriptBox["r", "2"]}], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120703830146527`*^9, 3.412070448689088*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfRsquared", " ", "=", " ", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pdfRsquaredInterval1", ",", " ", 
       RowBox[{"0", "\[LessEqual]", "Rsq", "<", 
        SuperscriptBox["d", "2"]}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"pdfRsquaredInterval2", ",", " ", 
       RowBox[{
        SuperscriptBox["d", "2"], "\[LessEqual]", "Rsq", "\[LessEqual]", " ", 
        
        RowBox[{"2", 
         SuperscriptBox["d", "2"]}]}]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.3953980319236207`*^9, 3.395398162891944*^9}}],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["d", "2"], " ", "\[Pi]"}], "-", 
       RowBox[{"4", " ", "d", " ", 
        SqrtBox["Rsq"]}], "+", "Rsq"}], 
      SuperscriptBox["d", "4"]], 
     RowBox[{"0", "\[LessEqual]", "Rsq", "<", 
      SuperscriptBox["d", "2"]}]},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Rsq", "-", 
        RowBox[{"4", " ", "d", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["d", "2"]}], "+", "Rsq"}]]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["d", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"ArcCos", "[", 
            RowBox[{"d", " ", 
             SqrtBox[
              FractionBox["1", "Rsq"]]}], "]"}], "-", 
           RowBox[{"ArcSin", "[", 
            FractionBox["d", 
             SqrtBox["Rsq"]], "]"}]}], ")"}]}]}], 
       SuperscriptBox["d", "4"]]}], 
     RowBox[{
      SuperscriptBox["d", "2"], "\[LessEqual]", "Rsq", "\[LessEqual]", 
      RowBox[{"2", " ", 
       SuperscriptBox["d", "2"]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellChangeTimes->{3.3954024236986833`*^9, 3.3954655766982365`*^9, 
  3.395466281621867*^9, 3.395467492022338*^9, 3.395468521282341*^9, 
  3.3954690376448336`*^9, 3.3954700703998623`*^9, 3.395470205554205*^9}]
}, Open  ]],

Cell["\<\
Again, we check that the probability density we have derived integrates to \
unity:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4120705878692193`*^9, 3.412070610071144*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Integrate", "[", 
  RowBox[{"pdfRsquared", ",", " ", 
   RowBox[{"{", 
    RowBox[{"Rsq", ",", " ", "0", ",", 
     SuperscriptBox["d", "2"]}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"0", "<", "Rsq", "<", 
      SuperscriptBox["d", "2"]}], "&&", " ", 
     RowBox[{"d", ">", "0"}]}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"pdfRsquared", ",", " ", 
   RowBox[{"{", 
    RowBox[{"Rsq", ",", " ", 
     SuperscriptBox["d", "2"], ",", " ", 
     RowBox[{"2", 
      SuperscriptBox["d", "2"]}]}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], "<", "Rsq", "<", " ", 
      RowBox[{"2", 
       SuperscriptBox["d", "2"]}]}], "&&", " ", 
     RowBox[{"d", ">", "0"}]}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"%", " ", "+", " ", "%%"}], "]"}]}], "Input",
 CellChangeTimes->{{3.3954641420553217`*^9, 3.395464183274592*^9}, {
  3.395464216352155*^9, 3.395464261657301*^9}, {3.395465397770952*^9, 
  3.3954654183004723`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "13"}], "+", 
    RowBox[{"6", " ", "\[Pi]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.395465415125907*^9, 3.3954654208942013`*^9}, 
   3.39546580339421*^9, 3.3954662822728033`*^9, 3.395467492543086*^9, 
   3.395468521763032*^9, 3.395469038135539*^9, 3.395470070890568*^9, 
   3.3954702060649395`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{"19", "-", 
    RowBox[{"6", " ", "\[Pi]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.395465415125907*^9, 3.3954654208942013`*^9}, 
   3.39546580339421*^9, 3.3954662822728033`*^9, 3.395467492543086*^9, 
   3.395468521763032*^9, 3.395469038135539*^9, 3.395470070890568*^9, 
   3.395470211612917*^9}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.395465415125907*^9, 3.3954654208942013`*^9}, 
   3.39546580339421*^9, 3.3954662822728033`*^9, 3.395467492543086*^9, 
   3.395468521763032*^9, 3.395469038135539*^9, 3.395470070890568*^9, 
   3.3954702116229315`*^9}]
}, Open  ]],

Cell[TextData[{
 "and compute the mean ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SuperscriptBox["r", "2"], "_"], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120706332244368`*^9, 3.412070676586789*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Rsq", " ", "pdfRsquared"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"Rsq", ",", " ", "0", ",", 
     SuperscriptBox["d", "2"]}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"0", "<", "Rsq", "<", 
      SuperscriptBox["d", "2"]}], "&&", " ", 
     RowBox[{"d", ">", "0"}]}]}]}], "]"}], "\n", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Rsq", " ", "pdfRsquared"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"Rsq", ",", " ", 
     SuperscriptBox["d", "2"], ",", " ", 
     RowBox[{"2", 
      SuperscriptBox["d", "2"]}]}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], "<", "Rsq", "<", " ", 
      RowBox[{"2", 
       SuperscriptBox["d", "2"]}]}], "&&", " ", 
     RowBox[{"d", ">", "0"}]}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Rsqbar", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{"%", " ", "+", " ", "%%"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.3954641420553217`*^9, 3.395464183274592*^9}, {
  3.395464216352155*^9, 3.395464261657301*^9}, {3.395465900874379*^9, 
  3.3954659059917374`*^9}, {3.3954661891188545`*^9, 3.3954661941761265`*^9}}],\


Cell[BoxData[
 RowBox[{
  FractionBox["1", "30"], " ", 
  SuperscriptBox["d", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "38"}], "+", 
    RowBox[{"15", " ", "\[Pi]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.3954643160455074`*^9, {3.3954659079545603`*^9, 3.395465932039192*^9}, 
   3.3954661957784305`*^9, 3.395466288852264*^9, 3.3954674988521585`*^9, 
   3.395468528072104*^9, 3.3954690442943954`*^9, 3.3954700742854495`*^9, 
   3.3954702122037663`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "10"]}], " ", 
  SuperscriptBox["d", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "16"}], "+", 
    RowBox[{"5", " ", "\[Pi]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.3954643160455074`*^9, {3.3954659079545603`*^9, 3.395465932039192*^9}, 
   3.3954661957784305`*^9, 3.395466288852264*^9, 3.3954674988521585`*^9, 
   3.395468528072104*^9, 3.3954690442943954`*^9, 3.3954700742854495`*^9, 
   3.3954702160693245`*^9}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["d", "2"], "3"]], "Output",
 CellChangeTimes->{
  3.3954643160455074`*^9, {3.3954659079545603`*^9, 3.395465932039192*^9}, 
   3.3954661957784305`*^9, 3.395466288852264*^9, 3.3954674988521585`*^9, 
   3.395468528072104*^9, 3.3954690442943954`*^9, 3.3954700742854495`*^9, 
   3.3954702160693245`*^9}]
}, Open  ]],

Cell[TextData[{
 "The probability density of the separation of pairs of points by a distance \
",
 StyleBox["r ",
  FontSlant->"Italic"],
 "is obtained using another variable transform:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120707548693533`*^9, 3.412070813784069*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Rsq", " ", "=", " ", 
   SuperscriptBox["r", "2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdfR", " ", "=", " ", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"Rsq", ",", " ", "r"}], "]"}], " ", "pdfRsquared"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{"PiecewiseExpand", "[", "pdfR", "]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Rsq", " ", "=."}]}], "Input",
 CellChangeTimes->{{3.395466681136341*^9, 3.3954667970730495`*^9}, {
  3.39546740970397*^9, 3.3954674127483473`*^9}, {3.395468215222248*^9, 
  3.3954682185971007`*^9}, {3.3954682887980447`*^9, 3.395468293114251*^9}, {
  3.3954683945601234`*^9, 3.3954684120152225`*^9}}],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox[
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["d", "2"], " ", "\[Pi]"}], "-", 
         RowBox[{"4", " ", "d", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox["d", "4"]], 
     RowBox[{
      SuperscriptBox["d", "2"], ">", 
      SuperscriptBox["r", "2"]}]},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "-", 
          RowBox[{"4", " ", "d", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["d", "2"]}], "+", 
             SuperscriptBox["r", "2"]}]]}], "+", 
          RowBox[{
           SuperscriptBox["d", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "\[Pi]", "-", 
             RowBox[{"4", " ", 
              RowBox[{"ArcSin", "[", 
               FractionBox["d", "r"], "]"}]}]}], ")"}]}]}], ")"}]}], 
       SuperscriptBox["d", "4"]]}], 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["d", "2"]}], "\[GreaterEqual]", 
       SuperscriptBox["r", "2"]}], "&&", 
      RowBox[{
       SuperscriptBox["d", "2"], "\[LessEqual]", 
       SuperscriptBox["r", "2"]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellChangeTimes->{{3.3954667103984175`*^9, 3.3954667428651023`*^9}, {
   3.3954667813404274`*^9, 3.3954668075781555`*^9}, 3.3954672861262736`*^9, 
   3.395467511560432*^9, 3.395468219929016*^9, 3.3954682940656195`*^9, 
   3.3954684059865537`*^9, 3.3954685383568926`*^9, 3.3954690545992126`*^9, 
   3.3954700783312674`*^9, 3.3954702222381954`*^9}]
}, Open  ]],

Cell["and the pdf integrates to unity:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4120708279444304`*^9, 3.412070840262142*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"pdfR", ",", " ", 
     RowBox[{"{", 
      RowBox[{"r", ",", " ", "0", ",", "d"}], "}"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", "<", "r", "<", "d"}]}]}], "]"}], "+", 
   RowBox[{"Integrate", "[", 
    RowBox[{"pdfR", ",", " ", 
     RowBox[{"{", 
      RowBox[{"r", ",", " ", "d", ",", 
       RowBox[{
        SqrtBox["2"], "d"}]}], "}"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"d", "<=", "r", "<", 
       RowBox[{
        SqrtBox["2"], "d"}]}]}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3953985032213135`*^9, 3.395398517001128*^9}, 
   3.3953995744817104`*^9, {3.3953999569917326`*^9, 3.3953999572621217`*^9}, {
   3.39540132759256*^9, 3.395401390312747*^9}, {3.395401453253251*^9, 
   3.395401465570963*^9}, 3.395401515913352*^9, {3.3954675718871775`*^9, 
   3.3954675821719666`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.3953985176320353`*^9, 3.395399408392886*^9, 3.3953995757935967`*^9, {
   3.395399948709824*^9, 3.3953999579330864`*^9}, 3.3954002172359457`*^9, {
   3.3954013403008337`*^9, 3.3954013912641153`*^9}, 3.3954014303803616`*^9, {
   3.3954015055684767`*^9, 3.3954015171851807`*^9}, 3.3954024638664417`*^9, {
   3.3954675886412687`*^9, 3.395467601159269*^9}, 3.395468230864741*^9, 
   3.395468443650712*^9, 3.3954685428333297`*^9, 3.3954690589554768`*^9, 
   3.3954700800537443`*^9, 3.3954702273255105`*^9}]
}, Open  ]],

Cell["We obtain the mean in the usual way:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412070844578349*^9, 3.4120708597601795`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rbar", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"r", " ", "pdfR"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"r", ",", " ", "0", ",", "d"}], "}"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"0", "<", "r", "<", "d"}]}]}], "]"}], " ", "+", " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"r", " ", "pdfR"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"r", ",", " ", "d", ",", 
        RowBox[{
         SqrtBox["2"], "d"}]}], "}"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"d", "<=", "r", "<", 
        RowBox[{
         SqrtBox["2"], "d"}]}]}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.3953985032213135`*^9, 3.395398517001128*^9}, 
   3.3953995744817104`*^9, {3.3953999569917326`*^9, 3.3953999572621217`*^9}, {
   3.39540132759256*^9, 3.395401390312747*^9}, {3.395401453253251*^9, 
   3.395401465570963*^9}, 3.395401515913352*^9, {3.3954024845161343`*^9, 
   3.395402503513451*^9}, {3.395402537852829*^9, 3.395402556289339*^9}, {
   3.395402885062091*^9, 3.395402891821811*^9}, {3.3954037841549234`*^9, 
   3.3954037924768896`*^9}, {3.3954679596247168`*^9, 3.395467972102659*^9}, 
   3.3954680445568433`*^9, {3.395468940915744*^9, 3.3954689743337965`*^9}, {
   3.395469615275426*^9, 3.395469616106621*^9}, {3.395469678456275*^9, 
   3.395469690814045*^9}, 3.39546972619492*^9, {3.395469766032203*^9, 
   3.395469797126915*^9}, {3.3954699845564256`*^9, 3.3954699948612432`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "15"], " ", "d", " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    SqrtBox["2"], "+", 
    RowBox[{"5", " ", 
     RowBox[{"ArcSinh", "[", "1", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.3953985176320353`*^9, 3.395399408392886*^9, 3.3953995757935967`*^9, {
   3.395399948709824*^9, 3.3953999579330864`*^9}, 3.3954002172359457`*^9, {
   3.3954013403008337`*^9, 3.3954013912641153`*^9}, 3.3954014303803616`*^9, {
   3.3954015055684767`*^9, 3.3954015171851807`*^9}, {3.3954024638664417`*^9, 
   3.395402505966979*^9}, 3.3954025407269616`*^9, 3.3954026331298304`*^9, {
   3.395403785797285*^9, 3.3954037999175887`*^9}, 3.39546798152621*^9, 
   3.395468073077854*^9, 3.3954682766706066`*^9, 3.3954684380827055`*^9, 
   3.3954685496931934`*^9, 3.3954690659855857`*^9, 3.395469619491488*^9, {
   3.395469688270387*^9, 3.3954696970530157`*^9}, 3.3954697336957054`*^9, 
   3.3954698141313667`*^9, 3.3954700830180063`*^9, 3.3954702345859504`*^9}]
}, Open  ]],

Cell[TextData[{
 "and make use of our earlier derivation of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SuperscriptBox["r", "2"], "_"], TraditionalForm]]],
 " to determine the variance:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120708663897123`*^9, 3.4120708999780097`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rvar", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Rsqbar", " ", "-", " ", 
    SuperscriptBox["rbar", "2"]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.3954687750272083`*^9, 3.395468816466795*^9}, {
   3.395469622726139*^9, 3.3954696235272913`*^9}, 3.3954698046176863`*^9, {
   3.395470006698264*^9, 3.3954700069686527`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "225"], " ", 
  SuperscriptBox["d", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"75", "-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", 
       SqrtBox["2"], "+", 
       RowBox[{"5", " ", 
        RowBox[{"ArcSinh", "[", "1", "]"}]}]}], ")"}], "2"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.39546877616885*^9, 3.3954688313882513`*^9}, 
   3.3954690662359457`*^9, 3.395469623967925*^9, 3.39547008304805*^9, 
   3.3954702346660657`*^9}]
}, Open  ]],

Cell["\<\
Some Monte Carlo analysis helps provide confidence in the expressions we have \
derived:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412070922820856*^9, 3.4120709723220353`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"n", " ", "=", " ", "1000000"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", " ", "=", " ", 
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "d"}], "}"}], ",", " ", "n"}], "]"}], "-", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "d"}], "}"}], ",", " ", "n"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Y", " ", "=", " ", 
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "d"}], "}"}], ",", " ", "n"}], "]"}], "-", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "d"}], "}"}], ",", " ", "n"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", " ", "=", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["X", "2"], "+", 
     SuperscriptBox["Y", "2"]}]]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Mean", "[", "R", "]"}], ",", 
     RowBox[{"N", "[", "rbar", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Variance", "[", "R", "]"}], ",", 
     RowBox[{"N", "[", "rvar", "]"}]}], "}"}]}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<Histograms`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Histogram", "[", 
    RowBox[{"R", ",", " ", 
     RowBox[{"HistogramCategories", "\[Rule]", "30"}], ",", 
     RowBox[{"HistogramScale", "\[Rule]", "1"}]}], "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{"pdfR", ",", " ", 
     RowBox[{"{", 
      RowBox[{"r", ",", " ", "0", ",", " ", 
       RowBox[{
        SqrtBox["2"], "d"}]}], "}"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Thickness", "[", ".005", "]"}]}]}], "]"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<r\>\"", ",", " ", "\"\<f(r)\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"d", "=."}]}], "Input",
 CellChangeTimes->{{3.395470483343646*^9, 3.3954705997109747`*^9}, {
   3.395470637585435*^9, 3.3954707125231905`*^9}, 3.3954707973952303`*^9, 
   3.3954711387961407`*^9, {3.3954716175345325`*^9, 3.395471648088467*^9}, 
   3.4120709797427053`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.5215188796661764`", ",", "0.5214054331647207`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.061493068981252216`", ",", "0.06146970759964335`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.395470824253851*^9, 3.395470844332723*^9}, 
   3.3954716571615133`*^9, {3.395471888404024*^9, 3.395471901653075*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], RectangleBox[{0., 0}, {0.05, 0.15214}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.05000000000000001, 0}, {0.1, 0.4245}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.09999999999999999, 0}, \
{0.15000000000000002`, 0.6580199999999997}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.15000000000000002`, 0}, {0.2, 0.8594600000000001}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], RectangleBox[{0.2, 0}, {0.25, 1.03028}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.25, 0}, {0.30000000000000004`, 1.1676599999999988`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.30000000000000004`, 0}, \
{0.3500000000000001, 1.2622200000000003`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], RectangleBox[{0.35, 0}, {0.4, 1.3398}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.4, 0}, {0.45000000000000007`, 1.3819000000000004`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.44999999999999996`, 0}, {0.5, 1.3949600000000004`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.5, 0}, {0.55, 1.3758799999999987`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.55, 0}, {0.6000000000000001, 1.3518599999999987`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.6000000000000001, 0}, \
{0.6499999999999999, 1.291380000000002}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.65, 0}, {0.7000000000000001, 1.203919999999999}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.7000000000000002, 0}, {0.75, 1.1070000000000015`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.75, 0}, {0.8, 0.9983399999999992}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.8, 0}, {0.8500000000000001, 0.8578199999999992}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.8500000000000001, 0}, \
{0.8999999999999999, 0.712600000000001}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.9, 0}, {0.9500000000000001, 0.5522999999999996}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.9500000000000002, 0}, {1., 0.37326000000000054`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.9999999999999999, 0}, \
{1.0499999999999998`, 0.2194799999999998}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.0500000000000003`, 0}, {1.1, 0.13365999999999986`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.1, 0}, {1.15, 0.07903999999999993}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.1500000000000004`, 0}, \
{1.2000000000000002`, 0.04237999999999996}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.2000000000000002`, 0}, {1.25, 0.02022000000000007}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.25, 0}, {1.2999999999999998`, 0.007939999999999992}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.3000000000000003`, 0}, {1.35, 0.0018199999999999985`}]}, \

    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.35, 0}, {1.4, 0.00015999999999999985`}]}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJwV13k4VXsXB3CSbsksSSk0HCRFocHwRSJFw41IaCBlVuRKiChRbpIoUXRF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       "]], LineBox[CompressedData["
1:eJwl03dUj+8bB/CWUSrR0FBaQkOpROXzvAslojS0REtKaZFQiTZahIoUkiRJ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       "]]}, {}}, {{}, {}, {}}}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"r\"", TraditionalForm], 
    FormBox["\"f(r)\"", TraditionalForm]},
  AxesOrigin->{0., 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0., 1.4000000000000001`}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{0., 
      FormBox["0", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
      FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
      FormBox["0.8`", TraditionalForm]}, {1., 
      FormBox["1", TraditionalForm]}, {1.2000000000000002`, 
      FormBox["1.2000000000000002`", TraditionalForm]}, {
     1.4000000000000001`, 
      FormBox["1.4000000000000001`", TraditionalForm]}}, Automatic},
  TicksStyle->{}]], "Output",
 CellChangeTimes->{{3.395470824253851*^9, 3.395470844332723*^9}, 
   3.3954716571615133`*^9, {3.395471888404024*^9, 3.3954719032854223`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3 Poisson Line Processes", "Section",
 Editable->False,
 CellChangeTimes->{{3.395476090015645*^9, 3.395476095964198*^9}, {
  3.41207102907364*^9, 3.4120710299949646`*^9}}],

Cell[CellGroupData[{

Cell["Generate a graphic", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.396249767809128*^9, 3.3962497749694242`*^9}, 
   3.3978002106848783`*^9}],

Cell["\<\
To generate a random line network, we generate random coordinates through \
which the lines pass and a random orientation by selecting values from a \
uniform probability density:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4120711022688894`*^9, 3.4120711102002945`*^9}, {
   3.4123195609356365`*^9, 3.412319624607192*^9}, 3.41232461222904*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]i", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Pi]"}], "}"}], ",", " ", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xi", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", " ", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yi", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", " ", "n"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.3955734247260847`*^9, 3.3955734273498573`*^9}, 
   3.3955736423890686`*^9, 3.3955742915124626`*^9}],

Cell["We may then determine the equations of the random lines:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412319632107978*^9, 3.4123196442153873`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"lines", " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Tan", "[", "\[Theta]i", "]"}], 
     RowBox[{"(", 
      RowBox[{"x", " ", "-", " ", "xi"}], ")"}]}], " ", "+", " ", "yi"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.3955734247260847`*^9, 3.3955734273498573`*^9}, 
   3.3955736423890686`*^9, 3.3955742915124626`*^9}],

Cell["and plot these within the unit square:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412319653048088*^9, 3.4123196684101777`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"lines", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwdxw841HcAx3F/4vx5cDRRdiQnqyxqjUg+av1RkflTJH/28BAl/0ZkSRS1
wjytmSdGU3sQR4RtmQnn7PF/NHXucM65+3HcWXNX+sO+2+d53s/neVmGxflE
qKmoqBwk/fdSn56MrrP1UPl/i7D2llGdtxrx2v8Z07NNjpQBJxQt/QrqZXh/
gpccJo2GE6qqbejgWCbqSWRoFn7WN+jSAarkULU0WYaOsz+YnZpnI/6A/9ox
TRkUm/casM53Q8AsTEHZAtSWq+lm1j0opbnES7YvwGH1i2bf2j4csKJHaHLm
0Xdt1wBn6yCO0YdufBo6D4sC6XKVbAhlq0q3CrkU0leTE3/ZD4Nv46H45roU
D+ZaevTzRxDlo+Xask4KfUaFXCR6Bt/jj5qUFXPIjW6KvMcchc3VnC1VbnNQ
ulWLojKe48iTzh2lQ7NI2sluXNf5An5b7Rx0omYxWcu+9aflGGpKVAd/UVJ4
e/ZZ8ZY0HiIEbYUp1yls20dbiWzhgxZcE8iyoHC43PJMvckElLzVBus6CVIY
oZumgiYx+G0mzfiQBLbzJ3SfewpAY8hvfjApxlqDRS32GwHyKzvLT8aJsaat
uM6qZArvYjjNBjQxzu1q4WofE+LJJ/ahuoUzqD4Sdu93pRCjvdkOJjYzUEg3
0MWF0+CXaOvcbROhyfew+p0DItjHLyWEeomQ4Z5d1igWIeaS3mixeBqW40df
3M+egXagUTSVMQ1nx2t31u8UY8npckEKfRpB5oPLqiNidPuYNqZXCqHoyRPG
Z0owe359DMdRiKI1IUk+TAr/tLtvzBmYwtqJpnI1NoVgSbj6yTNT0EjP9HNK
mIWxgTgt6pUAKlUhdUKjOTTHFcr+zhcg8W5dnlHHHH4aZilbGQK0bruhZRgr
BaUXdnpX8CQMjybaZunPI4Bit4/lTYD/8dDIxd/mEdat+FyTNY5HpWCKQhbg
Znr1hQWPj+A6B0PGygLGdanWU3p8XMn+MZP/UIZ1a8z6TLfzwKIYxfoecmyK
fTjcFTwGb0P93d1v5PiDT1N7/RUXNzXUzPjELz/qVx8nZi8r3i8Sf5h8W6OD
2EE43rnhrRyJegztXOINj1lescQWrjvpG4mFfp5njN/JkVoWZO6exkVSUW5h
+Hs5NofVOxelcsHKvXIxldin9oJLOrH4SlJQHnH6mz2uYcQB0UGbfiYeuc3Z
Z0u819m2VmdFjsudPPenKVxo8nu76olHmZr+1AUuMNRWySFWTegN6CdOZT++
xSO2bS0IbCCeqyn21liVI+uEWcgl4oH0c+MBxNtz7CPoxLTE0KfniQOHFZGK
ZC7cIn3vZxFfM2+JGiNuOL4nuoaY13ww5gGxdL+dRzuxprpu7NfETEcru1Hi
HV5DcbHEIdtMjKTEp4u/S/Al/t5CV7FKnCMJ/HI38b90kzb9
     "]]}, 
   {GrayLevel[0], 
    LineBox[{{0.5679480989438902, 0.}, {0.5716599705280151, 
     0.0013550862591900914`}, {0.5926201946734201, 0.009006997454194143}, {
     0.6121702494195903, 0.01614410065201266}, {0.6333713592563216, 
     0.023883951551544172`}, {0.6531622996938181, 0.03110899445389012}, {
     0.6725634788953451, 0.03819174792534999}, {0.6936157131874332, 
     0.04587724909852292}, {0.7132577780802865, 0.05304794227451025}, {
     0.7345508980637009, 0.060821383152210626`}, {0.7544338486478805, 
     0.06808001603272544}, {0.7739270379960906, 0.07519635948235417}, {
     0.7950712824348619, 0.08291545063369599}, {0.8148053574743983, 
     0.09011973378785218}, {0.8361904876044959, 0.09792676464372142}, {
     0.857185856498624, 0.10559150606870465`}, {0.8767710559935172, 
     0.11274143949650225`}, {0.8980073105789717, 0.12049412062601292`}, {
     0.9178333957651912, 0.12773199375833796`}, {0.9372697197154413, 
     0.134827577459777}, {0.9583570987562524, 0.14252590886292904`}, {
     0.9780343083978288, 0.14970943226889552`}, {0.9993625731299663, 
     0.15749570337657506`}, {0.9993725326059331, 0.1574993392644891}, {
     0.9993824920818999, 0.1575029751524032}, {0.9994024110338333, 
     0.1575102469282313}, {0.9994422489377002, 0.15752479047988752`}, {
     0.9995219247454339, 0.1575538775831999}, {0.9996812763609015, 
     0.1576120517898248}, {0.9996912358368683, 0.15761568767773887`}, {
     0.999701195312835, 0.15761932356565292`}, {0.9997211142647684, 
     0.15762659534148102`}, {0.9997609521686354, 0.15764113889313724`}, {
     0.9998406279763692, 0.1576702259964497}, {0.9998505874523359, 
     0.15767386188436375`}, {0.9998605469283026, 0.1576774977722778}, {
     0.999880465880236, 0.1576847695481059}, {0.9999203037841029, 
     0.1576993130997621}, {0.9999302632600696, 0.15770294898767617`}, {
     0.9999402227360363, 0.15770658487559022`}, {0.9999601416879698, 
     0.15771385665141832`}, {0.9999701011639365, 0.15771749253933237`}, {
     0.9999800606399032, 0.15772112842724642`}, {0.99999002011587, 
     0.1577247643151605}, {0.9999999795918367, 0.15772840020307455`}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.6356423853256938}, {
     0.00030671792055962676`, 0.6354037539952586}, {0.0006134154329559882, 
     0.6351651226648235}, {0.0012268104577487112`, 0.6346878600039532}, {
     0.002453600507334157, 0.6337333346822125}, {0.004907180606505049, 
     0.6318242840387313}, {0.009814340804846833, 0.6280061827517687}, {
     0.0196286612015304, 0.6203699801778436}, {0.040908357085458646`, 
     0.6038129429186865}, {0.06077788357015209, 0.5883531124717041}, {
     0.08025764881887605, 0.5731965425290693}, {0.10138846915816112`, 
     0.5567553404751274}, {0.12110912009821138`, 0.5414113452333603}, {
     0.1424808261288228, 0.5247827178802863}, {0.16346277092346467`, 
     0.5084573510315598}, {0.18303454631887175`, 0.49322919099500806`}, {
     0.20425737680483996`, 0.4767163988471493}, {0.22407003789157337`, 
     0.46130081351146535`}, {0.24349293774233727`, 0.44618848868012895`}, {
     0.26456689268366235`, 0.4297915317374855}, {0.2842306782257526, 
     0.4144917816070169}, {0.305545518858404, 0.3979073993652412}, {
     0.32647059825508584`, 0.3816262776278131}, {0.34598550825253294`, 
     0.3664423627025598}, {0.3671514733405411, 0.3499738156659995}, {
     0.3869072690293145, 0.3346024754416139}, {0.408314119808649, 
     0.31794650310592143`}, {0.429331209352014, 0.3015937912745764}, {
     0.44893812949614426`, 0.2863382862554062}, {0.47019610473083556`, 
     0.26979814912492905`}, {0.4900439105662921, 0.2543552188066266}, {
     0.5095019551657791, 0.23921554899267172`}, {0.5306110548558273, 
     0.22279124706740983`}, {0.5503099851466406, 0.20746415195432272`}, {
     0.5716599705280151, 0.19085242472992864`}, {0.5926201946734201, 
     0.17454395800988204`}, {0.6121702494195903, 0.15933269810201023`}, {
     0.6333713592563216, 0.14283680608283145`}, {0.6531622996938181, 
     0.12743812087582745`}, {0.6725634788953451, 0.11234269617317105`}, {
     0.6936157131874332, 0.09596263935920757}, {0.7132577780802865, 
     0.08067978935741893}, {0.7345508980637009, 0.06411230724432326}, {
     0.7544338486478805, 0.048642031943402386`}, {0.7739270379960906, 
     0.033475017146829045`}, {0.7950712824348619, 0.017023370238948676`}, {
     0.8148053574743983, 0.001668930143243208}, {0.8169503261269327, 0.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.3315111672551778, 0.}, {0.34598550825253294`, 
     0.009691397402259841}, {0.3671514733405411, 0.023863219049112566`}, {
     0.3869072690293145, 0.03709085179955976}, {0.408314119808649, 
     0.05142396016499873}, {0.429331209352014, 0.06549610113783125}, {
     0.44893812949614426`, 0.07862405321425822}, {0.47019610473083556`, 
     0.09285748090567694}, {0.4900439105662921, 0.10614671970069013`}, {
     0.5095019551657791, 0.11917499110309686`}, {0.5306110548558273, 
     0.13330873812049537`}, {0.5503099851466406, 0.14649829624148836`}, {
     0.5716599705280151, 0.1607933299774731}, {0.5926201946734201, 
     0.17482739632085137`}, {0.6121702494195903, 0.18791727376782413`}, {
     0.6333713592563216, 0.20211262682978864`}, {0.6531622996938181, 
     0.21536379099534764`}, {0.6725634788953451, 0.22835398776830013`}, {
     0.6936157131874332, 0.24244966015624442`}, {0.7132577780802865, 
     0.2556011436477831}, {0.7345508980637009, 0.26985810275431366`}, {
     0.7544338486478805, 0.2831708729644386}, {0.7739270379960906, 
     0.2962226757819571}, {0.7950712824348619, 0.3103799542144674}, {
     0.8148053574743983, 0.3235930437505721}, {0.8361904876044959, 
     0.3379116089016686}, {0.857185856498624, 0.35196920666015874`}, {
     0.8767710559935172, 0.3650826155222432}, {0.8980073105789717, 
     0.3793014999993195}, {0.9178333957651912, 0.3925761955799902}, {
     0.9372697197154413, 0.40558992376805447`}, {0.9583570987562524, 
     0.4197091275711105}, {0.9780343083978288, 0.43288414247776097`}, {
     0.9993625731299663, 0.4471646329994033}, {0.9993725326059331, 
     0.44717130143698736`}, {0.9993824920818999, 0.44717796987457153`}, {
     0.9994024110338333, 0.4471913067497397}, {0.9994422489377002, 
     0.44721798050007605`}, {0.9995219247454339, 0.44727132800074876`}, {
     0.9996812763609015, 0.44737802300209434`}, {0.9996912358368683, 
     0.44738469143967846`}, {0.999701195312835, 0.44739135987726253`}, {
     0.9997211142647684, 0.4474046967524307}, {0.9997609521686354, 
     0.44743137050276716`}, {0.9998406279763692, 0.4474847180034399}, {
     0.9998505874523359, 0.447491386441024}, {0.9998605469283026, 
     0.4474980548786081}, {0.999880465880236, 0.4475113917537763}, {
     0.9999203037841029, 0.4475380655041126}, {0.9999302632600696, 
     0.44754473394169675`}, {0.9999402227360363, 0.4475514023792808}, {
     0.9999601416879698, 0.447564739254449}, {0.9999701011639365, 
     0.4475714076920331}, {0.9999800606399032, 0.44757807612961714`}, {
     0.99999002011587, 0.4475847445672013}, {0.9999999795918367, 
     0.44759141300478544`}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.5056818495258647}, {
     0.00030671792055962676`, 0.5059723353110684}, {0.0006134154329559882, 
     0.5062628210962723}, {0.0012268104577487112`, 0.5068437926666798}, {
     0.002453600507334157, 0.5080057358074948}, {0.004907180606505049, 
     0.5103296220891249}, {0.009814340804846833, 0.5149773946523851}, {
     0.0196286612015304, 0.5242729397789057}, {0.040908357085458646`, 
     0.544427811983254}, {0.06077788357015209, 0.5632470549482049}, {
     0.08025764881887605, 0.58169713907066}, {0.10138846915816112`, 
     0.6017110051444226}, {0.12110912009821138`, 0.6203892419787875}, {
     0.1424808261288228, 0.6406312607644601}, {0.16346277092346467`, 
     0.6605041207076368}, {0.18303454631887175`, 0.679041351411416}, {
     0.20425737680483996`, 0.6991423640665027}, {0.22407003789157337`, 
     0.717907747482192}, {0.24349293774233727`, 0.7363039720553853}, {
     0.26456689268366235`, 0.7562639785798863}, {0.2842306782257526, 
     0.7748883558649896}, {0.305545518858404, 0.7950765151014005}, {
     0.32647059825508584`, 0.8148955154953156}, {0.34598550825253294`, 
     0.8333788866498332}, {0.3671514733405411, 0.8534260397556581}, {
     0.3869072690293145, 0.8721375636220857}, {0.408314119808649, 
     0.8924128694398208}, {0.429331209352014, 0.91231901641506}, {
     0.44893812949614426`, 0.9308895341509017}, {0.47019610473083556`, 
     0.9510238338380508}, {0.4900439105662921, 0.9698225042858026}, {
     0.5095019551657791, 0.9882520158910585}, {0.521905582762761, 1.}}]}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVx39czHcAx/Hr9GuafgrXDy1FSzyy3GpS3lETKRZFZ7dYVMoi6fEQW3R2
sX4yQnNZIobKjXLWQtTRhIozha7v3fe+31u/dIVqqat99sfr8Xo8nWN2ro3l
cjic1aT/HxLb+fRuV+SSE24lbrHpFAwD7ZIpHh9S45orKfspLCwuLKrkBaGR
fT4/4wCFVU9ar5/hRWDivClfIqKwYevw7WO8rdj2SXLA00wKSs/DgXm8VPjx
IPDPp3DWds2hbJ4YmsnKbNtiCiLTSrcsXgG8+mb03b9LIUpQIu0fKEXUgENj
p6EKZhMiYfBMKX7MWG84yU2F2eF9nfU5Vehf81a/a4UKe5oWofB9NVbLYuJl
36kwvcqqw8CgFoWfjfkcyVdBRgc+bvargyIwMc2/UoW6xDP2gl45vjrpmxbQ
qsLgHH+LiqQGVOsXUq3/qsAdKbO0n90ImzEDWZCjGt4Tm2Xrrj6GwGLk3ZdQ
47GY3/RgbjPUMWsHJJvVcDraM3K5rwUbwzKiG8Rq9AxTHX8veIba0FavwxfV
KO2uaTTPV2CqhrvH4ZEa5o6/6RjmOcqrj+4z1qmRm3Aj7qzrCyy4EMyKLWkM
BZQx2w60otRNUdvGp5HqJa+aVt8Go9rDBvfW06CuynOeOr9C5BvLyv3f0xhN
fC5x3/caXV+PufxcTMNjqcl4XE07EijLMZ97NILPOcdfm96BtpGRwCqWxh7H
TbPUQgp894/fyU00mNcbadYapoKiMOPbue4a2Fj0m8o/qBBT/BCxYRoY1kqk
LkVqKP9cnMnfqcF2fs3Lj1bRWJl00PflcQ3KVsacvTNEY3iTh/TZTQ0Ge+ws
tSc1OBavz978UoMb64InFQQxcDAufVGv1+DAisziKi2D49W7s2qcGDgrQ9rO
Z7IIrbgwarKUga+PuIDnpcWQT7nSPZaBcGbziIFCi9zW13NUhxgMNubRyaJ/
YG2uoraXMSg0jE5d69oJsWAKJ/cJA5uOG+e48k4sYosojo6BUbooYtGuLlAm
Bp6rbFhwLkdLaetuJCOfdf+cRcppaZ51XTfeTuk36xCwuO3xk6nVjh7IHKoG
tOksrEJS5h0070V8QMkScTGL9vktir23emE6GjM6VM/i91/hykS/wYnGMKdx
lsU3Um8rx/E32PrqNHejiRYZmSWi9it9cBXdiszx0KKi01FiHqpDi5+JZXiY
FuFW5l80fNAh6cgc395dWmQbce3biZmlcaf7ieUjg/p+YuH7Cx/eE3vTynq7
UR1CBLNr9MR2lRVrdhB/6uLqZ5GiBR0RFm87pgMtc17iRZxamHtyi16HqA6H
ZWnEFbkZe9OIW44Kz/1ArM1IFeYRBwcWcUXEUQnCWTeJvS/Z12cR+/vOuzp5
XIepKXZBEmLj9kf3rxE3Gc1YfocYLbWXHhAv/2PDxTriNHllzmvi24mnjBuI
u8sl4UYTOpQ3T2toJm5K366MIs76xXaFmtgkZdPdJGJOaOQlljggbt35g8Rp
4wWm3cTXVy9OKCeO2zL14VvinmWeofeIO2wj3IeJXX1cPF8QR/51PGuUONpj
unUP8ZN9iq4J4lNOZoMTxEHzbUIMd2vxH2Gyhdc=
     "]]}, 
   {GrayLevel[0], 
    LineBox[{{0.4493095294039973, 1.}, {0.47019610473083556`, 
     0.8435538721745057}, {0.4900439105662921, 0.6948884102593825}, {
     0.5095019551657791, 0.5491423659696829}, {0.5306110548558273, 
     0.39102947016397843`}, {0.5503099851466406, 0.24347912655441134`}, {
     0.5716599705280151, 0.08356193142883983}, {0.5828160317198354, 0.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.13942451074716583`}, {
     0.00030671792055962676`, 0.139696884321452}, {0.0006134154329559882, 
     0.13996925789573816`}, {0.0012268104577487112`, 0.14051400504431044`}, {
     0.002453600507334157, 0.14160349934145505`}, {0.004907180606505049, 
     0.14378248793574427`}, {0.009814340804846833, 0.14814046512432272`}, {
     0.0196286612015304, 0.15685641950147966`}, {0.040908357085458646`, 
     0.1757546061295387}, {0.06077788357015209, 0.1934004419425635}, {
     0.08025764881887605, 0.21070013650348063`}, {0.10138846915816112`, 
     0.229466108938143}, {0.12110912009821138`, 0.24697973055777117`}, {
     0.1424808261288228, 0.2659596300511445}, {0.16346277092346467`, 
     0.2845933882924101}, {0.18303454631887175`, 0.3019747957186415}, {
     0.20425737680483996`, 0.3208224810186182}, {0.22407003789157337`, 
     0.33841781550356065`}, {0.24349293774233727`, 0.35566700873639534`}, {
     0.26456689268366235`, 0.37438247984297535`}, {0.2842306782257526, 
     0.39184560013452113`}, {0.305545518858404, 0.4107749982998121}, {
     0.32647059825508584`, 0.42935825521299537`}, {0.34598550825253294`, 
     0.44668916131114444`}, {0.3671514733405411, 0.4654863452830387}, {
     0.3869072690293145, 0.48303117843989885`}, {0.408314119808649, 
     0.5020422894705041}, {0.429331209352014, 0.5207072592490017}, {
     0.44893812949614426`, 0.5381198782124651}, {0.47019610473083556`, 
     0.5569987750496737}, {0.4900439105662921, 0.5746253210718482}, {
     0.5095019551657791, 0.5919057258419148}, {0.5306110548558273, 
     0.6106524084857267}, {0.5503099851466406, 0.6281467403145045}, {
     0.5716599705280151, 0.6471073500170272}, {0.5926201946734201, 
     0.6657218184674425}, {0.6121702494195903, 0.6830839361028236}, {
     0.6333713592563216, 0.7019123316119498}, {0.6531622996938181, 
     0.7194883763060418}, {0.6725634788953451, 0.7367182797480261}, {
     0.6936157131874332, 0.7554144610637556}, {0.7132577780802865, 
     0.7728582915644508}, {0.7345508980637009, 0.7917683999388914}, {
     0.7544338486478805, 0.8094261574982977}, {0.7739270379960906, 
     0.8267377738055963}, {0.7950712824348619, 0.8455156679866402}, {
     0.8148053574743983, 0.8630412113526498}, {0.8361904876044959, 
     0.8820330325924046}, {0.857185856498624, 0.9006787125800517}, {
     0.8767710559935172, 0.9180720417526647}, {0.8980073105789717, 
     0.9369316487990229}, {0.9178333957651912, 0.9545389050303468}, {
     0.9372697197154413, 0.9718000200095629}, {0.9583570987562524, 
     0.9905274128625243}, {0.969023401163289, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.09529735925256333}, {
     0.00030671792055962676`, 0.09620247449389785}, {0.0006134154329559882, 
     0.09710758973523237}, {0.0012268104577487112`, 0.0989178202179013}, {
     0.002453600507334157, 0.10253828118323949`}, {0.004907180606505049, 
     0.10977920311391542`}, {0.009814340804846833, 0.12426104697526763`}, {
     0.0196286612015304, 0.15322473469797204`}, {0.040908357085458646`, 
     0.2160246476317791}, {0.06077788357015209, 0.27466291671611986`}, {
     0.08025764881887605, 0.3321509357302824}, {0.10138846915816112`, 
     0.39451149223284343`}, {0.12110912009821138`, 0.4527104048859381}, {
     0.1424808261288228, 0.5157818550274311}, {0.16346277092346467`, 
     0.5777030550987461}, {0.18303454631887175`, 0.6354626113205946}, {
     0.20425737680483996`, 0.6980947050308415}, {0.22407003789157337`, 
     0.7565651548916221}, {0.24349293774233727`, 0.8138853546822244}, {
     0.26456689268366235`, 0.8760780919612254}, {0.2842306782257526, 
     0.93410918539076}, {0.305545518858404, 0.997012816308693}, {
     0.30655772345441107`, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.21815327870989834`, 1.}, {0.22407003789157337`, 
     0.991881717836648}, {0.24349293774233727`, 0.965231895429242}, {
     0.26456689268366235`, 0.9363166891045851}, {0.2842306782257526, 
     0.9093363516379627}, {0.305545518858404, 0.8800906302540892}, {
     0.32647059825508584`, 0.8513796934698217}, {0.34598550825253294`, 
     0.8246036255435887}, {0.3671514733405411, 0.7955621737001047}, {
     0.3869072690293145, 0.7684555907146553}, {0.408314119808649, 
     0.7390836238119548}, {0.429331209352014, 0.7102464415088603}, {
     0.44893812949614426`, 0.6833441280638002}, {0.47019610473083556`, 
     0.6541764307014892}, {0.4900439105662921, 0.6269436021972128}, {
     0.5095019551657791, 0.6002455582925422}, {0.5306110548558273, 
     0.5712821304706207}, {0.5503099851466406, 0.5442535715067337}, {
     0.5716599705280151, 0.5149596286255956}, {0.5926201946734201, 
     0.4862004703440636}, {0.6121702494195903, 0.459376180920566}, {
     0.6333713592563216, 0.43028650757981746`}, {0.6531622996938181, 
     0.40313170309710333`}, {0.6725634788953451, 0.3765116832139953}, {
     0.6936157131874332, 0.3476262794136362}, {0.7132577780802865, 
     0.32067574447131175`}, {0.7345508980637009, 0.2914598256117362}, {
     0.7544338486478805, 0.2641787756101951}, {0.7739270379960906, 
     0.23743251020826006`}, {0.7950712824348619, 0.2084208608890739}, {
     0.8148053574743983, 0.18134408042792238`}, {0.8361904876044959, 
     0.1520019160495198}, {0.857185856498624, 0.12319453627072313`}, {
     0.8767710559935172, 0.0963220253499611}, {0.8980073105789717, 
     0.06718413051194794}, {0.9178333957651912, 0.03998110453196946}, {
     0.9372697197154413, 0.013312863151596743`}, {0.946972388790209, 0.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.35040647851279794`}, {
     0.00030671792055962676`, 0.35064720805263555`}, {0.0006134154329559882, 
     0.3508879375924733}, {0.0012268104577487112`, 0.35136939667214856`}, {
     0.002453600507334157, 0.3523323148314992}, {0.004907180606505049, 
     0.3542581511502005}, {0.009814340804846833, 0.358109823787603}, {
     0.0196286612015304, 0.36581316906240813`}, {0.040908357085458646`, 
     0.38251578708496037`}, {0.06077788357015209, 0.3981115509047558}, {
     0.08025764881887605, 0.41340138774702745`}, {0.10138846915816112`, 
     0.4299871520622411}, {0.12110912009821138`, 0.445466062174698}, {
     0.1424808261288228, 0.4622408997600968}, {0.16346277092346467`, 
     0.47870981036797183`}, {0.18303454631887175`, 0.4940718667730901}, {
     0.20425737680483996`, 0.5107298506511504}, {0.22407003789157337`, 
     0.526280980326454}, {0.24349293774233727`, 0.5415261830242337}, {
     0.26456689268366235`, 0.5580673131949555}, {0.2842306782257526, 
     0.5735015891629205}, {0.305545518858404, 0.5902317926038274}, {
     0.32647059825508584`, 0.6066560690672106}, {0.34598550825253294`, 
     0.6219734913278371}, {0.3671514733405411, 0.6385868410614055}, {
     0.3869072690293145, 0.6540933365922171}, {0.408314119808649, 
     0.6708957595959708}, {0.429331209352014, 0.6873922556222006}, {
     0.44893812949614426`, 0.7027818974456738}, {0.47019610473083556`, 
     0.7194674667420888}, {0.4900439105662921, 0.7350461818357472}, {
     0.5095019551657791, 0.7503189699518817}, {0.5306110548558273, 
     0.7668876855409582}, {0.5503099851466406, 0.782349546927278}, {
     0.5716599705280151, 0.7991073357865397}, {0.5926201946734201, 
     0.8155591976682777}, {0.6121702494195903, 0.830904205347259}, {
     0.6333713592563216, 0.8475451404991821}, {0.6531622996938181, 
     0.8630792214483486}, {0.6725634788953451, 0.8783073754199912}, {
     0.6936157131874332, 0.8948314568645758}, {0.7132577780802865, 
     0.9102486841064036}, {0.7345508980637009, 0.9269618388211734}, {
     0.7544338486478805, 0.9425681393331866}, {0.7739270379960906, 
     0.9578685128676759}, {0.7950712824348619, 0.9744648138751072}, {
     0.8148053574743983, 0.9899542606797818}, {0.8276039664933454, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.5399910223171034, 1.}, {0.5503099851466406, 
     0.9895935852728498}, {0.5716599705280151, 0.9680626614806627}, {
     0.5926201946734201, 0.94692480210135}, {0.6121702494195903, 
     0.9272090631275851}, {0.6333713592563216, 0.905828276581348}, {
     0.6531622996938181, 0.8858696104406587}, {0.6725634788953451, 
     0.8663040087128439}, {0.6936157131874332, 0.8450733594125568}, {
     0.7132577780802865, 0.8252648305178175}, {0.7345508980637009, 
     0.803791254050606}, {0.7544338486478805, 0.7837397979889422}, {
     0.7739270379960906, 0.764081406340153}, {0.7950712824348619, 
     0.7427579671188915}, {0.8148053574743983, 0.7228566483031778}, {
     0.8361904876044959, 0.701290281914992}, {0.857185856498624, 
     0.6801169799396805}, {0.8767710559935172, 0.6603657983699167}, {
     0.8980073105789717, 0.6389495692276808}, {0.9178333957651912, 
     0.6189554604909928}, {0.9372697197154413, 0.5993544161671791}, {
     0.9583570987562524, 0.5780883242708932}, {0.9780343083978288, 
     0.5582443527801552}, {0.9993625731299663, 0.5367353337169448}, {
     0.9993725326059331, 0.536725289835686}, {0.9993824920818999, 
     0.5367152459544269}, {0.9994024110338333, 0.5366951581919092}, {
     0.9994422489377002, 0.5366549826668736}, {0.9995219247454339, 
     0.5365746316168025}, {0.9996812763609015, 0.5364139295166601}, {
     0.9996912358368683, 0.5364038856354013}, {0.999701195312835, 
     0.5363938417541425}, {0.9997211142647684, 0.5363737539916247}, {
     0.9997609521686354, 0.536333578466589}, {0.9998406279763692, 
     0.5362532274165178}, {0.9998505874523359, 0.536243183535259}, {
     0.9998605469283026, 0.5362331396540001}, {0.999880465880236, 
     0.5362130518914823}, {0.9999203037841029, 0.5361728763664467}, {
     0.9999302632600696, 0.5361628324851879}, {0.9999402227360363, 
     0.536152788603929}, {0.9999601416879698, 0.5361327008414112}, {
     0.9999701011639365, 0.5361226569601523}, {0.9999800606399032, 
     0.5361126130788935}, {0.99999002011587, 0.5361025691976344}, {
     0.9999999795918367, 0.5360925253163755}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.8506532971143571, 0.}, {0.857185856498624, 
     0.02642278630435258}, {0.8767710559935172, 0.10564067175182741`}, {
     0.8980073105789717, 0.19153671705494474`}, {0.9178333957651912, 
     0.271728932894428}, {0.9372697197154413, 0.35034464904336965`}, {
     0.9583570987562524, 0.4356385250479534}, {0.9780343083978288, 
     0.5152285715889035}, {0.9993625731299663, 0.6014967779854961}, {
     0.9993725326059331, 0.6015370619063443}, {0.9993824920818999, 
     0.6015773458271929}, {0.9994024110338333, 0.6016579136688892}, {
     0.9994422489377002, 0.6018190493522819}, {0.9995219247454339, 
     0.6021413207190673}, {0.9996812763609015, 0.6027858634526391}, {
     0.9996912358368683, 0.6028261473734873}, {0.999701195312835, 
     0.6028664312943355}, {0.9997211142647684, 0.6029469991360318}, {
     0.9997609521686354, 0.6031081348194249}, {0.9998406279763692, 
     0.6034304061862109}, {0.9998505874523359, 0.603470690107059}, {
     0.9998605469283026, 0.6035109740279072}, {0.999880465880236, 
     0.6035915418696036}, {0.9999203037841029, 0.6037526775529963}, {
     0.9999302632600696, 0.6037929614738444}, {0.9999402227360363, 
     0.6038332453946926}, {0.9999601416879698, 0.603913813236389}, {
     0.9999701011639365, 0.6039540971572371}, {0.9999800606399032, 
     0.6039943810780853}, {0.99999002011587, 0.604034664998934}, {
     0.9999999795918367, 0.6040749489197822}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.3876762278923171, 0.}, {0.408314119808649, 
     0.020315566064961543`}, {0.429331209352014, 0.04100440738860253}, {
     0.44893812949614426`, 0.060305103561126144`}, {0.47019610473083556`, 
     0.081231068385369}, {0.4900439105662921, 0.10076888805849446`}, {
     0.5095019551657791, 0.11992303384811473`}, {0.5306110548558273, 
     0.1407024482894543}, {0.5503099851466406, 0.16009371757967647`}, {
     0.5716599705280151, 0.1811102555216179}, {0.5926201946734201, 
     0.20174311958005417`}, {0.6121702494195903, 0.22098783848737305`}, {
     0.6333713592563216, 0.24185782604641118`}, {0.6531622996938181, 
     0.26133966845433193`}, {0.6725634788953451, 0.2804378369787474}, {
     0.6936157131874332, 0.30116127415488225`}, {0.7132577780802865, 
     0.3204965661798996}, {0.7345508980637009, 0.34145712685663626`}, {
     0.7544338486478805, 0.3610295423822556}, {0.7739270379960906, 
     0.38021828402436963`}, {0.7950712824348619, 0.40103229431820303`}, {
     0.8148053574743983, 0.4204581594609189}, {0.8361904876044959, 
     0.44150929325535415`}, {0.857185856498624, 0.46217675316628426`}, {
     0.8767710559935172, 0.4814560679260969}, {0.8980073105789717, 
     0.5023606513376289}, {0.9178333957651912, 0.5218770895980434}, {
     0.9372697197154413, 0.5410098539749526}, {0.9583570987562524, 
     0.5617678870035812}, {0.9780343083978288, 0.5811377748810924}, {
     0.9993625731299663, 0.602132931410323}, {0.9993725326059331, 
     0.602142735337623}, {0.9993824920818999, 0.6021525392649232}, {
     0.9994024110338333, 0.6021721471195233}, {0.9994422489377002, 
     0.6022113628287236}, {0.9995219247454339, 0.6022897942471239}, {
     0.9996812763609015, 0.6024466570839251}, {0.9996912358368683, 
     0.6024564610112252}, {0.999701195312835, 0.6024662649385253}, {
     0.9997211142647684, 0.6024858727931254}, {0.9997609521686354, 
     0.6025250885023257}, {0.9998406279763692, 0.6026035199207262}, {
     0.9998505874523359, 0.6026133238480263}, {0.9998605469283026, 
     0.6026231277753265}, {0.999880465880236, 0.6026427356299264}, {
     0.9999203037841029, 0.6026819513391267}, {0.9999302632600696, 
     0.6026917552664268}, {0.9999402227360363, 0.6027015591937268}, {
     0.9999601416879698, 0.602721167048327}, {0.9999701011639365, 
     0.602730970975627}, {0.9999800606399032, 0.6027407749029271}, {
     0.99999002011587, 0.6027505788302272}, {0.9999999795918367, 
     0.6027603827575273}}]}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVzH881HcAx3GJpdmIkt2ZJLLyY4oeROVdUSrUikyjy6OiKFampR/mCCnc
ehTNYxTSHsvCJSc1hc4tpqsjipaj7vu5O+6c06Q6hX32x/vxfjz/ednu/n5b
lL6ent5muv9/U9RAR9Pgdp8j+Z+1evnJYeDLPtTPWgZOw+cXjKndiwuKalh+
WK804Uh95Qh41H3zEisEc73M3nCpv9377t551l7U9VrMb10rh9T1tG8uKxHv
7WySQtfIUWKxJfMsKx0nbi5d9IOPHKlGNV+dYeWBKwnNqlguR9iOUv7I66tI
K3I74+Ash/FUaoT/PD5qr7VOJs6XY+HW4YHmbAHCo4xdJufIcfSxFwre3IFO
0F/IM5LDUmDWN21aI1p941NGPxLckvmKJSuF4EXxynaNEAhjL1ntGBKh1TOc
+wkhGHNYZVoZ1wL3jbKO1B4Cfd31WVYL25CvGd9jICbwmIq8FVwlxuKOR7Hh
TQTi9GWPHzhKsCQqyFEjILA5p9aVD7fj6xyOY+Y1AvW7/r6nS56A8+/i4tEi
gquq+jYTXifS1Zkh+88RmFj/riWkCzb554SW6QQ5MbXRJfbPoEoO+a0wieDt
6utkf0o3KnXlrQ4HCRLdRIK5zT0oFdyJzIwk6K8SZXfY/oNc/XAvTTDBh9iu
wsXHX0CtV97G8ydwWjNjMrq+Fyd9qtsNVhL4X7HdV23Zh+mmAZZprgRHrXct
eBXRj7vzip902hE4D2037g56iYG+4vWRXxDMNh0xEo2/hLGb24dRYwKDxkK+
XdErRIp+so/QIziwrP75zAAZKgYjeA9HGVzfuLuk4a0MBxqVN44oGYyp2bMU
FxlEdDlvePOCQW2w//Q8PwK/k9PnH5cwSNmQUSxQEOzck3ewq5mBrXRTT1mG
HKrxjsMxtxl4e6bnsdwUiF9YWmdYQTvzJLppnQrY/+yY8GMJ7bflyg6lKtGe
vS5u+AKDAgNO4jb7AVS1sKXeWQxm99Ve0RcNQE9QZCg8ycAwOTXE6/AgNrjf
iP/mEAO9cg5fZq6C8HVyYM1eBgm/8nPNhSq4+0pjrcMY3HPKMjKLV8Ny3eAa
YQADs00JzmkmQ3DJ5OeuWM2g16W989jdIXh/N4N9153BjcuwJxwNjsWxrMwW
MdjJ9zCzntTAaWlPV8mXDLgZpam9fwyj6/QiiecsBpUD1oUmgVrwrd19ygwY
bDUzWd4yrgV3vURj8V6Gs4b6Vr3U+sNVcXOoRbqxiRHqU/k8jTm1h0zazP6g
RSYJ0phSs2sqt8RTZ6eJh2ZSy0KC9ll81OJiw9/qiXcyJBbkXNwzoUWFh2hQ
Tl2Zwz2WRO3SVxZDqBXcxIhc6qqMU4My6rCYiAV11NVdawf7qVd5O1d9OqlF
XcL9gefUn/Q+/KuaWljVoHxEjfbGaw+ofUMv7xNTJ4lqsl9QiyaSlW3UqorC
rYZTWrQErlK2UD9OPiANoxar6hX3qWck7GqKo958vjC6iXp1dHBZGrXE64Si
gfrm5hUxFdRPsrwV9dTqta6B96mDl7Cj/6S297RzfUb9tFsnv03NcbI0V1OH
pjyPqqP+xcZ4bIq62+GOvJb6Pylqmec=
     "]]}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVznlM03cABXBOFUnK4RQLQwXLVMAjjFvZc9aAHGq4gmaIilAoDlGsQ5gM
MCiKVBlhiiunsKhD6OTwNw+UoyLUWq7KIeUq5SdStMyJimi77/54efn88/Js
IhOCovV0dHR2kfzfftGTXY2vQr/rbWMe8kihYcC2PDrCdEYF+6vbwpM0vi0p
KKxlbkfiQ4bWLomG/7O+miJmCBh1+gJzHo2wqA8NecwoeJe87lbF0xjamMXm
M3moP9G0rfggjdKlu89mMzORb8u11felkbGods15Zj6CTv09JrGgsWdvmXDm
nwq0dWbPL6+agLE2I9xnhRBvDyxgJ/lOwC7wzWTLhTpMlFfL218qkST1QMG7
u5BlZZs9T1XCos5sWFf3EXjXTXhvLZW4o2BLOrY0wzS27VibcBzNcUVWe6dF
SBqsasrzHsfsN14mVfFPkJu9BQlKBfTmKk2t7MSoeKEJM0hRwFV74E5wtQRx
nLjiymUKSDKdpa32HfhUoefmUz+GlbmquZtvOnE2Uxon8B+D6sPI8PNN3Wgp
YUt0X42iYuq+mHGxB59/mG5b9csoGNbX1UqlDFpxk4Xz0lHkcOs5paxecFXp
a2s5I3i/tVIZm9YH8emJsIS8YfCcRHXLWvqR+2uhYrdkCCPVogtdNi8QoLhX
XjYrx3ycTLAuZRBFBU5Gcls5HL5fqOHclyOo9XO7Z8QgfK7ZxNy2GIbGZUPT
4vMvkGS933YsfIT8qFmibRqA43Socd/OUdRwLy2Wa/qxxGRmkejTKHZ97HGz
d+iHwSOBcHXhGHZq4hoLo/tw2Pn+gJG/Amxvblr6pV5U+kaWPnyvgPTfRkVA
w3PMqixN6cvjeLD8cJnXnAz1wT76+duVuJZ26nIJS4a0HWdK6mglVPtGabuI
HtgM+fWXn5mAuKxoMF/QDU+3zHymE42SNc0LTrR1IXxFx5xuD40Blgc/Wb8L
s2K+4mjGSxhFWfip13eiwCCCF8SahIdLrsj8mRRLhuuv6YkmkRNf4bXc+xkM
UzNCPI69gnhd1mqd4qfQuRkhVJhPoVvGaNxkLkbi70K+efMUWvWj29nRbWhw
OLfI7IgK41/irdY2tsLML9HxNGMaT2krVqjbY8jXd/YkP5hGUXDB1Sh+C/4q
BksZ8RqewruPH2ibsE/oamateQ3dXr4nndyI9DNlGfI/3yBW96C78o8GVE1a
CxgBahxwnonl595DoBnD/cknNTYkfH183p1CtqGelZw4fWqH42/EornZLzPE
4ugTExuIXRVDLZbzavwYLg2LdKNgWVu1+wjxLd/0Le0uFBQhO2OWfiZ7LKXh
FScKvIKcy4e+qGE/UFng5EihKic9+SRxSkh/oMSBAp3OC+cTizsMjDnEe7jh
thRxXOu+1Kv2FLw8HasXa9S4UWsSqbOOwgL508e3iVkXjztI7Sig89GNVuKf
jEqVMcQnRbUXBolbMyVFusRTtwSBhlo1OD/bmbqwKEhTDw/tIb4R2/dOYEth
YeL+xnjij+P61S7EWznB5aeJd+zfFNNhQ6Fm12buLeLJ0PMDesSqbRsDmojd
u+rzCldRYLmt3thLfC5A4e9KHOFgYa4ilj1hGHaupHBlpfGslpjF3vyQS/wf
m/Z6hA==
     "]]}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVx3881HcAx3HE6MfjdH6kI9V1p1psFNEPeheaQolo2nQtomgJu9bZY6rz
IOH0qNYPG6ZIq3Su/Cjrl+LrR5zz+9wVp+4uk6OjIZLssz9ej9fjyQw9EhCu
p6Ojs530/73D+1qevg3a8ITHPfr9OTn0PSxjehhOqBxf37jsrByOuZnZJQxP
1PBm2IyckcOnsbM4hxEICe98u0Agx7f7Pzw+z9gPBe+O45MUObrtUzwyGFxM
8QaGFx+X44q536k0RhJc4/dH90bJwTcqWZbKuIAH8YEHYj3lCN59VTQ0fA3O
TgWLjYdlmD3ND/FaKMLZQWm0Y74MNv7v+qrSS3HrDKNcsUuGY5K1yBz5G+5v
xXV0fRksSukKXd0KlLvvi26414l7Sg9xk2slioIiXs4J60RlVI7V7gEKoTt+
9eiY24nRpW7GwsO1GNv600Y2JYXeROFcK5t6GE690J+MkcJ5+od7O4vEGC9i
cYJZUoiTnCQ1K5pwY0tCsWtnBxad1UzcfNcMaZaX5EZSBzQfehQdDq1QDb4/
nuXSgWv9D+tpZ9pwZIL2wVzdDpr1X1o1+YOB9VEW59shiCyLuMKWQqXYGpe7
uR1jGwvVB090QpBWt0n0vg3cVVTpvCoZTFcvv765oA09RVR6C/MFGL+Pt4T5
t2Eyqj3ry19eQqGWjxtNt8J2k+HniIdd4NtnlzoVt8Irj3ngroUC+Y5NLn2c
Vhyz3rvkdUgPCpxVfkvorbAbCJrdue0VwplGYSqqBabGQ0bUx1fIr85xs4tr
gX5FloiV/RrPDpoJJ9ktOOT0UD7TR4k91ZOqgJZmFG4NvfJkTInymSPmK080
Y1RjObf3kgrvfRu7Lq5qRtlOrxkXPNXY9dvXUv2KJpzYkpxb2qtGclrSAg2r
Ccxub1l+8hs4+n8K7kmXYJ1L0gXGql50pwWxVb2NCFnYNKHb1otvKmMYI76N
GK3PUMbw/0Hhj4dzzK6LkanP4Qaw+yAxs/NxnyWGqaIsT4/qQ4xgjjYhtgEG
CfzAtbFvQTsmYT5vqIfOTY5IadKPqL0Bx5kr6xH3hyjDpLIf1IP7kampz/HY
9rQRPVqDrDcbfKbVdaB7x9kl0gbgQDu9K9GnDl1fNbfFPxpA1c3iIbOCWtz5
E2w1ZxBmHrmlpTNrsUfkTLf+PAhloTA6NLYGJ5Ov8rtuvYMwJef+InE1hH3W
WTRfLVz2+a3oX1kNfzptTe1HLR4LlbZUGoU0Az2rLmJat9DhDjE1MTo1RMyZ
E786m9hZ2V1lOamFziFjcIktS4R+0cTuy10D2MTKwG0HzD9pUZ93kZeUSoGb
KbgUNqVF++Ut1Z6nKQgFJ+N5xEtrTesdiHtPckMyiH8eU0gWEAdHhiy5Tzw/
6KhsJIWC2zq7olmftfjOJE9zjfiLrobqu8SvBJN0A2I0V9yoIXZ4VDNv+BQF
HlWS/pI4UXPOqpu4/3aWv8G0Fizv5TZlxJKEQ93BxBGGQWvCiQ3j9j49TFzu
vNjNn3hjxM78RGKjCM0mN+Li7esjbxPfovg+5sQad3vfZ8Qf//XdoUvMdmHZ
S4l9WfODBpMpcGwtTDTE2QGq3XLiy4tmj04TD/CLONXE/wGxHYJE
     "]]}, 
   {GrayLevel[0], 
    LineBox[{{0.1088243509314053, 1.}, {0.12110912009821138`, 
     0.9509114078598683}, {0.1424808261288228, 0.8655124112299438}, {
     0.16346277092346467`, 0.7816708578115888}, {0.18303454631887175`, 
     0.70346418686824}, {0.20425737680483996`, 0.6186600806095872}, {
     0.22407003789157337`, 0.5394908568259407}, {0.24349293774233727`, 
     0.46187907625386354`}, {0.26456689268366235`, 0.3776698603664823}, {
     0.2842306782257526, 0.29909552695410735`}, {0.305545518858404, 
     0.21392375822642848`}, {0.32647059825508584`, 0.13030943271031914`}, {
     0.34598550825253294`, 0.05232998966921584}, {0.35908146019494164`, 
     0.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.26272851783176643`}, {
     0.00030671792055962676`, 0.26313135723846803`}, {0.0006134154329559882, 
     0.26353419664516964`}, {0.0012268104577487112`, 0.26433987545857285`}, {
     0.002453600507334157, 0.26595123308537927`}, {0.004907180606505049, 
     0.2691739483389921}, {0.009814340804846833, 0.2756193788462178}, {
     0.0196286612015304, 0.2885102398606691}, {0.040908357085458646`, 
     0.3164605808911297}, {0.06077788357015209, 0.34255870016831325`}, {
     0.08025764881887605, 0.3681448779438314}, {0.10138846915816112`, 
     0.3958996747209074}, {0.12110912009821138`, 0.4218022497447064}, {
     0.1424808261288228, 0.44987344377006344`}, {0.16346277092346467`, 
     0.47743269629375495`}, {0.18303454631887175`, 0.5031397270641694}, {
     0.20425737680483996`, 0.5310153768361419}, {0.22407003789157337`, 
     0.5570388048548373}, {0.24349293774233727`, 0.5825502913718672}, {
     0.26456689268366235`, 0.6102303968904552}, {0.2842306782257526, 
     0.636058280655766}, {0.305545518858404, 0.6640547834226349}, {
     0.32647059825508584`, 0.6915393446878383}, {0.34598550825253294`, 
     0.7171716841997646}, {0.3671514733405411, 0.7449726427132489}, {
     0.3869072690293145, 0.7709213794734562}, {0.408314119808649, 
     0.7990387352352213}, {0.429331209352014, 0.8266441494953212}, {
     0.44893812949614426`, 0.8523973420021439}, {0.47019610473083556`, 
     0.8803191535105245}, {0.4900439105662921, 0.9063887432656281}, {
     0.5095019551657791, 0.9319463915190662}, {0.5306110548558273, 
     0.9596726587740624}, {0.5503099851466406, 0.9855467042757815}, {
     0.5613138486485802, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.8884728870548046}, {
     0.00030671792055962676`, 0.8887077925219012}, {0.0006134154329559882, 
     0.8889426979889978}, {0.0012268104577487112`, 0.889412508923191}, {
     0.002453600507334157, 0.8903521307915774}, {0.004907180606505049, 
     0.8922313745283501}, {0.009814340804846833, 0.8959898620018957}, {
     0.0196286612015304, 0.9035068369489867}, {0.040908357085458646`, 
     0.9198053613883619}, {0.06077788357015209, 0.9350238102222184}, {
     0.08025764881887605, 0.9499437335007934}, {0.10138846915816112`, 
     0.9661282313245615}, {0.12110912009821138`, 0.9812326535428109}, {
     0.1424808261288228, 0.9976016503062534}, {0.14561216187004755`, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.4988268026924053, 1.}, {0.5095019551657791, 
     0.9586788335599783}, {0.5306110548558273, 0.8769701531577939}, {
     0.5503099851466406, 0.8007199282296409}, {0.5716599705280151, 
     0.7180788323168452}, {0.5926201946734201, 0.6369464163918561}, {
     0.6121702494195903, 0.5612724559408983}, {0.6333713592563216, 
     0.47920762450529797`}, {0.6531622996938181, 0.40260124854372886`}, {
     0.6725634788953451, 0.3275035525699667}, {0.6936157131874332, 
     0.2460149856115617}, {0.7132577780802865, 0.16998487412718832`}, {
     0.7345508980637009, 0.08756389165817208}, {0.7544338486478805, 
     0.010601364663187007`}, {0.7571726673685386, 0.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.6215348766511826}, {
     0.00030671792055962676`, 0.6216662497630812}, {0.0006134154329559882, 
     0.6217976228749796}, {0.0012268104577487112`, 0.6220603690987767}, {
     0.002453600507334157, 0.6225858615463709}, {0.004907180606505049, 
     0.623636846441559}, {0.009814340804846833, 0.6257388162319354}, {
     0.0196286612015304, 0.6299427558126882}, {0.040908357085458646`, 
     0.6390578602903307}, {0.06077788357015209, 0.6475689222348792}, {
     0.08025764881887605, 0.6559130309294106}, {0.10138846915816112`, 
     0.6649643649400788}, {0.12110912009821138`, 0.673411656417653}, {
     0.1424808261288228, 0.682566173211364}, {0.16346277092346467`, 
     0.691553736755058}, {0.18303454631887175`, 0.699937257765658}, {
     0.20425737680483996`, 0.7090280040923947}, {0.22407003789157337`, 
     0.7175147078860376}, {0.24349293774233727`, 0.7258344584296631}, {
     0.26456689268366235`, 0.7348614342894257}, {0.2842306782257526, 
     0.7432843676160942}, {0.305545518858404, 0.7524145262588995}, {
     0.32647059825508584`, 0.7613777316516879}, {0.34598550825253294`, 
     0.769736894511382}, {0.3671514733405411, 0.7788032826872131}, {
     0.3869072690293145, 0.7872656283299502}, {0.408314119808649, 
     0.7964351992888241}, {0.429331209352014, 0.8054378169976809}, {
     0.44893812949614426`, 0.8138363921734436}, {0.47019610473083556`, 
     0.8229421926653433}, {0.4900439105662921, 0.8314439506241489}, {
     0.5095019551657791, 0.8397787553329373}, {0.5306110548558273, 
     0.8488207853578628}, {0.5503099851466406, 0.8572587728496941}, {
     0.5716599705280151, 0.8664039856576622}, {0.5926201946734201, 
     0.8753822452156134}, {0.6121702494195903, 0.8837564622404704}, {
     0.6333713592563216, 0.8928379045814644}, {0.6531622996938181, 
     0.9013153043893642}, {0.6725634788953451, 0.909625750947247}, {
     0.6936157131874332, 0.9186434228212667}, {0.7132577780802865, 
     0.9270570521621923}, {0.7345508980637009, 0.9361779068192547}, {
     0.7544338486478805, 0.9446947189432231}, {0.7739270379960906, 
     0.9530445778171744}, {0.7950712824348619, 0.9621016620072627}, {
     0.8148053574743983, 0.9705547036642568}, {0.8361904876044959, 
     0.9797149706373878}, {0.857185856498624, 0.9887082843605017}, {
     0.8767710559935172, 0.9970975555505217}, {0.8835469668299083, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.36728026729702407`, 0.}, {0.3869072690293145, 
     0.02819430481037577}, {0.408314119808649, 0.058945373370675624`}, {
     0.429331209352014, 0.08913654759560619}, {0.44893812949614426`, 
     0.11730200508506206`}, {0.47019610473083556`, 0.1478392130393592}, {
     0.4900439105662921, 0.1763507042581819}, {0.5095019551657791, 
     0.20430230114163517`}, {0.5306110548558273, 0.23462564848992995`}, {
     0.5503099851466406, 0.26292327910275004`}, {0.5716599705280151, 
     0.2935926601804115}, {0.5926201946734201, 0.3237021469227037}, {
     0.6121702494195903, 0.3517859169295213}, {0.6333713592563216, 
     0.38224143740118033`}, {0.6531622996938181, 0.4106712411373647}, {
     0.6725634788953451, 0.43854115053817966`}, {0.6936157131874332, 
     0.46878281040383607`}, {0.7132577780802865, 0.4969987535340178}, {
     0.7345508980637009, 0.527586447129041}, {0.7544338486478805, 
     0.5561484239885895}, {0.7739270379960906, 0.5841505065127688}, {
     0.7950712824348619, 0.6145243395017894}, {0.8148053574743983, 
     0.6428724557553354}, {0.8361904876044959, 0.6735923224737227}, {
     0.857185856498624, 0.703752294856741}, {0.8767710559935172, 
     0.7318865505042843}, {0.8980073105789717, 0.7623925566166692}, {
     0.9178333957651912, 0.7908728459935793}, {0.9372697197154413, 
     0.8187932410351203}, {0.9583570987562524, 0.8490853865415025}, {
     0.9780343083978288, 0.8773518153124101}, {0.9993625731299663, 
     0.9079899945481592}, {0.9993725326059331, 0.9080043013946653}, {
     0.9993824920818999, 0.9080186082411714}, {0.9994024110338333, 
     0.9080472219341835}, {0.9994422489377002, 0.9081044493202075}, {
     0.9995219247454339, 0.9082189040922557}, {0.9996812763609015, 
     0.9084478136363522}, {0.9996912358368683, 0.9084621204828582}, {
     0.999701195312835, 0.9084764273293642}, {0.9997211142647684, 
     0.9085050410223763}, {0.9997609521686354, 0.9085622684084005}, {
     0.9998406279763692, 0.9086767231804488}, {0.9998505874523359, 
     0.9086910300269547}, {0.9998605469283026, 0.9087053368734608}, {
     0.999880465880236, 0.9087339505664728}, {0.9999203037841029, 
     0.9087911779524969}, {0.9999302632600696, 0.9088054847990029}, {
     0.9999402227360363, 0.9088197916455089}, {0.9999601416879698, 
     0.908848405338521}, {0.9999701011639365, 0.9088627121850269}, {
     0.9999800606399032, 0.908877019031533}, {0.99999002011587, 
     0.9088913258780391}, {0.9999999795918367, 0.9089056327245452}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.3642659144293477, 1.}, {0.3671514733405411, 
     0.9963281229907806}, {0.3869072690293145, 0.9711888504196855}, {
     0.408314119808649, 0.9439486083606798}, {0.429331209352014, 
     0.9172043379194741}, {0.44893812949614426`, 0.8922545096489233}, {
     0.47019610473083556`, 0.8652037118904619}, {0.4900439105662921, 
     0.8399473563026556}, {0.5095019551657791, 0.8151869723326491}, {
     0.5306110548558273, 0.788325618874732}, {0.5503099851466406, 
     0.7632587075874699}, {0.5716599705280151, 0.7360908268122972}, {
     0.5926201946734201, 0.7094189176549244}, {0.6121702494195903, 
     0.6845414506682065}, {0.6333713592563216, 0.657563014193578}, {
     0.6531622996938181, 0.6323790198896047}, {0.6725634788953451, 
     0.6076909972034312}, {0.6936157131874332, 0.580902005029347}, {
     0.7132577780802865, 0.555907455025918}, {0.7345508980637009, 
     0.5288119355345782}, {0.7544338486478805, 0.5035108582138935}, {
     0.7739270379960906, 0.4787057525110087}, {0.7950712824348619, 
     0.4517996773202132}, {0.8148053574743983, 0.4266880443000729}, {
     0.8361904876044959, 0.3994754417920218}, {0.857185856498624, 
     0.37275881090177054`}, {0.8767710559935172, 0.3478366221821745}, {
     0.8980073105789717, 0.3208134639746676}, {0.9178333957651912, 
     0.295584747937816}, {0.9372697197154413, 0.27085200351876415`}, {
     0.9583570987562524, 0.24401828961180166`}, {0.9780343083978288, 
     0.2189790178754943}, {0.9993625731299663, 0.19183877665127613`}, {
     0.9993725326059331, 0.19182610320673676`}, {0.9993824920818999, 
     0.19181342976219729`}, {0.9994024110338333, 0.19178808287311855`}, {
     0.9994422489377002, 0.19173738909496113`}, {0.9995219247454339, 
     0.1916360015386463}, {0.9996812763609015, 0.19143322642601635`}, {
     0.9996912358368683, 0.19142055298147698`}, {0.999701195312835, 
     0.1914078795369376}, {0.9997211142647684, 0.19138253264785893`}, {
     0.9997609521686354, 0.19133183886970134`}, {0.9998406279763692, 
     0.1912304513133864}, {0.9998505874523359, 0.19121777786884703`}, {
     0.9998605469283026, 0.19120510442430766`}, {0.999880465880236, 
     0.19117975753522898`}, {0.9999203037841029, 0.19112906375707156`}, {
     0.9999302632600696, 0.1911163903125322}, {0.9999402227360363, 
     0.19110371686799282`}, {0.9999601416879698, 0.19107836997891414`}, {
     0.9999701011639365, 0.19106569653437477`}, {0.9999800606399032, 
     0.1910530230898354}, {0.99999002011587, 0.19104034964529593`}, {
     0.9999999795918367, 0.19102767620075656`}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.06793246609550595, 0.}, {0.08025764881887605, 
     0.03443186959412747}, {0.10138846915816112`, 0.093463339282575}, {
     0.12110912009821138`, 0.14855533237664997`}, {0.1424808261288228, 
     0.20825974500614708`}, {0.16346277092346467`, 0.2668753130845366}, {
     0.18303454631887175`, 0.3215514045685535}, {0.20425737680483996`, 
     0.38083991558799274`}, {0.22407003789157337`, 0.4361889500130593}, {
     0.24349293774233727`, 0.4904491398870182}, {0.26456689268366235`, 
     0.5493217492963995}, {0.2842306782257526, 0.6042548821114082}, {
     0.305545518858404, 0.6638004344618391}, {0.32647059825508584`, 
     0.7222571422611623}, {0.34598550825253294`, 0.776774373466113}, {
     0.3671514733405411, 0.8359040242064859}, {0.3869072690293145, 
     0.8910941983524862}, {0.408314119808649, 0.9508967920339088}, {
     0.4258910338019844, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.7371662547544219, 1.}, {0.7544338486478805, 
     0.9890391583945763}, {0.7739270379960906, 0.9766655896073696}, {
     0.7950712824348619, 0.9632439909996142}, {0.8148053574743983, 
     0.9507175167222777}, {0.8361904876044959, 0.9371430126243926}, {
     0.857185856498624, 0.9238159148066037}, {0.8767710559935172, 
     0.911383941319234}, {0.8980073105789717, 0.8979039380113154}, {
     0.9178333957651912, 0.8853190590338158}, {0.9372697197154413, 
     0.8729815863364125}, {0.9583570987562524, 0.8595960838184608}, {
     0.9780343083978288, 0.8471057056309278}, {0.9993625731299663, 
     0.8335672976228461}, {0.9993725326059331, 0.8335609757091379}, {
     0.9993824920818999, 0.8335546537954295}, {0.9994024110338333, 
     0.8335420099680129}, {0.9994422489377002, 0.8335167223131797}, {
     0.9995219247454339, 0.8334661470035135}, {0.9996812763609015, 
     0.8333649963841807}, {0.9996912358368683, 0.8333586744704725}, {
     0.999701195312835, 0.8333523525567642}, {0.9997211142647684, 
     0.8333397087293476}, {0.9997609521686354, 0.8333144210745144}, {
     0.9998406279763692, 0.833263845764848}, {0.9998505874523359, 
     0.8332575238511397}, {0.9998605469283026, 0.8332512019374314}, {
     0.999880465880236, 0.8332385581100149}, {0.9999203037841029, 
     0.8332132704551818}, {0.9999302632600696, 0.8332069485414735}, {
     0.9999402227360363, 0.8332006266277652}, {0.9999601416879698, 
     0.8331879828003486}, {0.9999701011639365, 0.8331816608866404}, {
     0.9999800606399032, 0.8331753389729321}, {0.99999002011587, 
     0.8331690170592236}, {0.9999999795918367, 0.8331626951455153}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.8410014810559445, 0.}, {0.857185856498624, 
     0.026476081961767442`}, {0.8767710559935172, 0.05851558505540741}, {
     0.8980073105789717, 0.09325605551451119}, {0.9178333957651912, 
     0.12568962443599604`}, {0.9372697197154413, 0.157485581454223}, {
     0.9583570987562524, 0.19198250583791363`}, {0.9780343083978288, 
     0.2241725286839855}, {0.9993625731299663, 0.25906351889552115`}, {
     0.9993725326059331, 0.2590798116405162}, {0.9993824920818999, 
     0.25909610438551134`}, {0.9994024110338333, 0.25912868987550136`}, {
     0.9994422489377002, 0.25919386085548135`}, {0.9995219247454339, 
     0.25932420281544144`}, {0.9996812763609015, 0.25958488673536184`}, {
     0.9996912358368683, 0.2596011794803569}, {0.999701195312835, 
     0.2596174722253518}, {0.9997211142647684, 0.2596500577153419}, {
     0.9997609521686354, 0.25971522869532204`}, {0.9998406279763692, 
     0.25984557065528224`}, {0.9998505874523359, 0.2598618634002773}, {
     0.9998605469283026, 0.25987815614527227`}, {0.999880465880236, 
     0.2599107416352623}, {0.9999203037841029, 0.25997591261524233`}, {
     0.9999302632600696, 0.2599922053602373}, {0.9999402227360363, 
     0.2600084981052323}, {0.9999601416879698, 0.2600410835952223}, {
     0.9999701011639365, 0.2600573763402173}, {0.9999800606399032, 
     0.26007366908521234`}, {0.99999002011587, 0.2600899618302075}, {
     0.9999999795918367, 0.26010625457520253`}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.49954544888880625`, 1.}, {0.5095019551657791, 
     0.9669950666679337}, {0.5306110548558273, 0.8970202774608702}, {
     0.5503099851466406, 0.8317200744704907}, {0.5716599705280151, 
     0.7609467706076125}, {0.5926201946734201, 0.6914654905983575}, {
     0.6121702494195903, 0.6266587968057862}, {0.6333713592563216, 
     0.5563790021407166}, {0.6531622996938181, 0.49077379369233065`}, {
     0.6725634788953451, 0.4264606090975681}, {0.6936157131874332, 
     0.3566743236303067}, {0.7132577780802865, 0.2915626243797295}, {
     0.7345508980637009, 0.22097782425665352`}, {0.7544338486478805, 
     0.15506761035026134`}, {0.7739270379960906, 0.09044942029749248}, {
     0.7950712824348619, 0.02035812937222481}, {0.8012126625989312, 0.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.18949105637225128`, 1.}, {0.20425737680483996`, 
     0.7499322245025897}, {0.22407003789157337`, 0.41440462253418575`}, {
     0.24349293774233727`, 0.08547763076511838}, {0.24854032972711265`, 
     0.}}]}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVx384E3gAx3E06Rei5KYoZRI6PSKlq09XShZ5RE/qNOXESUVOl37Tw6X8
6B456VA0kYTD6HEqlfXjYUnNzJiNmW32w1BLTnHf++P9vJ+XbVjMniMGenp6
u0n/n35E8f7Z0N7NBmrmPP8CHijbrGLFVDf0Vt+L3VrIw9o7ufm1VC80nC7t
cGfysOstv6aAGoSYGeX5S8p42Bc+/iSLGo4eqxpnJYuHXpcr2zKo8ajzeeab
wuGh0ML/92vUZESWCtMbJ3lImlW78io1G21hFsYOBzoRvL+oamS0GHVH72cN
2PMxdzopxNumCl2BbmJjGR+0gGFFcxoLyTOWuCYUdeF02wbkfmqAjxdtzstj
AliyzET6+k3wjVhZlujYjXrJNs67H14gmrrrrc2Xbrw4WrB4v5oNkxst41+f
90Bnv8m04vhrjGm2DvlcFMJgonz+YloLtAJh6Bl6L9ZNH6oPrOTAqTSmwHK2
CJxkt7ZXju+g8WT065pFWPqHaqJsuB2toSce1GeKoRoXi3hrPmCsZqP1R1of
ipWNLSaZXGRMta88n94HE+tSrVTagWOrs91po31Ij6qLKLTrhILDLTH078fn
LeXSXy7x8dGt+ACf1Y94VzZrUXMX8o1HT/YtkEBcyU57b9uND5Vtrd1nJZg8
2pG36mwP/NZ2O+jEEjj9aDQV0ShEhEPY0I7NA/C+axtZbSnCPNlZ9dXiAZy2
Dl3eHyJGwML5gRSKFM7qvXP5fn3opnEf3z4sxQLTkVnsf/swMm0f5fhaCkpT
XtWK/H7co48naGiDiHZrFMzeJYH8YHBrUfogyn3CCp9+luB4kHzZb6OD0Kms
5styBpDVOCZI8pehLtB7RraXFF6qTN7FOhku7Uy5w5JJkZ1W6la7UA7bXnoX
M2UQq0yHc4zi5PD0SM6muspA/+nlRj++HCE27yb0uTLM+Y7q1eKugK4lQxKb
JEdwwbfM9fkK5FIY8XvsFNh+g7FJNKnAAlHdXQO2AqeOaYaZ+4dgeCEpaMPJ
Iaw1MR440DQEvTJGlcRcievLyjx9bJSI+6sqw/yFEgmTvA6HFCWeOKXOMjuh
QknDmjgHpRJm9DjnyyZqxCmMfg3dqYJwdTv3zGM1WsUx9VcqVfj7NuykDA2a
vYMOyo3VOFi1zsx6SoPprAijyGg1ElOKkoQPhvGmZPYnfrsaFQrrPBNfLVyc
VnklumgQYGay/vW/WtASBJ3UHA2uGRosFhJr51Vb2ROzJ3TfRogbilIZrsTr
JL3NVpNa+LV6yOjEVrUV/ieIT9nk6M4RS4L8Ii2+asFm71koIo7PTc/5+ZsW
4WacgLs3NahITzyTQPx9CfPPSmJZYnxIBvEXz3OCf4iDo0KWPyJOD3c8zCXe
5OlcOWdKC9aj1FhKrgYzha0vq4kpjO3XI4jR3nT/FXHb2BJuHHECuzathzj3
yqdFl4iVD/MCDKe1cK5m3r5J3HYhujeYOIhiUPmG2Cgu9NlxYptbgtEO4i0R
gczLxIrV1e79xDW7N0Y9JD6/79CTCWLVVhff58Q71B76M29pYOexwqWT2DTJ
dLs5McPJ0lxF3G0hT7Uhvrl0rm6auPjBU44j8X+pZI2z
     "]]}, 
   {GrayLevel[0], 
    LineBox[{{0.6300050247255377, 0.}, {0.6333713592563216, 
     0.038960761630138174`}, {0.6531622996938181, 0.2680140852883769}, {
     0.6725634788953451, 0.4925564506718473}, {0.6936157131874332, 
     0.7362075419508988}, {0.7132577780802865, 0.9635378328700078}, {
     0.7164082260474525, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.4637392869947622}, {
     0.00030671792055962676`, 0.4635268320031138}, {0.0006134154329559882, 
     0.4633143770114654}, {0.0012268104577487112`, 0.4628894670281686}, {
     0.002453600507334157, 0.462039647061575}, {0.004907180606505049, 
     0.46034000712838785`}, {0.009814340804846833, 0.45694072726201357`}, {
     0.0196286612015304, 0.45014216752926495`}, {0.040908357085458646`, 
     0.43540133192229846`}, {0.06077788357015209, 0.4216373465205924}, {
     0.08025764881887605, 0.40814335587523687`}, {0.10138846915816112`, 
     0.393505649088412}, {0.12110912009821138`, 0.3798447925068476}, {
     0.1424808261288228, 0.36504021978381385`}, {0.16346277092346467`, 
     0.3505056418171307}, {0.18303454631887175`, 0.33694791405570795`}, {
     0.20425737680483996`, 0.3222464701528159}, {0.22407003789157337`, 
     0.30852187645518425`}, {0.24349293774233727`, 0.29506727751390316`}, {
     0.26456689268366235`, 0.2804689624311527}, {0.2842306782257526, 
     0.2668474975536627}, {0.305545518858404, 0.25208231653470337`}, {
     0.32647059825508584`, 0.2375871302720946}, {0.34598550825253294`, 
     0.22406879421474626`}, {0.3671514733405411, 0.20940674201592863`}, {
     0.3869072690293145, 0.1957215400223714}, {0.408314119808649, 
     0.1808926218873449}, {0.429331209352014, 0.16633369850866891`}, {
     0.44893812949614426`, 0.15275162533525333`}, {0.47019610473083556`, 
     0.1380258360203685}, {0.4900439105662921, 0.12427689691074406`}, {
     0.5095019551657791, 0.11079795255747016`}, {0.5306110548558273, 
     0.09617529206272696}, {0.5503099851466406, 0.08252948177324415}, {
     0.5716599705280151, 0.06773995534229207}, {0.5926201946734201, 
     0.05322042366769053}, {0.6121702494195903, 0.03967774219834935}, {
     0.6333713592563216, 0.024991344587538933`}, {0.6531622996938181, 
     0.011281797181988906`}, {0.6694485686312062, 0.}}]}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVzntUDGgABfDpgWx2elhlSnVKhNhIIuFmprMxSXoRkhQRJ9mE2i2KsvRa
bK/dJiqdJUxTeniEpNk4pLKlSA/aTKP5PpOl2ima/fxxzz2/f+65lsER3rs0
ORzOepavLdwlf3b/nd+qHXJzv7NxBNoCkwM9PAf4lbrwi5kXX8gRlfNcIYwO
tqtldn/afj2P5wt7nT8nf2DetHPk7jneTmjNWXBvw1GCLrtfBGm8KBTtdrbR
P0aQP83zZDIvEf2yTar0eIIEnXKb07wMhL89k5d6gsB/c4Fk8EMRauYVlesk
E+iqEwLczCVQt/TUG50hmOX1Xl6XUoGRdqPIiVkERxqdkPPpFpZYKwcOiwiM
Kwy6NTRqsKNVGRRTSFDVK2hoWvEArQ1niz5fJniwN890M5Fi3MIufoeEYGj2
Sj1x+EMYt3/y968k0FRd1Ted9RiH27aqm6oJHNVBVT4lDZA6KQpf1hI0JDo0
1s9rwqORQ93ShwQWZxSq4vfNmDpe0L+wkUAx0tP9fOHf8NgzTL9vJSgaqH7M
TW/BUxNSK+4g4JpdUvb1tUJ7TtcC7huC1LDK0HzrNsz7fTiL008w7HK1b8+x
dmR5lz09SAmi7KUVRnUv8CEiQyPmI0FPiTTlmWUHzj2frqVWEYztbc2d+9Mr
DGTmiEI5FLarJ42HVndi0W2XxUETKdwKLXeXGXejZnZydscUiiNm263eBPTA
eWTsP5khxXzip9vu8Rr7rcL+bZ1OMVVvUEc6+hr9mUduCSwotGtyJTNFb+AZ
XhLnOotin0P1y8nuvfiSelKv3pbi6trg/HvDvQiZtMVprj3FkMJEX5b1D268
9QsyX0ZR6eOmleHaB68pH30zVlEcW5N0oULWh46smz+IXCksu4QvLia9hUls
THOSkGL50sQMnr0M+cWvbAY3UASYN6k0WmQwcg6NJRvZ/uO03gMJ/Xj23bnz
YdsocrQDo7yt5Yj1lt2NDmH/uysLNaVydA0sORQWRjEhLsHX6cd3SHwye7Qj
goJTHCjpNRyAqb5LbPchisg/JGmGDwYwIhp9EhxLcdf2lI7BfgVSEkvLHx2n
MBBGzj/OJfi2OT3n/imKzgXNLTF3CNpCuO5Ov1KUnod1XyBF2taqUUEmxTaJ
o4HZOMWYeDN/YS5FfFJBQueV9yhdc35TXgGFWG6Wy12nhI+b7l7RJQovA+6y
h6NKrEznCWeUUCRP0DTtZJbWcQzMmKWqoS+DzEJVf/tXO/Z21ZmMKbFxZ9Uu
C2aTcrHnfuaI5T4JVsy9vh67p31WIl+WenMOc1ROalbIFyW0wLFZwixOjY+J
Zj4d1U+/WhYfFZDGrHelscKR2T8swOoG84xpefxlzCuXzy/5ZlwJB4VToDPz
xM4nf5Uxh2YfzFzNjOaay/XMpGFLAJ85Wlqe8oo5UpM/U8A8cC3Xa4JaiaPh
+mWuzI1x+7r8mbMF4gY35kmR2++HM5vFZPy2htkl1OficeaLJT9vWct8fb1z
2DXmUp5QLmRW8O3W1TI7ei6SuDNbL51p18Z8J3H64XXMgbbGhgpm/m31Cg/m
bAvdITXzI6VMaz3z/+hSjf8=
     "]]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.45770925489040715`}, {
     0.00030671792055962676`, 0.45818220853933267`}, {0.0006134154329559882, 
     0.45865516218825814`}, {0.0012268104577487112`, 0.4596010694861091}, {
     0.002453600507334157, 0.461492884081811}, {0.004907180606505049, 
     0.46527651327321484`}, {0.009814340804846833, 0.47284377165602254`}, {
     0.0196286612015304, 0.48797828842163793`}, {0.040908357085458646`, 
     0.5207933893257553}, {0.06077788357015209, 0.5514338890804861}, {
     0.08025764881887605, 0.5814733438599213}, {0.10138846915816112`, 
     0.6140588660122431}, {0.12110912009821138`, 0.6444697870151783}, {
     0.1424808261288228, 0.6774267753910002}, {0.16346277092346467`, 
     0.7097827187915264}, {0.18303454631887175`, 0.7399640610426661}, {
     0.20425737680483996`, 0.7726914706666924}, {0.22407003789157337`, 
     0.803244279141332}, {0.24349293774233727`, 0.833196042640676}, {
     0.26456689268366235`, 0.8656938735129068}, {0.2842306782257526, 
     0.8960171032357509}, {0.305545518858404, 0.9288864003314817}, {
     0.32647059825508584`, 0.9611546524519169}, {0.34598550825253294`, 
     0.9912483034229655}, {0.35166074424134997`, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.5607610742400926}, {
     0.00030671792055962676`, 0.5605228726841103}, {0.0006134154329559882, 
     0.5602846711281277}, {0.0012268104577487112`, 0.5598082680161629}, {
     0.002453600507334157, 0.5588554617922331}, {0.004907180606505049, 
     0.5569498493443734}, {0.009814340804846833, 0.5531386244486545}, {
     0.0196286612015304, 0.5455161746572161}, {0.040908357085458646`, 
     0.5289889565823782}, {0.06077788357015209, 0.513556969252883}, {
     0.08025764881887605, 0.49842769625629557`}, {0.10138846915816112`, 
     0.4820161047677468}, {0.12110912009821138`, 0.46669974402454056`}, {
     0.1424808261288228, 0.45010106478937295`}, {0.16346277092346467`, 
     0.43380509988711324`}, {0.18303454631887175`, 0.4186043657301961}, {
     0.20425737680483996`, 0.40212131308131754`}, {0.22407003789157337`, 
     0.38673349117778155`}, {0.24349293774233727`, 0.3716483836071534}, {
     0.26456689268366235`, 0.3552809575445639}, {0.2842306782257526, 
     0.3400087622273169}, {0.305545518858404, 0.32345424841810866`}, {
     0.32647059825508584`, 0.3072024489418082}, {0.34598550825253294`, 
     0.2920458802108503}, {0.3671514733405411, 0.27560699298793107`}, {
     0.3869072690293145, 0.2602633365103543}, {0.408314119808649, 
     0.24363736154081622`}, {0.429331209352014, 0.22731410090418605`}, {
     0.44893812949614426`, 0.21208607101289836`}, {0.47019610473083556`, 
     0.19557572262964937`}, {0.4900439105662921, 0.18016060499174286`}, {
     0.5095019551657791, 0.16504820168674425`}, {0.5306110548558273, 
     0.1486534798897843}, {0.5503099851466406, 0.13335398883816685`}, {
     0.5716599705280151, 0.11677217929458808`}, {0.5926201946734201, 
     0.10049308408391719`}, {0.6121702494195903, 0.08530921961858877}, {
     0.6333713592563216, 0.06884303666129907}, {0.6531622996938181, 
     0.05347208444935183}, {0.6725634788953451, 0.03840384657031254}, {
     0.6936157131874332, 0.022053290199311876`}, {0.7132577780802865, 
     0.006797964573653781}, {0.722010528730882, 0.}}]}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVzXs01HkABXBkSulgcsqOV2dCjuhoZZWk20Ypr/LoLBvDWhKzWZWNap2M
TCm0VlZaRLSlxGyGtKu8ZuKsfjPz8yjKeM0OjUfGtisrYb/7xz33fP65lx3x
rX+UloaGhi/J/+0ZpepoGju8a99Ck0h0jIK2m3H8IMsRjDelxZYxFLYW5xcK
We4Q0Wnn+MRekp7qIlYgdt/ev9UjlsIXkbNPc1iRcPaiS9u5FPrtL7llsRJg
d2OQ1xFHoWTtwYtXWGlgfraIwQQKPB2h9WVWLvq+cXnyIYVCUPAtwfRft3HI
xJntUkBBd4kX4mEugI9Xt12DkIKV35RKlFGDKRdtdutzColSZ+T/8xviuXW8
nhEKRjXMAU3NRpwx1blsu0jhkcKNku1sQcRq+cf0TyRoiS0yCZ4UY/qJezDX
QYKZja76lcfbwFB7hmR7SqA1V2FgYtWO+bDu5w2REjgthT8KqKKQ5D8/bJ8s
AZXmKG3dJEMBo27I6icJ1mdPzN2bolE0O+NlJZBgYnZw4MWWTlhzO0Oj2yS4
PV7frne1Cz+aOcirhyXQM7urViq7UZK90e3CvASZMbVHSyxfwon/+FCeoRTv
d1coj53vQeVjSXv1ZikSHMQ160S9qDieMsHcJ8VglTijg/0al796lHQ2XIr5
2O4Cm7N9WL2ONxV9Vgrbz1csHq2Xw8h7bFV+jhQepezoh0YD0GzuvtbxQIpE
s7ANwyGDOFUXKvJ5JoXd5GHdHp8hZMSd6/Ptl8JQf1pH/GEIqZGm4cGzUmg3
FggsCoehKf8y446+DFzH+lcrvRQIzzG1WLCRoeJAREnDewUiV54q63WTYWbC
2GA070+oNaPb3x+RoTbAY1muuxJHnAdCzU/LcH4/v7hmVAnfd++up1+Vgd3v
2VvGH8Eot/D3xDsy7NiWlstyGAXH8o8D8U0yhJjL5jS7iDnXzlf0kv32LEU8
7w1ce4bY0+9kyNfmJPhbqtCpiqqtZ9AwHKgt1RKrENRqJW1m0mAk8wKdT4zh
oJt1EWVOQ+MeR6BYMw4dXmLjv5tonPxZkLWmZRwOnJX5NttpPLVN12HGTUBQ
MKI03UuD6XnSLlVvEuobBvxP/WjIN9NdZ55Monhbcp8nh8avN2Gp5LyFYd52
Pj+WRqjAiWm2+BavA3eVpZ6mkcK/xZPfn4KBkJ+YdoFGpcqsQM9bDd1Ok+K7
P9DwY+ptb/ugxnfZf38vK6RxhaFlIifu+SVLv4NYPDezME28o966tJPYSdEv
Mp5XY2nkSNsLYmNh5cE44nQXMVNOrAj0iV77UY3C0dw7KuKE/My8rxfUaNnp
RGsWkf/MlDNJxFb+dMQy4tGUhJAs4kvRsTPaxEExIRvqiL1zbhrrELvusKta
tajGyzfLo/SIl8ufP3tIPJbTM2dMDLqxvJXYq/xEpilxkliY0Udc9VR3vTnx
+IMCP8aSGqdUcGcTS5O5/UHEH13Lr1oTrzgZ1nScOCxgD9uGePfRgLJU4uZj
cuEm4mpfl5gHxBevGbzaTDyxx967mVhVfp9rT2y5zcL+JbFXg/viFmKOrdGa
CeLKroFsB+Lr63VnlogNxpIsHIn/Ax1UhCk=
     "]]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.5805649579488689}, {
     0.00030671792055962676`, 0.5814276818941165}, {0.0006134154329559882, 
     0.5822904058393642}, {0.0012268104577487112`, 0.5840158537298594}, {
     0.002453600507334157, 0.5874667495108501}, {0.004907180606505049, 
     0.5943685410728312}, {0.009814340804846833, 0.6081721241967937}, {
     0.0196286612015304, 0.6357792904447184}, {0.040908357085458646`, 
     0.6956379539311279}, {0.06077788357015209, 0.7515298851865858}, {
     0.08025764881887605, 0.8063254386182626}, {0.10138846915816112`, 
     0.8657653230404994}, {0.12110912009821138`, 0.9212384752317846}, {
     0.1424808261288228, 0.9813559584136298}, {0.14910876454070107`, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.8328743090530559, 0.}, {0.8361904876044959, 
     0.025541508212940434`}, {0.857185856498624, 0.18724974518656057`}, {
     0.8767710559935172, 0.3380967294461025}, {0.8980073105789717, 
     0.5016602898795282}, {0.9178333957651912, 0.6543625975988756}, {
     0.9372697197154413, 0.8040629289001328}, {0.9583570987562524, 
     0.9664798363752727}, {0.9627091850436534, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.5129986598121452, 0.}, {0.5306110548558273, 
     0.13546130264046036`}, {0.5503099851466406, 0.28697066585874814`}, {
     0.5716599705280151, 0.4511787036606949}, {0.5926201946734201, 
     0.6123889910367495}, {0.6121702494195903, 0.762753315482136}, {
     0.6333713592563216, 0.9258163145111815}, {0.6430165667743178, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.282920887120921}, {
     0.00030671792055962676`, 0.2825674871871954}, {0.0006134154329559882, 
     0.28221408725346975`}, {0.0012268104577487112`, 0.2815072873860185}, {
     0.002453600507334157, 0.28009368765111603`}, {0.004907180606505049, 
     0.27726648818131105`}, {0.009814340804846833, 0.2716120892417011}, {
     0.0196286612015304, 0.2603032913624812}, {0.040908357085458646`, 
     0.23578322578932842`}, {0.06077788357015209, 0.2128880634256527}, {
     0.08025764881887605, 0.19044201326339064`}, {0.10138846915816112`, 
     0.1660934932864156}, {0.12110912009821138`, 0.1433698765189176}, {
     0.1424808261288228, 0.11874378993670658`}, {0.16346277092346467`, 
     0.09456681555590928}, {0.18303454631887175`, 0.07201474438458905}, {
     0.20425737680483996`, 0.04756020339855577}, {0.22407003789157337`, 
     0.024730565621999573`}, {0.24349293774233727`, 0.0023500400468570992`}, {
     0.24553241587354283`, 0.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.4901102370631093}, {
     0.00030671792055962676`, 0.48987321079260476`}, {0.0006134154329559882, 
     0.4896361845221003}, {0.0012268104577487112`, 0.4891621319810912}, {
     0.002453600507334157, 0.4882140268990731}, {0.004907180606505049, 
     0.48631781673503693`}, {0.009814340804846833, 0.4825253964069645}, {
     0.0196286612015304, 0.47494055575081967`}, {0.040908357085458646`, 
     0.4584948829006285}, {0.06077788357015209, 0.443139036931877}, {
     0.08025764881887605, 0.4280844117047848}, {0.10138846915816112`, 
     0.411753794939791}, {0.12110912009821138`, 0.3965130050562369}, {
     0.1424808261288228, 0.3799962236347812}, {0.16346277092346467`, 
     0.3637806629549848}, {0.18303454631887175`, 0.34865492915662805`}, {
     0.20425737680483996`, 0.33225320382036977`}, {0.22407003789157337`, 
     0.3169413053655512}, {0.24349293774233727`, 0.30193062765239187`}, {
     0.26456689268366235`, 0.28564395840133094`}, {0.2842306782257526, 
     0.2704471160317097}, {0.305545518858404, 0.2539742821241869}, {
     0.32647059825508584`, 0.2378026689583234}, {0.34598550825253294`, 
     0.2227208826738995}, {0.3671514733405411, 0.20636310485157414`}, {
     0.3869072690293145, 0.1910951539106884}, {0.408314119808649, 
     0.1745512114319011}, {0.429331209352014, 0.1583084896947731}, {
     0.44893812949614426`, 0.14315559483908474`}, {0.47019610473083556`, 
     0.12672670844549488`}, {0.4900439105662921, 0.11138764893334463`}, {
     0.5095019551657791, 0.09634981016285371}, {0.5306110548558273, 
     0.0800359798544612}, {0.5503099851466406, 0.06481197642750836}, {
     0.5716599705280151, 0.048311981462653975`}, {0.5926201946734201, 
     0.032113207239458874`}, {0.6121702494195903, 0.017004259897703378`}, {
     0.6333713592563216, 0.0006193210180464037}, {0.6341727228149066, 
     0.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.5095721192064785, 0.}, {0.5306110548558273, 
     0.022870404786457202`}, {0.5503099851466406, 0.0442841548506174}, {
     0.5716599705280151, 0.06749268668868552}, {0.5926201946734201, 
     0.09027752802333373}, {0.6121702494195903, 0.11152944271589811`}, {
     0.6333713592563216, 0.13457613918237038`}, {0.6531622996938181, 
     0.15608990900675881`}, {0.6725634788953451, 0.17717998832772722`}, {
     0.6936157131874332, 0.20006484942260366`}, {0.7132577780802865, 
     0.22141678387539612`}, {0.7345508980637009, 0.24456350010209663`}, {
     0.7544338486478805, 0.2661772896867133}, {0.7739270379960906, 
     0.2873673887679099}, {0.7950712824348619, 0.31035226962301454`}, {
     0.8148053574743983, 0.33180422383603525`}, {0.8361904876044959, 
     0.3550509598229639}, {0.857185856498624, 0.37787400530647275`}, {
     0.8767710559935172, 0.3991641241478976}, {0.8980073105789717, 
     0.42224902476323045`}, {0.9178333957651912, 0.4438009987364794}, {
     0.9372697197154413, 0.46492928220630836`}, {0.9583570987562524, 
     0.4878523474500453}, {0.9780343083978288, 0.5092424860516984}, {
     0.9993625731299663, 0.5324274064272594}, {0.9993725326059331, 
     0.5324382328897106}, {0.9993824920818999, 0.5324490593521618}, {
     0.9994024110338333, 0.5324707122770641}, {0.9994422489377002, 
     0.5325140181268687}, {0.9995219247454339, 0.5326006298264778}, {
     0.9996812763609015, 0.5327738532256965}, {0.9996912358368683, 
     0.5327846796881476}, {0.999701195312835, 0.5327955061505987}, {
     0.9997211142647684, 0.5328171590755011}, {0.9997609521686354, 
     0.5328604649253057}, {0.9998406279763692, 0.532947076624915}, {
     0.9998505874523359, 0.5329579030873661}, {0.9998605469283026, 
     0.5329687295498173}, {0.999880465880236, 0.5329903824747196}, {
     0.9999203037841029, 0.5330336883245241}, {0.9999302632600696, 
     0.5330445147869753}, {0.9999402227360363, 0.5330553412494266}, {
     0.9999601416879698, 0.5330769941743287}, {0.9999701011639365, 
     0.53308782063678}, {0.9999800606399032, 0.533098647099231}, {
     0.99999002011587, 0.5331094735616824}, {0.9999999795918367, 
     0.5331203000241335}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.6969942000558345}, {
     0.00030671792055962676`, 0.6974094743430842}, {0.0006134154329559882, 
     0.697824748630334}, {0.0012268104577487112`, 0.6986552972048334}, {
     0.002453600507334157, 0.7003163943538324}, {0.004907180606505049, 
     0.7036385886518305}, {0.009814340804846833, 0.7102829772478265}, {
     0.0196286612015304, 0.7235717544398188}, {0.040908357085458646`, 
     0.7523848689383461}, {0.06077788357015209, 0.7792885871473729}, {
     0.08025764881887605, 0.8056645612015804}, {0.10138846915816112`, 
     0.8342760953703308}, {0.12110912009821138`, 0.8609782332495807}, {
     0.1424808261288228, 0.8899159312433735}, {0.16346277092346467`, 
     0.918325885082347}, {0.18303454631887175`, 0.94482644263182}, {
     0.20425737680483996`, 0.973562560295836}, {0.2237825370190561, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{0.4008730854725477, 0.}, {0.408314119808649, 
     0.04177207797050542}, {0.429331209352014, 0.1597566838013289}, {
     0.44893812949614426`, 0.26982495657470823`}, {0.47019610473083556`, 
     0.3891618335315017}, {0.4900439105662921, 0.5005823774308511}, {
     0.5095019551657791, 0.6098149006863756}, {0.5306110548558273, 
     0.7283160281253146}, {0.5503099851466406, 0.8389008225068094}, {
     0.5716599705280151, 0.9587542210717184}, {0.5790072530223476, 1.}}]}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVx3k41HkAx3GkEvsox9BMTXY0ZVsiKkeljy1lVyJFjVbaRyWmEh6h2pax
2A3TsTsrT44uPZSYMqSaQpku2WRLau75NUlMhp5GK8fsd/94P+/nxYrdv3GX
mYmJSSjp/wfv6u1seR+5Ege6kzp/lMJ8NSNJRV+C2+E3V4qipVh8prhURA+E
r3vJV39tk2Ld3911ZfQIeL2LqeJsl2LLzs93/qDvBDuqR6WKlULh8dtqPj0V
lv6G0IEEKc7SwvLy6TnoMrdbaJUhBc9C5HKULsBeQej7QIEUnKhzwsGhCvgy
nIfTO6WwMvKig+YIEbQl5lGppQzzwgd6WwvqcWORseL8KhnSn/qh+NNNPE4a
o8VnyuBYb6M0NW0GMz42xOmGDNep1e0dK+5hxgO2Y5FBhnvcsllROgl2tazT
ffCUwzDff3rNvocYT5bl+XDlMBupnjFrXhuW5j9sCKiUw9v40/VNte24GjX7
8nK1HO05S54++LYDhfe7qhxnKuB0on/k0sAzTCvuXy6KUKD/s0rZtegfPGJx
BQF8BSr6xG3Wx57DxXYNj9+mgDWzUq/VvkBveU6GeIoShQkNcWfZL6Gj3JbK
VioxHFCtjc/sxgm+Z96tw0qkeknqHVpfIU1fXlpQr4SqVlLQyZJirDE+aPZH
JUa5L0oWHJJBO/vUGN9dBdfvpk7EieWY7ueePhSnQtB51u5rjkpIxaw8+woV
0pnbnTXRKrwzHNm6QKGCmy7Sqnu9Gq5xZ0qPW6phN33QQvJFDZG5++a+b9Qw
by4Rzi3VQD6R9NF/jRp7lohfT1tHIdKN4gztUKP6h9izTcMUjJW5gbRsNQz9
jBk9RW8QnKmw9SpXo2FT0CRBoBZvj+6orr2tRub3uWfqe7RwHiybz36tBksR
/OpC7lscr7B0sTSoscwnR0D36sH6wotDYXYaRM/pGDF93oPqjk/lxzw0MLTx
qSTeO2xdm+KwMFSDYvOY1I3sXlyeWZEk4Wpgp2w4bybphaufxYb2PA0mH+FF
+CW/x1jh6ZHFFzUwuRQjpGz7kLhCkyu4q0HKaSHf9l4fPJ02yyPUGtxx/d3C
JrEf7A3jjbkTGtgEp7hlW+twU85JEzIoyBc+e37wtg5lpdSErx+Fq+Vga2M+
YO6Nr7niSArbhN42zIkPkLJObq1NppCVe44nvzwAdZMHzfQEhZpeZol1iB5H
G7PrQq5QCLex9n34RQ/em0mMf9so5E82myUnDqgrkowSS0YM44PEJrwF+43E
3pSilTGqR9acMMmUJxQYopqwROLMqNOJNGIqYv1u2pgev3QsavUiTi0uLNox
rsdh8ba9+4hrCrMOZhAvyx90SCbuyUqN5hN/4fx6N5WYkxDt3Eh8aLjK4Wdi
/2VutZYTehz0/NSSTzxF/uT+NeKMynxaFTGeNVc9IPZJY7ZUE2dIRAUy4s+B
V7lC4r4rJeGTjXqkU13N14mfHtmj4BCnMVnc+8RTU7a37CP21onsHxMHxG26
kE08fGttcztxXejyhCvEBzh77V8Q96/yCLlLvNTF2NRNzPaZ6/GS2GA4mSAj
jnF1tO0nbpCw7VXEp5ysDEbi1D8bmyji/wC7G4/l
     "]]}, 
   {GrayLevel[0], 
    LineBox[{{0.0976813493242141, 0.}, {0.10138846915816112`, 
     0.06395986935913311}, {0.12110912009821138`, 0.40420521191654607`}, {
     0.1424808261288228, 0.7729366225341294}, {0.15564144009819025`, 1.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.4994198677751742}, {
     0.00030671792055962676`, 0.4990897456225913}, {0.0006134154329559882, 
     0.49875962347000835`}, {0.0012268104577487112`, 0.49809937916484237`}, {
     0.002453600507334157, 0.4967788905545106}, {0.004907180606505049, 
     0.4941379133338468}, {0.009814340804846833, 0.4888559588925194}, {
     0.0196286612015304, 0.4782920500098647}, {0.040908357085458646`, 
     0.4553870744962891}, {0.06077788357015209, 0.4339999729098434}, {
     0.08025764881887605, 0.4130324013587289}, {0.10138846915816112`, 
     0.39028767205934844`}, {0.12110912009821138`, 0.3690608166870978}, {
     0.1424808261288228, 0.3460568035665812}, {0.16346277092346467`, 
     0.3234723204813958}, {0.18303454631887175`, 0.30240571132334026`}, {
     0.20425737680483996`, 0.2795619444170187}, {0.22407003789157337`, 
     0.258236051437827}, {0.24349293774233727`, 0.23732968849396657`}, {
     0.26456689268366235`, 0.21464616780184007`}, {0.2842306782257526, 
     0.19348052103684343`}, {0.305545518858404, 0.17053771652358082`}, {
     0.32647059825508584`, 0.14801444204564942`}, {0.34598550825253294`, 
     0.12700904149484787`}, {0.3671514733405411, 0.10422648319578037`}, {
     0.3869072690293145, 0.08296179882384264}, {0.408314119808649, 
     0.05991995670363898}, {0.429331209352014, 0.03729764461876656}, {
     0.44893812949614426`, 0.0161932064610239}, {0.46398230663014806`, 
     0.}}]}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVy3k4FHgAxnFXUfaZGp6yM6hV1DYk24qI3tCTIrVCS0k9bUzD00Gzj8ra
aB25ZqunHUpEzbbkGMcoaqkYtLJmMK4cwxhjMhgdkhT72z/e5/t8/njNjp85
EKyloaGxj+z/egQrW5+99tues3tG/YWbBh03+lkpzRZnOzgF31I4+P5Oxu1y
2k7YHF/H9InnwPPfrrIsmi/EUX4Deed+x48nZqqv004gpitAsSHvKvo3Jbql
0dgoWVopkcRdR86K/QnJtDgsD2eXMrZzEatXvj6JdgPdzhOhnSVZ8A/I5U+9
4cEpwX4sUnUf+guxge6r+MhTCeqTfi6Ghfeksi5FAP9CSpl0vAyRLQ7IeF+F
tVOKeYb6IYwE1AFNzaeYizCVfix8jIcyt2aRUy1MtD86zTyuQW1olnHAuBBx
+uY12oefY3qd87KiU43Q3BK13suuDlqzBcuNLZqwJpgnKnaoh93CsYc+xc14
KfjleSu9Ec1xti0NDBECGpbxot++wOqrqtn8STFSB9j1Lm+boJqRDnTYtMF9
ZZJNo6gZvLEnTRROO3i+Z16d6GgBxfQvtVwuAZtx5XH9SfJjVYTkmHfikGNJ
YZVfKz7sKJCfvNSFa14uNVUH28DeLBSsrOtG6lQ++9audkiLhSmtZq/Qw43y
SPSQYC5UkrnhYi++zn6QUbmnA5YuuvMhT/pgsqU0pcm+E+53zZilRgOIEH2T
rXToQqTp0TVDgVIkzzL9RhndsBr30+/yGgQ37qt4hlEPDJdN6Qk/DeK9AV1y
wegVdJ5m8tfeHsLK7xYa8xf3Isz2Sc8STxmSDnj1jizpQ8Ge4zk1H2SYknwM
CdHrx7SKvlzBHQZ9NCq9cbofFT7u2jd2ysH9zBy1nRnApd3xdwQKOTpzLfsu
j0ph1u/RfS9+BDq+93nJrEE42sfdoG1WoMFfNRbwehCBq0Szmu0KhFrc/u3m
sSFMN6XJzsaO4tE5TSvp0BAydILYB8yVUCS1rfvjkAyGAxV3tYRKcH5oOzIh
lmFRdKyvQ/hrSDMSeJ7ew9DID+LLDMZgkH/fmf7PMCJu8dMMascw6RilmPSQ
o9ryih71tAo7o399GdwkB9UjwuoyZRwXEye0vFxG0LdR3H7h73EcNqR6ONaO
oCQb5vKgCZgwc4bTHRU4wrejms5PwD8sqCq9RIGY+NzYvgeTcHojzs6yGUWR
0jSTslcNLfA7DfNG4U2lbG38pEY4xXXV1Q1KJC/SMu4jrr4pzbhDLJyd/jJF
vNQi2pBPbCfrr6PPqZG7rVKvhZheXrT/NLH4pPU7fYYSMl8v5orPaljX0V8k
ErMzUrk/fVFjPPJd+CVLJYpSYy6cJ96qfW2cQ6yIYQemEcdxrJnZxP6swDWP
iI3/ZAVWEzs7WhUvnVfDs026a454cd/L+lLiB1bNxpFWSkD8NK+B+MMjFjeB
+LywPKWX2NVNl8olHivM9F60oEZPgOviCuKW6LB+f2K9xMqpt8S6EUefnSL2
NTgYprVRiR0hPvcuE+dkvRuhEpft28YqJLYXWPfaEKtcN+19Tvwbmv12EJvb
r93USSxqYon3EwdZGhmoiE0O6noeJU5frT+9QMwc4tWfJv4PbdWAkA==
     "]]}, 
   {GrayLevel[0], 
    LineBox[{{0.61309911971743, 1.}, {0.6333713592563216, 
     0.8568240241647669}, {0.6531622996938181, 0.7170473012033297}, {
     0.6725634788953451, 0.5800233301120366}, {0.6936157131874332, 
     0.43133851497362563`}, {0.7132577780802865, 0.29261324966398905`}, {
     0.7345508980637009, 0.14222714030723482`}, {0.7544338486478805, 
     0.0018005807792541573`}, {0.7546887922908572, 0.}}]}, 
   {GrayLevel[0], 
    LineBox[{{2.040816326530612*^-8, 0.7618140991981193}, {
     0.00030671792055962676`, 0.7602762399873912}, {0.0006134154329559882, 
     0.7587383807766632}, {0.0012268104577487112`, 0.7556626623552072}, {
     0.002453600507334157, 0.749511225512295}, {0.004907180606505049, 
     0.7372083518264707}, {0.009814340804846833, 0.7126026044548223}, {
     0.0196286612015304, 0.6633911097115253}, {0.040908357085458646`, 
     0.5566893107275872}, {0.06077788357015209, 0.4570584592135374}, {
     0.08025764881887605, 0.35938196951363155`}, {0.10138846915816112`, 
     0.2534266703163816}, {0.12110912009821138`, 0.15454231858901984`}, {
     0.1424808261288228, 0.04737915736431386}, {0.15192972080117173`, 0.}}]}},
  
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.395575787052944*^9, 3.395738220558771*^9, 
  3.3979843081677485`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.1 Process Intensity", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.395730306739258*^9, 3.3957303104646144`*^9}, {
  3.412319716889888*^9, 3.4123197186624365`*^9}}],

Cell["\<\
The required measure of the process intensity is the total line length per \
unit area. Each line has different length, so we compute first the expected \
length of a line in our unit square. Referring to Figure 3.3, we observe that \
there are two classes of line that we must consider. Our treatment is similar \
to that followed in the previous section.\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.41231972836639*^9, 3.4123198056775584`*^9}, {
  3.4123198472072754`*^9, 3.4123198718727427`*^9}}],

Cell[CellGroupData[{

Cell["Case 1: Lines of Type A and C", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.41231981642301*^9, 3.4123198307335873`*^9}}],

Cell[TextData[{
 "We require fist the probability densities of the random variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["X", "sq"], "=", 
    SuperscriptBox["x", "2"]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Y", "sq"], "=", " ", 
    SuperscriptBox["y", "2"]}], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412319895426611*^9, 3.41231993300064*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pdfXsquared", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{
    SqrtBox["Xsq"], ",", " ", "Xsq"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"pdfYsquared", "=", " ", 
  RowBox[{"pdfXsquared", "/.", 
   RowBox[{"Xsq", "\[Rule]", "Ysq"}]}]}]}], "Input",
 CellChangeTimes->{{3.3957431772261086`*^9, 3.3957431786381392`*^9}}],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"2", " ", 
   SqrtBox["Xsq"]}]]], "Output",
 CellChangeTimes->{
  3.395743188422208*^9, 3.3957449566748304`*^9, 3.395745281381736*^9, 
   3.3957466175430417`*^9, 3.3957469369823728`*^9, 3.3957469828282957`*^9, 
   3.3957486916654835`*^9, 3.3957487448920193`*^9, 3.395749671424307*^9, 
   3.395749725722384*^9, 3.395986881364896*^9, {3.3959977462177873`*^9, 
   3.3959977749691296`*^9}, 3.39599810835852*^9, 3.3959983079154687`*^9, 
   3.3959989132959633`*^9, 3.3960001992650957`*^9, 3.396007020102979*^9, 
   3.3960778334976397`*^9, 3.396249855505229*^9, 3.397984312103408*^9, 
   3.40473427110525*^9, 3.4117375334695873`*^9}],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"2", " ", 
   SqrtBox["Ysq"]}]]], "Output",
 CellChangeTimes->{
  3.395743188422208*^9, 3.3957449566748304`*^9, 3.395745281381736*^9, 
   3.3957466175430417`*^9, 3.3957469369823728`*^9, 3.3957469828282957`*^9, 
   3.3957486916654835`*^9, 3.3957487448920193`*^9, 3.395749671424307*^9, 
   3.395749725722384*^9, 3.395986881364896*^9, {3.3959977462177873`*^9, 
   3.3959977749691296`*^9}, 3.39599810835852*^9, 3.3959983079154687`*^9, 
   3.3959989132959633`*^9, 3.3960001992650957`*^9, 3.396007020102979*^9, 
   3.3960778334976397`*^9, 3.396249855505229*^9, 3.397984312103408*^9, 
   3.40473427110525*^9, 3.4117375334695873`*^9}]
}, Open  ]],

Cell[TextData[{
 "Again, we perform our analysis over two intervals to determine the \
probability density of the random variable ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["l", "1"], "2"], "=", " ", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", " ", 
     SuperscriptBox["y", "2"]}]}], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412319964425827*^9, 3.4123200005377536`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pdfLsquaredInterval1", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"pdfXsquared", " ", 
      RowBox[{"(", 
       RowBox[{"pdfYsquared", "/.", 
        RowBox[{"Ysq", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"Lsq", " ", "-", " ", "Xsq"}], ")"}]}]}], ")"}]}], ",", " ",
      
     RowBox[{"{", 
      RowBox[{"Xsq", ",", " ", "0", ",", "Lsq"}], "}"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "Lsq", "]"}], ">", "0"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdfLsquaredInterval2", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"pdfXsquared", " ", 
      RowBox[{"(", 
       RowBox[{"pdfYsquared", "/.", 
        RowBox[{"Ysq", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"Lsq", "-", "Xsq"}], ")"}]}]}], ")"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"Xsq", ",", " ", 
       RowBox[{"Lsq", "-", "1"}], ",", "1"}], "}"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"1", "<", "Lsq", "<", "2"}]}]}], "  ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"pdfLsquaredCase1", " ", "=", " ", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pdfLsquaredInterval1", ",", " ", 
       RowBox[{"0", "\[LessEqual]", "Lsq", "<", "1"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"pdfLsquaredInterval2", ",", 
       RowBox[{"1", "\[LessEqual]", "Lsq", "\[LessEqual]", " ", "2"}]}], 
      "}"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"pdfLsquaredCase1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"Lsq", ",", " ", "0", ",", "1"}], "}"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", "<", "Lsq", "<", "1"}]}]}], "]"}], "+", 
   RowBox[{"Integrate", "[", 
    RowBox[{"pdfLsquaredCase1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"Lsq", ",", " ", "1", ",", " ", "2"}], "}"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"1", "<", "Lsq", "<", " ", "2"}]}]}], "]"}]}], "]"}]}], "Input",\

 CellChangeTimes->{{3.3957258006898766`*^9, 3.3957258288103123`*^9}, {
   3.395730338294632*^9, 3.3957303513333807`*^9}, 3.3957324203484783`*^9, {
   3.3957324626593184`*^9, 3.395732463330283*^9}, {3.3957331986876755`*^9, 
   3.3957331989180064`*^9}, {3.3957493600365534`*^9, 3.3957494501861825`*^9}}],\


Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox["\[Pi]", "4"], 
     RowBox[{"0", "\[LessEqual]", "Lsq", "<", "1"}]},
    {
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ArcCsc", "[", 
         SqrtBox["Lsq"], "]"}], "-", 
        RowBox[{"ArcTan", "[", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "Lsq"}]], "]"}]}], ")"}]}], 
     RowBox[{"1", "\[LessEqual]", "Lsq", "\[LessEqual]", "2"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellChangeTimes->{
  3.3957433727772975`*^9, 3.3957449614116416`*^9, 3.3957452855577407`*^9, 
   3.395746624743395*^9, 3.39574694145881*^9, 3.3957469897382317`*^9, 
   3.395748696021747*^9, 3.3957487487275343`*^9, {3.39574943720752*^9, 
   3.395749452339278*^9}, 3.395749677242674*^9, 3.395749732101557*^9, 
   3.3959868938428383`*^9, 3.395997747319371*^9, 3.395997779235264*^9, 
   3.3959981144072175`*^9, 3.3959983125020638`*^9, 3.395998918243077*^9, 
   3.3960002051135054`*^9, 3.3960070278441105`*^9, 3.3960778438224864`*^9, 
   3.3962498660904493`*^9, 3.3979843176614*^9, 3.404734274433375*^9, 
   3.4117375385168447`*^9}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.3957433727772975`*^9, 3.3957449614116416`*^9, 3.3957452855577407`*^9, 
   3.395746624743395*^9, 3.39574694145881*^9, 3.3957469897382317`*^9, 
   3.395748696021747*^9, 3.3957487487275343`*^9, {3.39574943720752*^9, 
   3.395749452339278*^9}, 3.395749677242674*^9, 3.395749732101557*^9, 
   3.3959868938428383`*^9, 3.395997747319371*^9, 3.395997779235264*^9, 
   3.3959981144072175`*^9, 3.3959983125020638`*^9, 3.395998918243077*^9, 
   3.3960002051135054`*^9, 3.3960070278441105`*^9, 3.3960778438224864`*^9, 
   3.3962498660904493`*^9, 3.3979843176614*^9, 3.404734274433375*^9, 
   3.4117375404396095`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Case 2: Lines of Type B", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.4123200098311167`*^9, 3.4123200230000525`*^9}}],

Cell[TextData[{
 "We require first the probability density of the random variable ",
 StyleBox["X",
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{
     SubscriptBox["x", "i"], " ", "-", " ", 
     SubscriptBox["x", "j"]}]}], TraditionalForm]]],
 "|:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123200422277007`*^9, 3.4123200747044*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfX", " ", "=", " ", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "X", ",", " ", "1"}], "}"}]}], "]"}], " ", "+", 
   " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", 
       RowBox[{"1", "-", "X"}]}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.395726730877421*^9, 3.395726778055259*^9}, {
   3.39573255977897*^9, 3.3957325994059505`*^9}, {3.3957327214614573`*^9, 
   3.395732721791933*^9}, {3.3957436626340914`*^9, 3.395743684956189*^9}, 
   3.3957439704366894`*^9, 3.3957441454183006`*^9}],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"2", " ", "X"}]}]], "Output",
 CellChangeTimes->{3.395744148072117*^9, 3.395744963284334*^9, 
  3.395745287370347*^9, 3.3957466266060734`*^9, 3.395746943351531*^9, 
  3.3957469957969437`*^9, 3.395748697814325*^9, 3.3957487504800544`*^9, 
  3.3957494579874*^9, 3.395749679075309*^9, 3.3957497340042925`*^9, 
  3.395986895765603*^9, 3.3959977810578847`*^9, 3.3959981163099537`*^9, 
  3.395998314304656*^9, 3.3959989202058992`*^9, 3.3960002070062275`*^9, 
  3.396007030217523*^9, 3.396077845915496*^9, 3.396249867953128*^9, 
  3.397984319644251*^9, 3.40473427610525*^9, 3.41173754059984*^9}]
}, Open  ]],

Cell[TextData[{
 "So the probability density of the random variable ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["X", "sq"], " ", "=", " ", 
    SuperscriptBox["X", "2"]}], TraditionalForm]]],
 " is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412320080632925*^9, 3.4123201054886656`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfXsquared", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       SqrtBox["Xsq"], ",", " ", "Xsq"}], "]"}], "pdfX"}], "/.", 
    RowBox[{"X", "\[Rule]", 
     SqrtBox["Xsq"]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.395726730877421*^9, 3.395726778055259*^9}, {
   3.39573255977897*^9, 3.3957325994059505`*^9}, {3.3957327214614573`*^9, 
   3.395732721791933*^9}, {3.3957436626340914`*^9, 3.395743684956189*^9}, 
   3.3957439704366894`*^9, 3.3957441454183006`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  FractionBox["1", 
   SqrtBox["Xsq"]]}]], "Output",
 CellChangeTimes->{3.3957443361024914`*^9, 3.3957449633644495`*^9, 
  3.395745287420419*^9, 3.3957466266561456`*^9, 3.3957469434116173`*^9, 
  3.3957469959371457`*^9, 3.395748697864397*^9, 3.3957487505301266`*^9, 
  3.395749461282138*^9, 3.3957496791153665`*^9, 3.3957497340543647`*^9, 
  3.3959868958256893`*^9, 3.395997781148014*^9, 3.3959981163800545`*^9, 
  3.395998314374757*^9, 3.395998920276*^9, 3.396000207096357*^9, 
  3.3960070303076525`*^9, 3.396077845995611*^9, 3.3962498680232286`*^9, 
  3.39798431966428*^9, 3.40473427616775*^9, 3.4117375406599264`*^9}]
}, Open  ]],

Cell[TextData[{
 "and the probability density of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["l", "2"], "2"], "=", " ", 
    RowBox[{"1", " ", "+", " ", 
     SuperscriptBox["X", "2"]}]}], TraditionalForm]]],
 "is obtained using a variable transform:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123201415405054`*^9, 3.4123201799156866`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pdfLsquaredCase2", " ", "=", " ", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"pdfXsquared", "/.", 
       RowBox[{"Xsq", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"Lsq", "-", "1"}], ")"}]}]}], ",", " ", 
      RowBox[{"1", "\[LessEqual]", "Lsq", "\[LessEqual]", " ", "2"}]}], "}"}],
     "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"pdfLsquaredCase2", ",", " ", 
   RowBox[{"{", 
    RowBox[{"Lsq", ",", " ", "1", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"1", "<", "Lsq", "<", "2"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.395726928321331*^9, 3.3957269307147727`*^9}, {
   3.3957270230875983`*^9, 3.395727051418336*^9}, 3.3957271067579107`*^9, 
   3.395727183488243*^9, {3.3957272289035473`*^9, 3.3957272808882976`*^9}, {
   3.3957273431077647`*^9, 3.3957273473037987`*^9}, 3.3957280015745935`*^9, {
   3.3957280426736913`*^9, 3.395728044546384*^9}, 3.3957281051435184`*^9, {
   3.3957283294961214`*^9, 3.395728335815208*^9}, {3.3957284710096083`*^9, 
   3.3957284737034817`*^9}, {3.3957285302447844`*^9, 
   3.3957285622508063`*^9}, {3.395728728059227*^9, 3.3957287672555885`*^9}, {
   3.395728810968445*^9, 3.3957288629932528`*^9}, {3.395728942687848*^9, 
   3.3957289606336527`*^9}, {3.395732732387168*^9, 3.395732734149702*^9}, {
   3.3957331688547773`*^9, 3.395733189013765*^9}, {3.395744400294795*^9, 
   3.395744406984414*^9}, {3.3957494661391215`*^9, 3.3957494949305215`*^9}}],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", "Lsq"}]]]}], 
     RowBox[{"1", "\[LessEqual]", "Lsq", "\[LessEqual]", "2"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellChangeTimes->{{3.395728757591693*^9, 3.3957287725331774`*^9}, {
   3.3957288479816675`*^9, 3.395728864946061*^9}, 3.395728946923939*^9, 
   3.3957289908470974`*^9, 3.395732734800638*^9, {3.395733172940653*^9, 
   3.395733190145392*^9}, 3.395744543440629*^9, 3.3957449634345503`*^9, 
   3.3957452874704914`*^9, 3.395746626706218*^9, 3.395746943471704*^9, 
   3.395746995987218*^9, 3.395748697914469*^9, 3.3957487505801983`*^9, {
   3.3957494768044577`*^9, 3.3957494969334016`*^9}, 3.3957496791654387`*^9, 
   3.3957497340944223`*^9, 3.3959868959458623`*^9, 3.395997781208101*^9, 
   3.395998116430126*^9, 3.3959983144248285`*^9, 3.3959989203861585`*^9, 
   3.396000207146429*^9, 3.3960070303977823`*^9, 3.3960778460757265`*^9, 
   3.396249868083315*^9, 3.3979843197343807`*^9, 3.404734276199*^9, 
   3.4117375407200127`*^9}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.395728757591693*^9, 3.3957287725331774`*^9}, {
   3.3957288479816675`*^9, 3.395728864946061*^9}, 3.395728946923939*^9, 
   3.3957289908470974`*^9, 3.395732734800638*^9, {3.395733172940653*^9, 
   3.395733190145392*^9}, 3.395744543440629*^9, 3.3957449634345503`*^9, 
   3.3957452874704914`*^9, 3.395746626706218*^9, 3.395746943471704*^9, 
   3.395746995987218*^9, 3.395748697914469*^9, 3.3957487505801983`*^9, {
   3.3957494768044577`*^9, 3.3957494969334016`*^9}, 3.3957496791654387`*^9, 
   3.3957497340944223`*^9, 3.3959868959458623`*^9, 3.395997781208101*^9, 
   3.395998116430126*^9, 3.3959983144248285`*^9, 3.3959989203861585`*^9, 
   3.396000207146429*^9, 3.3960070303977823`*^9, 3.3960778460757265`*^9, 
   3.396249868083315*^9, 3.3979843197343807`*^9, 3.404734276199*^9, 
   3.4117375409102864`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Combined Distribution", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.4123201866954355`*^9, 3.4123201912019153`*^9}}],

Cell[TextData[{
 "We combine the distributions for our two cases using a ",
 StyleBox["Piecewise", "Input"],
 " function, noting that lines of type A and C are twice as likely as lines \
of type B:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123201933049393`*^9, 3.4123202515386753`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfLsquared", " ", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"PiecewiseExpand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "/", "3"}], ")"}], "pdfLsquaredCase1"}], " ", "+", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "3"}], ")"}], "pdfLsquaredCase2"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.3957271882050257`*^9, 3.3957272084841857`*^9}, {
   3.3957272903318768`*^9, 3.3957272958097534`*^9}, {3.3957273790895042`*^9, 
   3.395727400640493*^9}, {3.395727682025104*^9, 3.395727691408597*^9}, {
   3.3957278488149357`*^9, 3.3957278523500195`*^9}, {3.395729012918835*^9, 
   3.3957290189374895`*^9}, {3.3957332466666656`*^9, 
   3.3957332468969965`*^9}, {3.395744735166317*^9, 3.3957447358773394`*^9}, {
   3.3957449377376003`*^9, 3.395744941493*^9}, {3.395746789179843*^9, 
   3.395746826874045*^9}, {3.3957468592105427`*^9, 3.395746901611512*^9}, 
   3.395746948749293*^9, {3.3957494996072464`*^9, 3.395749507158104*^9}}],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox["\[Pi]", "6"], 
     RowBox[{"0", "\[LessEqual]", "Lsq", "<", "1"}]},
    {
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        FractionBox["1", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "Lsq"}]]], "+", 
        RowBox[{"ArcCsc", "[", 
         SqrtBox["Lsq"], "]"}], "-", 
        RowBox[{"ArcTan", "[", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "Lsq"}]], "]"}]}], ")"}]}], 
     RowBox[{"1", "\[LessEqual]", "Lsq", "\[LessEqual]", "2"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellChangeTimes->{
  3.395727209265309*^9, {3.3957272735377283`*^9, 3.3957272964306464`*^9}, 
   3.3957273505384493`*^9, {3.3957273843570786`*^9, 3.3957274013314867`*^9}, {
   3.395727686731872*^9, 3.3957276921997347`*^9}, 3.395727802298048*^9, 
   3.3957278533013873`*^9, 3.3957282196281395`*^9, {3.3957290046168976`*^9, 
   3.3957290203595343`*^9}, 3.3957331580892973`*^9, 3.3957332479885664`*^9, {
   3.395744932109507*^9, 3.395744965006811*^9}, 3.3957452890127087`*^9, 
   3.3957466282384205`*^9, {3.395746799064056*^9, 3.3957468160785217`*^9}, {
   3.3957468514093246`*^9, 3.3957469036043777`*^9}, {3.39574694712696*^9, 
   3.395746997579507*^9}, 3.3957486994667006`*^9, 3.3957487521424446`*^9, 
   3.3957495099521217`*^9, 3.3957496806976414`*^9, 3.39574973563664*^9, 
   3.3959868974480224`*^9, 3.3959977827803617`*^9, 3.39599811796233*^9, 
   3.3959983159670467`*^9, 3.395998921888318*^9, 3.396000208658603*^9, 
   3.3960070320301294`*^9, 3.396077847587901*^9, 3.396249869545418*^9, 
   3.3979843212165117`*^9, 3.404734277714625*^9, 3.411737542212158*^9}]
}, Open  ]],

Cell[TextData[{
 "We may now obtain the probability density that we require for the random \
variable ",
 StyleBox["l",
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SubscriptBox["L", "sq"]], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412320265709051*^9, 3.4123203204277325`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Lsq", " ", "=", " ", 
   SuperscriptBox["l", "2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdfL", " ", "=", " ", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"Lsq", ",", " ", "l"}], "]"}], " ", "pdfLsquared"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"pdfL", " ", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"PowerExpand", "[", 
     RowBox[{"PiecewiseExpand", "[", "pdfL", "]"}], "]"}], ",", " ", 
    RowBox[{"l", "\[GreaterEqual]", "0"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.395727541753403*^9, 3.395727546430128*^9}, 
   3.3957294439986973`*^9, {3.395733269379325*^9, 3.3957332696497135`*^9}, {
   3.3957450683654337`*^9, 3.395745076336896*^9}, {3.3957495127060814`*^9, 
   3.395749540335811*^9}}],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox[
      RowBox[{"l", " ", "\[Pi]"}], "3"], 
     RowBox[{"l", "<", "1"}]},
    {
     RowBox[{
      FractionBox["2", "3"], " ", "l", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        FractionBox["1", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["l", "2"]}]]], "+", 
        RowBox[{"ArcCsc", "[", "l", "]"}], "-", 
        RowBox[{"ArcTan", "[", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["l", "2"]}]], "]"}]}], ")"}]}], 
     RowBox[{"1", "\[LessEqual]", "l", "\[LessEqual]", 
      SqrtBox["2"]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellChangeTimes->{
  3.395745099319944*^9, 3.395745291185834*^9, 3.395746630451603*^9, 
   3.3957469492700415`*^9, 3.3957469997225885`*^9, 3.3957487015897536`*^9, 
   3.395748754295541*^9, {3.395749533876523*^9, 3.3957495434603043`*^9}, 
   3.395749682930853*^9, 3.3957497380400963`*^9, 3.395986899871507*^9, 
   3.3959977851437597`*^9, 3.3959981202656417`*^9, 3.3959983181602*^9, 
   3.395998924201645*^9, 3.3960002109418864`*^9, 3.396007034423571*^9, 
   3.3960778486894846`*^9, 3.396249871658456*^9, 3.3979843234497232`*^9, 
   3.404734279777125*^9, 3.411737544475413*^9}]
}, Open  ]],

Cell[TextData[{
 "The probability density we have obtained exhibits a discontinuity at ",
 StyleBox["l",
  FontSlant->"Italic"],
 " = 1."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412320336721162*^9, 3.4123203790920877`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"pdfL", ",", " ", 
   RowBox[{"{", 
    RowBox[{"l", ",", " ", "0", ",", " ", 
     SqrtBox["2"]}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<l\>\"", ",", " ", "\"\<f(l)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.3957274029738483`*^9, 3.395727423813814*^9}, {
   3.3957274776612434`*^9, 3.3957274816870317`*^9}, {3.395727566178525*^9, 
   3.395727572898187*^9}, 3.3957290426716175`*^9, {3.395729283578024*^9, 
   3.3957293165554433`*^9}, {3.3957452422855186`*^9, 
   3.3957452428062673`*^9}, {3.3957495499896927`*^9, 3.395749554996893*^9}, 
   3.4117374985293455`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0H0w1HkAx3FEs1RL0XQz15MLU9dR6noSPtc6JLpwt1S3NtNS2XZbjghJ
uCnu8pCrkxsr6UKdh2KX1GGwGTJEhZZCnp/29/2uh/Rgc+6P97z/f5kel3j6
62hpaTkv9P8zLeLSBRq+/fK1VgWje3zti/j10zyxLVbP8WzaFXa4u1n741qx
G/ycSz2vKw7CIlU6Ny/igaXq6w5R+MDvyXgUFYmgxIe//RRiLOpJrRwRnQcn
QDeep4jCi9ND3QOiK5jVJIQfViRi7zYj0ifKgEe92y9eCimquopKVJkFiJ0M
1zzXLUJP9LUoHe1SzK9mV/YYlGHJZ0vJGXYFDqxzehEjrsR9yaV1gUdrsFRn
0tt6dy0e7D7w9NDEEzzOfjm9baYOTiVb/YqfNuDet8KZH3Uaob6tZ66X1oTe
HVO9v801IzzU+6f5lBYUTl6O2nSkFYrgisSK88/BrpXYruG9wF5p4sZnzi+R
KryVqrRtQ4V2W/sr/XaUN7h1rzfpgH5VwdyGyQ7E3GrtCjNWIiaPxtWUKyF2
zwpMo52oGVPEZud24UPY/rK6mdcwPGV0PeLKG2zyFk5dVHfj8vI6Vo57DyoX
n+6P8e/FYMLiiARpL/ZkLrNwPfEWq02PZQXEvoWjKVf2ntuHh34XY4URfcj2
Tfiy8Eg/lI4+Z4bF/XgWGaHJOzwAIztiwPYYQHKs0eZ4p0Hk97oIuM6DyHL8
w1qyfwj8v46InCyHwJl+FGezZxh/qs2iS9jDKLtw093VfATbZx4e3LdoBJFP
At8JzEcxyNZpOjc8guezQ8O+JmOYe2nMau0exbkhl2L/VeNI3/3W7U7rGOj9
gNmilRNwKxZwNsjG8emEVXy3jgp+rwqnqu9OwEvZozbRZZBqUsQ1SFbBYdfO
3C3TDBwZYXWzhIF2kEtHcg8BX0vfKzOYQWegOCyxnyB0Re6YOIxBceDVVb8P
E+Ts7DdeFs3geKDS+xIhYEX/fMI1iUGtJODV+XmCRkO3JfX5DBzKFBMyQwoP
a0tu9SgD3dIB1a0tFEKHxtEUFQO1/F1FljVFLDfggq+awRs5K+nmdori8Du5
8+8ZyOXfWEl3UZjUrPloxyLwl4ecuQGKDk/2zUcWBHUyXZJ0iMInhIyUCAji
S8xopISi+ai7GeckgaumKf5wEIX9vgfHWoQEbOcw0x3BFOvZwe0TQQTXOxs8
mVCKvtx3teYXCbK1JXLfCxSnujSZaRkE/x4qj3BMpFBW8zvNswii048bf5VM
cSCvaqXsNoFD/5L8zykUm8/GXGm5R9AQyn9Tdo2CYetF6JcTtEsXffd1BkUI
Zyk3so2Ajh/UM/yHYnCjOEVfSSDbMSsdz6fwMmxuTHtNEBadtbO+kGLX62SO
bMFds2LqZEwxRV4NjeIsuFfzMrT4Moov7nqUt4wR/JrjmG5TSvHxrPFWlZrA
wObG06nyBV9eyOnIGYKmuH2ClscUXZy2HP0PBFebxj7lV1AUzFh+/8McQZe8
lSWoovgPZ45W3Q==
      "]], LineBox[CompressedData["
1:eJwVznk41HkAx/Gxo3qWyHbYh2etmVBWZeVqHfmMQtKU0FOyUzka27HlNiu6
rc3m6tBDjrLZ8GAqd2kbJBJbkxAtFRUrjPn+ZvxcY9tff3ye9/P678MNDPEW
fsFisfjMPlemQnrSczna+r75XshS49nFP4xN7ZZjM+1+YqyExaMpvrnglRxp
/uEZ6RksXkVA11vTXjlcFsWpi+JZPHMMuza8keM4HePWL2DxjGe0dSYG5Wg6
+cLPRofF0w71y/ebkEMUey5anfUJ734kbSaLCVy6Q0a5cyr0OqeIhpcQWFRZ
5A29UaFj5arlpcsIOJPngkcaVGhU7BdZ6xGkFyd7FiWqcPN8N3cjhyDG8zL9
Xk+FA7WSaH9zgk+tim9zXWYh00/hZHkQZGvdW6r2YBqDrFWte/kEYk78vC8K
pvFmsDlq+TaCL13atpulTUNaptZa5EUweklbIQucxh2PqKgaXwKnzq/a7DWm
EXlM8KQzmKBEUDoVvW8KMz1mkTpnCXCnSF7OncQWL/jPxBMcfa3wstKaRPZj
H/77BIIbyw45tk/RcKqOM675naDtup75ESmNs5efduy7SLBIfEyodZrGQs9w
m1t5BG7zI1jFQxMwbLxLb60jyD94tmf9YyVCHZ4OrGsgcDXKNFlUrURD2cBT
biOB/nZeAv2nEvvzNAsmmgk+Fopz5scrUXhiz66cZwQ8tsN/Js5KWNqp1Yy+
JuCXHe+zlCjgInaPOT9HMLU/5yfrFgr1qQ9qdnwiaPD39AmspeAUZj1loEbB
93qVX24pBTtrjui2OoW4X6kNvIsUzO9NRnZqUrhv6m5nKqCg13Qz1FCfwgdH
eW8IRSDrUz9Qbkuh2dzKc6UpQaZW/c5/Qii83+osuBs8jtBT4pdPwijktTg2
tmwbh5siy/deBIXM2cRwme04qO5ov0wRBaNopwWRC8bhkb96766TFM4sKBg5
XCTDjH2G8EUKhcS5rLsy+RgEB0IiW5mflzbmv/NJHgXnocHF2hEK3le6lv4w
MYxDm3zbdwsV+MtW5L3p6AdIdo59bOtS4JrrXFNqVT/c7gcHSL2UCE9KiK03
60V3if3twkYl6qqT+W50J9b8PMqGzQQOV5rFGfKlqDh9plJ4awKxsa/+/U7r
EdyWRyCAS6N6KMVWo6ISmnruK8eyabSnmWxOrAiC5ZTJ6CzjC03FusXCIPi9
ZN/RyKFhR13Y8rduEArTJfamjLU2RY0sjgmE2+J124IYvx30Zd9YH4Azmiui
ehiX8x2MSpP3YHqO/fBRLo0wg1cWuuU+4PT1/9bB2IxtkxWxzAfu9yX8d4xP
hde9eC7yxpVjsV2sazQ2cHfdSnP0gvUkNezAeEfhQo5F0laEyvt1yhjvDpo/
dLVsIzKeSTrrGBdp5BwPEW2ARJxz9RnjX4bm3XZ1dIb2kd3GY4x7Vu+Qjp1f
j5Jh6TrT6zSE3ITNPWVW6HgsVtky/jq4f22241rMFiTVuzLmHcz/ozFpDTyC
3bcEMZ7t9z0kLzdCmOsKnfDPbm75YJhqgAxj9c5TjJ2X6LcfrlqCOvZAZipj
qwuVlom1bAwNSPbmMh6RSnTHCiOd/gdh+HBD
      "]]}, {}}, {{}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"l\"", TraditionalForm], 
    FormBox["\"f(l)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{0, 2^Rational[1, 2]}, {0., 2.1251929932293248`}}, {{
     0, 1.4142135623730951`}, {0., 2.1251929932293248`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.395745235625942*^9, 3.3957452914862657`*^9, 3.3957466311626253`*^9, 
   3.3957469495103874`*^9, 3.395746999972949*^9, 3.395748701980315*^9, 
   3.395748754555915*^9, {3.3957495509711037`*^9, 3.395749555527656*^9}, 
   3.3957496833314285`*^9, 3.3957497384807296`*^9, 3.3959869007427597`*^9, 
   3.395997786004998*^9, 3.3959981208364625`*^9, 3.3959983185006895`*^9, 
   3.3959989246723213`*^9, 3.396000211482664*^9, 3.3960070352046947`*^9, 
   3.396249872569766*^9, 3.3979843237601695`*^9, 3.404734280214625*^9, 
   3.411737545336651*^9}]
}, Open  ]],

Cell["\<\
Some Monte Carlo provides reassurance that the probability density we have \
obtained is correct:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412320384950512*^9, 3.412320402846245*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", "1000000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X1", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", " ", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Y1", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", " ", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L1", " ", "=", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["X1", "2"], "+", 
     SuperscriptBox["Y1", "2"]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X2", " ", "=", "  ", 
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", " ", 
       RowBox[{"n", "/", "2"}]}], "]"}], "-", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", " ", 
       RowBox[{"n", "/", "2"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L2", " ", "=", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["X2", "2"], "+", "1"}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"L", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"L1", ",", " ", "L2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<Histograms`\>\"", "]"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Histogram", "[", 
    RowBox[{"L", ",", " ", 
     RowBox[{"HistogramCategories", "\[Rule]", "50"}], ",", " ", 
     RowBox[{"HistogramScale", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{"pdfL", ",", " ", 
     RowBox[{"{", 
      RowBox[{"l", ",", " ", "0", ",", " ", 
       SqrtBox["2"]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Thickness", "[", ".005", "]"}]}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", " ", 
        RowBox[{"{", 
         RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}]}], "]"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<l\>\"", ",", " ", "\"\<f(l)\>\""}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.395470483343646*^9, 3.3954705997109747`*^9}, {
   3.395470637585435*^9, 3.3954707125231905`*^9}, 3.3954707973952303`*^9, 
   3.3954711387961407`*^9, {3.3954716175345325`*^9, 3.395471648088467*^9}, {
   3.395721685422413*^9, 3.3957217356346145`*^9}, {3.3957217717565556`*^9, 
   3.3957217719868865`*^9}, {3.395722135169117*^9, 3.395722290302187*^9}, {
   3.3957231583003073`*^9, 3.3957231584304943`*^9}, {3.3957235055796704`*^9, 
   3.395723505619728*^9}, {3.395723566687539*^9, 3.3957235763314066`*^9}, 
   3.3957328147355795`*^9, {3.395733620494203*^9, 3.39573374213912*^9}, {
   3.395745651093355*^9, 3.3957456605068913`*^9}, {3.39574956013428*^9, 
   3.3957495840586815`*^9}, 3.3957497051327777`*^9}],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0., 0}, {0.025, 0.012826666666666667`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.025000000000000005`, 0}, \
{0.05, 0.040159999999999994`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.049999999999999996`, 0}, \
{0.07500000000000001, 0.0658933333333333}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.07500000000000001, 0}, {0.1, 0.08997333333333335}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.1, 0}, {0.125, 0.11949333333333335`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.125, 0}, {0.15000000000000002`, 0.14663999999999988`}]}, \

    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.15000000000000002`, 0}, \
{0.17500000000000004`, 0.16709333333333337`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.175, 0}, {0.2, 0.19285333333333338`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.2, 0}, {0.22500000000000003`, 0.22565333333333337`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.22499999999999998`, 0}, {0.25, 0.2476266666666667}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.25, 0}, {0.275, 0.27167999999999976`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.275, 0}, {0.30000000000000004`, 0.29903999999999975`}]}, \

    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.30000000000000004`, 0}, \
{0.32499999999999996`, 0.3296800000000004}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.325, 0}, {0.35000000000000003`, 0.3478666666666664}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.3500000000000001, 0}, {0.375, 0.38162666666666717`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.375, 0}, {0.4, 0.402773333333333}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.4, 0}, {0.42500000000000004`, 0.4384266666666663}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.42500000000000004`, 0}, \
{0.44999999999999996`, 0.4558666666666673}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.45, 0}, {0.47500000000000003`, 0.4769599999999996}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.4750000000000001, 0}, {0.5, 0.518293333333334}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.49999999999999994`, 0}, \
{0.5249999999999999, 0.5328266666666662}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.5250000000000001, 0}, {0.55, 0.5589866666666662}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.55, 0}, {0.575, 0.5950933333333328}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.5750000000000002, 0}, \
{0.6000000000000001, 0.6170666666666661}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.6000000000000001, 0}, {0.625, 0.642026666666669}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.625, 0}, {0.6499999999999999, 0.6649866666666661}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.6500000000000001, 0}, {0.675, 0.6984533333333327}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.675, 0}, {0.7, 0.715626666666666}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.7000000000000002, 0}, \
{0.7250000000000001, 0.7340799999999994}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.7250000000000001, 0}, {0.75, 0.7801866666666695}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.75, 0}, {0.7749999999999999, 0.8040533333333326}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.7750000000000001, 0}, {0.8, 0.828106666666666}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.8, 0}, {0.825, 0.8559733333333326}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.8250000000000002, 0}, \
{0.8500000000000001, 0.8815199999999992}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.8500000000000001, 0}, {0.875, 0.8941600000000032}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.875, 0}, {0.8999999999999999, 0.9293066666666658}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.9000000000000001, 0}, {0.925, 0.9548266666666657}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.925, 0}, {0.95, 0.9966399999999992}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.9500000000000002, 0}, \
{0.9750000000000001, 1.0129866666666658`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.9750000000000001, 0}, {1., 1.028213333333337}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1., 0}, {1.0250000000000004`, 6.200586666666633}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.0250000000000001`, 0}, {1.05, 2.560080000000009}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.05, 0}, {1.075, 1.9037066666666733`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.0749999999999997`, 0}, {1.1, 1.5168533333333254`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.1, 0}, {1.125, 1.2746400000000044`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.125, 0}, {1.1500000000000004`, 1.0763999999999943`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.1500000000000001`, 0}, {1.175, 0.9194933333333365}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.1749999999999998`, 0}, \
{1.2000000000000002`, 0.7857066666666624}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.2000000000000002`, 0}, {1.225, 0.6701333333333357}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.225, 0}, {1.25, 0.5582933333333353}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.25, 0}, {1.2750000000000004`, 0.4640266666666642}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.2750000000000001`, 0}, {1.3, 0.37744000000000133`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.2999999999999998`, 0}, \
{1.3250000000000002`, 0.2945866666666651}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.3250000000000002`, 0}, {1.35, 0.2157066666666674}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.35, 0}, {1.375, 0.14642666666666718`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.375, 0}, {1.4000000000000004`, 0.06981333333333296}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{1.4000000000000001`, 0}, \
{1.425, 0.010560000000000038`}]}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJwV0H0w1HkAx3FEs1RL0XQz15MLU9dR6noSPtc6JLpwt1S3NtNS2XZbjghJ
uCnu8pCrkxsr6UKdh2KX1GGwGTJEhZZCnp/29/2uh/Rgc+6P97z/f5kel3j6
62hpaTkv9P8zLeLSBRq+/fK1VgWje3zti/j10zyxLVbP8WzaFXa4u1n741qx
G/ycSz2vKw7CIlU6Ny/igaXq6w5R+MDvyXgUFYmgxIe//RRiLOpJrRwRnQcn
QDeep4jCi9ND3QOiK5jVJIQfViRi7zYj0ifKgEe92y9eCimquopKVJkFiJ0M
1zzXLUJP9LUoHe1SzK9mV/YYlGHJZ0vJGXYFDqxzehEjrsR9yaV1gUdrsFRn
0tt6dy0e7D7w9NDEEzzOfjm9baYOTiVb/YqfNuDet8KZH3Uaob6tZ66X1oTe
HVO9v801IzzU+6f5lBYUTl6O2nSkFYrgisSK88/BrpXYruG9wF5p4sZnzi+R
KryVqrRtQ4V2W/sr/XaUN7h1rzfpgH5VwdyGyQ7E3GrtCjNWIiaPxtWUKyF2
zwpMo52oGVPEZud24UPY/rK6mdcwPGV0PeLKG2zyFk5dVHfj8vI6Vo57DyoX
n+6P8e/FYMLiiARpL/ZkLrNwPfEWq02PZQXEvoWjKVf2ntuHh34XY4URfcj2
Tfiy8Eg/lI4+Z4bF/XgWGaHJOzwAIztiwPYYQHKs0eZ4p0Hk97oIuM6DyHL8
w1qyfwj8v46InCyHwJl+FGezZxh/qs2iS9jDKLtw093VfATbZx4e3LdoBJFP
At8JzEcxyNZpOjc8guezQ8O+JmOYe2nMau0exbkhl2L/VeNI3/3W7U7rGOj9
gNmilRNwKxZwNsjG8emEVXy3jgp+rwqnqu9OwEvZozbRZZBqUsQ1SFbBYdfO
3C3TDBwZYXWzhIF2kEtHcg8BX0vfKzOYQWegOCyxnyB0Re6YOIxBceDVVb8P
E+Ts7DdeFs3geKDS+xIhYEX/fMI1iUGtJODV+XmCRkO3JfX5DBzKFBMyQwoP
a0tu9SgD3dIB1a0tFEKHxtEUFQO1/F1FljVFLDfggq+awRs5K+nmdori8Du5
8+8ZyOXfWEl3UZjUrPloxyLwl4ecuQGKDk/2zUcWBHUyXZJ0iMInhIyUCAji
S8xopISi+ai7GeckgaumKf5wEIX9vgfHWoQEbOcw0x3BFOvZwe0TQQTXOxs8
mVCKvtx3teYXCbK1JXLfCxSnujSZaRkE/x4qj3BMpFBW8zvNswii048bf5VM
cSCvaqXsNoFD/5L8zykUm8/GXGm5R9AQyn9Tdo2CYetF6JcTtEsXffd1BkUI
Zyk3so2Ajh/UM/yHYnCjOEVfSSDbMSsdz6fwMmxuTHtNEBadtbO+kGLX62SO
bMFds2LqZEwxRV4NjeIsuFfzMrT4Moov7nqUt4wR/JrjmG5TSvHxrPFWlZrA
wObG06nyBV9eyOnIGYKmuH2ClscUXZy2HP0PBFebxj7lV1AUzFh+/8McQZe8
lSWoovgPZ45W3Q==
       "]], LineBox[CompressedData["
1:eJwd0nk41GsbB/DRDI41eyeVXUlMyVLZ7qeyVRNnqCzvVIrRHtmmolK8lYiI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       "]]}, {}}, {{}, {}, {}}}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"l\"", TraditionalForm], 
    FormBox["\"f(l)\"", TraditionalForm]},
  AxesOrigin->{0., 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0., 1.425}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{0., 
      FormBox["0", TraditionalForm]}, {0.25, 
      FormBox["0.25`", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {0.75, 
      FormBox["0.75`", TraditionalForm]}, {1., 
      FormBox["1", TraditionalForm]}, {1.25, 
      FormBox["1.25`", TraditionalForm]}}, Automatic},
  TicksStyle->{}]], "Output",
 CellChangeTimes->{
  3.3957456947661533`*^9, 3.395746634938054*^9, 3.3957469527450385`*^9, 
   3.3957470032376432`*^9, 3.395748705605528*^9, 3.3957487577705374`*^9, 
   3.395749588364874*^9, {3.3957496868064256`*^9, 3.395749710480467*^9}, 
   3.3957497420057983`*^9, 3.3959869118487296`*^9, 3.3959977899606867`*^9, 
   3.3959981244716897`*^9, 3.395998321865528*^9, 3.395998928437736*^9, 
   3.396000215838928*^9, 3.3960070405924416`*^9, 3.39624988527804*^9, 
   3.397984343248192*^9, 3.404734283074*^9, 3.41173754886172*^9}]
}, Open  ]],

Cell["\<\
We may now compute the expected length of a random line in the unit square:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123204118692193`*^9, 3.412320435703491*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lbar", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"l", " ", "pdfL"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"l", ",", " ", "0", ",", "1"}], "}"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"0", "\[LessEqual]", " ", "l", "\[LessEqual]", "1"}]}]}], 
     "]"}], " ", "+", " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"l", " ", "pdfL"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"l", ",", " ", "1", ",", 
        SqrtBox["2"]}], "}"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"1", "\[LessEqual]", "l", "\[LessEqual]", " ", 
        SqrtBox["2"]}]}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.3953985032213135`*^9, 3.395398517001128*^9}, 
   3.3953995744817104`*^9, {3.3953999569917326`*^9, 3.3953999572621217`*^9}, {
   3.39540132759256*^9, 3.395401390312747*^9}, {3.395401453253251*^9, 
   3.395401465570963*^9}, 3.395401515913352*^9, {3.3954024845161343`*^9, 
   3.395402503513451*^9}, {3.395402537852829*^9, 3.395402556289339*^9}, {
   3.395402885062091*^9, 3.395402891821811*^9}, {3.3954037841549234`*^9, 
   3.3954037924768896`*^9}, {3.3954679596247168`*^9, 3.395467972102659*^9}, 
   3.3954680445568433`*^9, {3.395468940915744*^9, 3.3954689743337965`*^9}, {
   3.395469615275426*^9, 3.395469616106621*^9}, {3.395469678456275*^9, 
   3.395469690814045*^9}, 3.39546972619492*^9, {3.395469766032203*^9, 
   3.395469797126915*^9}, {3.3954699845564256`*^9, 3.3954699948612432`*^9}, {
   3.395729072063882*^9, 3.3957290813171873`*^9}, {3.3957291273033123`*^9, 
   3.3957291673308687`*^9}, {3.395729221759133*^9, 3.3957292218392477`*^9}, {
   3.3957332998531437`*^9, 3.3957333367161503`*^9}, 3.3957458942029295`*^9, 
   3.3957465881307487`*^9, {3.3957495905179696`*^9, 3.395749636293792*^9}, {
   3.395996076717163*^9, 3.395996084247992*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "18"], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    RowBox[{"2", " ", 
     SqrtBox["2"]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"ArcSinh", "[", "1", "]"}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.3957459123189793`*^9, 3.395746589843211*^9, 3.395746640956709*^9, 
   3.3957469585333614`*^9, 3.395747009066024*^9, 3.3957487111935635`*^9, 
   3.3957487635388317`*^9, {3.395749618388045*^9, 3.3957496382065425`*^9}, 
   3.3957496925246477`*^9, 3.3957497475637903`*^9, 3.3959869215626974`*^9, {
   3.3959960736828003`*^9, 3.395996093851802*^9}, 3.3959977959993696`*^9, 
   3.3959981305003586`*^9, 3.395998327864154*^9, 3.3959989344764194`*^9, 
   3.396000221446992*^9, 3.396007048543875*^9, 3.396249895022051*^9, 
   3.397984350718934*^9, 3.4047342883865*^9, 3.411737554509842*^9}]
}, Open  ]],

Cell["\<\
To obtain a simpler form, we apply several stages of simplification with \
inspection of the outputs required to inform substitutions:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123204453073006`*^9, 3.412320512503925*^9}, 
   3.4123246175166435`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "lbar", "]"}]], "Input",
 CellChangeTimes->{{3.395997751245016*^9, 3.3959977567028637`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "18"], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    RowBox[{"2", " ", 
     SqrtBox["2"]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"ArcSinh", "[", "1", "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"99", "+", 
      RowBox[{"70", " ", 
       SqrtBox["2"]}]}], "]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.3959977965000896`*^9, 3.395998131041136*^9, 
  3.3959983283949165`*^9, 3.3959989349871535`*^9, 3.3960002219877696`*^9, 
  3.396007049064624*^9, 3.396249895442656*^9, 3.397984351109496*^9, 
  3.404734288777125*^9, 3.411737554860346*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", "lbar", "]"}]], "Input",
 CellChangeTimes->{{3.3959960996301107`*^9, 3.39599610522816*^9}, {
  3.3959961591156464`*^9, 3.3959961734162097`*^9}, {3.395996232140651*^9, 
  3.395996233712912*^9}, {3.3959982838408513`*^9, 3.3959982856234145`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "9"], "+", 
  FractionBox[
   SqrtBox["2"], "9"], "+", 
  RowBox[{
   FractionBox["2", "9"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SqrtBox["2"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"3", "+", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.3959961059291677`*^9, 3.3959961743074913`*^9, 
  3.395996234293747*^9, 3.3959977967504497`*^9, 3.395998131271467*^9, 
  3.39599828986952*^9, 3.3959983284449887`*^9, 3.3959989350472403`*^9, 
  3.3960002220478563`*^9, 3.3960070491547537`*^9, 3.3962498955027423`*^9, 
  3.3979843511195107`*^9, 3.404734288824*^9, 3.41173755487036*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lbar", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       FractionBox["2", "9"], "+", 
       FractionBox[
        SqrtBox["2"], "9"], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", "z", "]"}]}], "9"], "+", 
       FractionBox[
        RowBox[{"Log", "[", 
         SuperscriptBox["z", "2"], "]"}], "6"]}], ",", " ", 
      RowBox[{"z", ">", "0"}]}], "]"}], "/.", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}], ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.395996282372882*^9, 3.3959963080798464`*^9}, {
  3.395997553490659*^9, 3.395997669327224*^9}, {3.3959977049885025`*^9, 
  3.3959977061702013`*^9}, {3.3959988709150224`*^9, 3.3959988757219343`*^9}}],\


Cell[BoxData[
 RowBox[{
  FractionBox["1", "9"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    SqrtBox["2"], "+", 
    RowBox[{"5", " ", 
     RowBox[{"ArcSinh", "[", "1", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.395997644761901*^9, 3.395997669757843*^9}, 
   3.3959977083733697`*^9, 3.3959977968505936`*^9, 3.3959981313816257`*^9, 
   3.3959983285451326`*^9, 3.395998881289941*^9, 3.395998935157398*^9, 
   3.396000222148*^9, 3.396007049274926*^9, 3.3962498955928717`*^9, 
   3.397984351179597*^9, 3.40473428891775*^9, 3.4117375549404607`*^9}]
}, Open  ]],

Cell["\<\
For completeness, we compute the variance of the length of lines occurring in \
the unit square and compare our analytic expressions with those obtained from \
out Monte Carlo analysis:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123204921045923`*^9, 3.412320492485139*^9}, {
   3.4123205303495855`*^9, 3.412320581663371*^9}, 3.4123246194794655`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lvar", " ", "=", " ", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["l", "2"], " ", "pdfL"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"l", ",", " ", "0", ",", "1"}], "}"}], ",", " ", 
       RowBox[{"Assumptions", "\[Rule]", 
        RowBox[{"0", "\[LessEqual]", " ", "l", "\[LessEqual]", "1"}]}]}], 
      "]"}], " ", "+", " ", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["l", "2"], " ", "pdfL"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"l", ",", " ", "1", ",", 
         SqrtBox["2"]}], "}"}], ",", " ", 
       RowBox[{"Assumptions", "\[Rule]", 
        RowBox[{"1", "\[LessEqual]", "l", "\[LessEqual]", " ", 
         SqrtBox["2"]}]}]}], "]"}]}], "]"}], "-", 
   SuperscriptBox["lbar", "2"]}]}]], "Input",
 CellChangeTimes->{{3.3959992686869907`*^9, 3.3959992724724336`*^9}, {
  3.3959993085743456`*^9, 3.3959993255487537`*^9}, {3.3959993988541613`*^9, 
  3.3959994034207277`*^9}, {3.3959997514812145`*^9, 3.395999775706048*^9}, {
  3.395999826659315*^9, 3.3959998269897904`*^9}, {3.3959998774723806`*^9, 
  3.395999882008904*^9}, {3.396000125128493*^9, 3.396000151506422*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "6"], "-", 
  RowBox[{
   FractionBox["1", "81"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SqrtBox["2"], "+", 
      RowBox[{"5", " ", 
       RowBox[{"ArcSinh", "[", "1", "]"}]}]}], ")"}], "2"]}]}]], "Output",
 CellChangeTimes->{{3.3959997539848146`*^9, 3.3959997782697344`*^9}, 
   3.395999828982656*^9, 3.3959998835511217`*^9, {3.396000130956874*^9, 
   3.3960001529084387`*^9}, 3.3960002240106783`*^9, 3.396007051157634*^9, 
   3.3962498973353777`*^9, 3.3979843530222464`*^9, 3.404734290808375*^9, 
   3.411737556692981*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"N", "[", "lbar", "]"}], ",", 
      RowBox[{"Mean", "[", "L", "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"N", "[", "lvar", "]"}], ",", 
      RowBox[{"Variance", "[", "L", "]"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.395745914462061*^9, 3.3957459254678864`*^9}, {
   3.395748368801227*^9, 3.3957483818199472`*^9}, 3.395748678756922*^9, {
   3.3957487283482304`*^9, 3.3957487290191956`*^9}, {3.3957496190790386`*^9, 
   3.395749648691619*^9}, {3.395999786301283*^9, 3.3959998115075283`*^9}, {
   3.396000161210376*^9, 3.3960001617811966`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.8690090552745344`", ",", "0.8689620096508116`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0781565951841946`", ",", "0.07802334094368528`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.3957466411870403`*^9, 3.3957469587036066`*^9, 3.3957470092462835`*^9, 
   3.3957483784751377`*^9, {3.395748711343779*^9, 3.395748729900462*^9}, 
   3.395748763689048*^9, {3.395749629904605*^9, 3.395749649302498*^9}, 
   3.395749692674864*^9, 3.3957497477140064`*^9, 3.395986921662842*^9, 
   3.395997796950738*^9, 3.395998131431698*^9, 3.395998328605219*^9, 
   3.3959989352174845`*^9, {3.3960001555722685`*^9, 3.396000162612392*^9}, 
   3.396000224361182*^9, 3.39600705162831*^9, 3.3962498992781715`*^9, 
   3.397984353312664*^9, 3.4047342910115*^9, 3.4117375568932686`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Calculation", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.396077786910651*^9, 3.396077793760501*^9}}],

Cell[TextData[{
 "As an example, we compute the expected line length per unit area for a \
glass fibre network with mean areal density ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["\[Beta]", "_"], " ", "=", " ", 
    RowBox[{"10", " ", 
     StyleBox["g",
      FontSlant->"Plain"], " ", 
     SuperscriptBox[
      StyleBox["m",
       FontSlant->"Plain"], 
      RowBox[{"-", "2"}]], "  "}]}], TraditionalForm]]],
 "formed from E-glass fibres with circular cross-section and diameter 10 ",
 StyleBox["\[Mu]",
  FontSlant->"Italic"],
 "m. E-glass has density 2550 kg ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["m",
     FontSlant->"Plain"], 
    RowBox[{"-", "3"}]], TraditionalForm]]],
 ", so we compute the linear density of the fibres suing these values and \
allow ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to take care of the units, by specifying these having called the package, \
",
 StyleBox["Units", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412320640117424*^9, 3.4123208242421827`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<Units`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", " ", "=", " ", 
   RowBox[{"10", " ", 
    RowBox[{"Gram", "/", 
     SuperscriptBox["Meter", "2"]}]}]}], ";", 
  RowBox[{"\[Omega]", " ", "=", " ", 
   RowBox[{"10", " ", "Micro", " ", "Meter"}]}], ";", 
  RowBox[{"\[Rho]", " ", "=", " ", 
   RowBox[{"2550", " ", 
    RowBox[{"Kilogram", "/", 
     SuperscriptBox["Meter", "3"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[Delta]", " ", "=", " ", 
  RowBox[{"SI", "[", 
   RowBox[{"\[Pi]", " ", 
    SuperscriptBox["\[Omega]", "2"], 
    RowBox[{"\[Rho]", "/", "4."}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.3960754800835967`*^9, 3.396075487003547*^9}, {
   3.396075818550288*^9, 3.396075946273946*^9}, {3.396075988895232*^9, 
   3.39607599034732*^9}, 3.396076273774869*^9, {3.396077711632406*^9, 
   3.3960777641278915`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2.0027653166634929`*^-7", " ", "Kilogram"}], "Meter"]], "Output",
 CellChangeTimes->{3.396077865683922*^9, 3.396082805346808*^9, 
  3.397984360352787*^9, 3.40473433579275*^9, 3.411205790486771*^9, 
  3.4117375634226575`*^9}]
}, Open  ]],

Cell["The process intensity is therefore:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412320885550339*^9, 3.412320895164163*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Tau]", " ", "=", " ", 
  RowBox[{"SI", "[", 
   RowBox[{"\[Beta]", "/", "\[Delta]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.3960754800835967`*^9, 3.396075487003547*^9}, {
   3.396075818550288*^9, 3.396075946273946*^9}, {3.396075988895232*^9, 
   3.39607599034732*^9}, 3.396076273774869*^9, {3.396077711632406*^9, 
   3.3960777641278915`*^9}}],

Cell[BoxData[
 FractionBox["49930.96253863384`", "Meter"]], "Output",
 CellChangeTimes->{{3.396075879658157*^9, 3.3960759065868783`*^9}, {
   3.396075940145133*^9, 3.396075947095126*^9}, 3.396075991448904*^9, 
   3.3960762744658623`*^9, {3.396077712333414*^9, 3.396077733453784*^9}, {
   3.3960782240091677`*^9, 3.3960782496260033`*^9}, 3.396078500356536*^9, 
   3.3960828055370817`*^9, 3.397984360422888*^9, 3.404734335902125*^9, 
   3.411205790657016*^9, 3.411737563462715*^9}]
}, Open  ]],

Cell["and the expected number of crossings per unit area is:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412320900191392*^9, 3.4123209192087374`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ncross", " ", "=", " ", 
  RowBox[{
   SuperscriptBox["\[Tau]", "2"], "/", "\[Pi]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Convert", "[", 
  RowBox[{"ncross", ",", 
   SuperscriptBox[
    RowBox[{"(", "Centimeter", ")"}], 
    RowBox[{"-", "2"}]]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.3960827741819954`*^9, {3.4112057774179792`*^9, 3.4112057812034225`*^9}}],

Cell[BoxData[
 FractionBox["7.935787019318601`*^8", 
  SuperscriptBox["Meter", "2"]]], "Output",
 CellChangeTimes->{
  3.3960791601152225`*^9, {3.3960827758143425`*^9, 3.396082805597168*^9}, 
   3.3979843604329023`*^9, 3.404734335949*^9, 3.411205790807232*^9, 
   3.411737563482744*^9}],

Cell[BoxData[
 FractionBox["79357.87019318601`", 
  SuperscriptBox["Centimeter", "2"]]], "Output",
 CellChangeTimes->{
  3.3960791601152225`*^9, {3.3960827758143425`*^9, 3.396082805597168*^9}, 
   3.3979843604329023`*^9, 3.404734335949*^9, 3.411205790807232*^9, 
   3.4117375634927588`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScientificForm", "[", 
  RowBox[{"%", ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.3960829001731615`*^9, 3.3960829051903763`*^9}}],

Cell[BoxData[
 TagBox[
  FractionBox[
   InterpretationBox[
    RowBox[{"\<\"7.94\"\>", "\[Times]", 
     SuperscriptBox["10", "\<\"4\"\>"]}],
    79357.87019318601,
    AutoDelete->True], 
   SuperscriptBox["Centimeter", 
    InterpretationBox["\<\"2\"\>",
     2,
     Editable->False]]],
  ScientificForm[#, 3]& ]], "Output",
 CellChangeTimes->{3.3960829057912397`*^9, 3.3979843604529314`*^9, 
  3.4047343360115*^9, 3.4112057909975057`*^9, 3.411737563512787*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.2 Inter-crossing distances", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.396082164495309*^9, 3.3960821714953747`*^9}, {
  3.4123209508542414`*^9, 3.4123209534179277`*^9}}],

Cell[TextData[{
 "We assume that crossings occur as a point Poisson process on a line with \
the expected number of crossings in an interval of length ",
 StyleBox["g",
  FontSlant->"Italic"],
 " being \[Mu] ",
 StyleBox["g",
  FontSlant->"Italic"],
 ". We seek the probability density of the intervals ",
 StyleBox["g",
  FontSlant->"Italic"],
 " containing zero crossings. \n\nThe Poisson probability that there are no \
crossings in an interval of length ",
 StyleBox["g",
  FontSlant->"Italic"],
 " is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123211847105103`*^9, 3.4123213209564223`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pzero", "=", " ", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", 
     RowBox[{"\[Mu]", " ", "g"}], "]"}], ",", " ", "0"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.396087412321312*^9, 3.396087494940112*^9}, 
   3.3960931297525744`*^9, {3.404734582199*^9, 3.4047345828865*^9}}],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"-", "g"}], " ", "\[Mu]"}]]], "Output",
 CellChangeTimes->{
  3.396088557357794*^9, {3.3960931408084717`*^9, 3.3960931647529025`*^9}, 
   3.3979843605530753`*^9, 3.404734585652125*^9, 3.40473473435525*^9}]
}, Open  ]],

Cell[TextData[{
 "The probability density of ",
 StyleBox["g",
  FontSlant->"Italic"],
 " must integrate to unity over the domain 0 \[LessEqual] g \[LessEqual] \
\[Infinity] is therefore:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123213436089954`*^9, 3.41232140086132*^9}, 
   3.4123246319473934`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfg", " ", "=", " ", 
  RowBox[{"Pzero", "/", 
   RowBox[{"Integrate", "[", 
    RowBox[{"Pzero", ",", " ", 
     RowBox[{"{", 
      RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
     
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"\[Mu]", ">", "0"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.396093134599544*^9, 3.3960931468972273`*^9}, {
  3.404734608777125*^9, 3.404734609027125*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "g"}], " ", "\[Mu]"}]], " ", "\[Mu]"}]], "Output",
 CellChangeTimes->{
  3.396088944484454*^9, {3.396093141859984*^9, 3.3960931649431763`*^9}, 
   3.3979843606832623`*^9, {3.4047346012615*^9, 3.40473460979275*^9}, 
   3.404734734808375*^9}]
}, Open  ]],

Cell[TextData[{
 "The mean ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["g", "_"], " ", 
    RowBox[{"is", ":"}]}], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412321419568219*^9, 3.412321431004664*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"g", " ", "pdfg"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Mu]", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.404734621370875*^9, 3.404734673558375*^9}}],

Cell[BoxData[
 FractionBox["1", "\[Mu]"]], "Output",
 CellChangeTimes->{{3.404734642214625*^9, 3.40473467466775*^9}, {
  3.404734708589625*^9, 3.404734735058375*^9}}]
}, Open  ]],

Cell[TextData[{
 "Substituting for \[Mu] yields the probability density of ",
 StyleBox["g ",
  FontSlant->"Italic"],
 "in terms of the mean only:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412321440948963*^9, 3.4123214723541217`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfg", "/.", 
  RowBox[{"\[Mu]", "\[Rule]", 
   RowBox[{"(", 
    RowBox[{"1", "/", "gbar"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.404734675933375*^9, 3.404734695902125*^9}}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox["g", "gbar"]}]], "gbar"]], "Output",
 CellChangeTimes->{{3.404734696824*^9, 3.40473473510525*^9}}]
}, Open  ]],

Cell[TextData[{
 "We observe that the probability density we have obtained is that of the \
exponential distribution with mean ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["g", "_"], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412321476490069*^9, 3.412321503108344*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", 
    RowBox[{"1", "/", "gbar"}], "]"}], ",", "g"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Mean", "[", 
  RowBox[{"ExponentialDistribution", "[", 
   RowBox[{"1", "/", "gbar"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"ExponentialDistribution", "[", 
   RowBox[{"1", "/", "gbar"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.3960875724715967`*^9, 3.396087584068272*^9}, {
  3.396089002828349*^9, 3.3960890127626333`*^9}}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox["g", "gbar"]}]], "gbar"]], "Output",
 CellChangeTimes->{
  3.3960875848594093`*^9, 3.3960890137140017`*^9, 3.396089168075963*^9, {
   3.396093158523946*^9, 3.3960931650032625`*^9}, 3.39798436072332*^9, 
   3.404734735183375*^9}],

Cell[BoxData["gbar"], "Output",
 CellChangeTimes->{
  3.3960875848594093`*^9, 3.3960890137140017`*^9, 3.396089168075963*^9, {
   3.396093158523946*^9, 3.3960931650032625`*^9}, 3.39798436072332*^9, 
   3.404734735199*^9}],

Cell[BoxData[
 SuperscriptBox["gbar", "2"]], "Output",
 CellChangeTimes->{
  3.3960875848594093`*^9, 3.3960890137140017`*^9, 3.396089168075963*^9, {
   3.396093158523946*^9, 3.3960931650032625`*^9}, 3.39798436072332*^9, 
   3.40473473523025*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.3 Statistics of Polygons", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.3962501061756754`*^9, 3.396250109320197*^9}, {
  3.4123215183502607`*^9, 3.412321529296*^9}}],

Cell[CellGroupData[{

Cell["Polygon Side Distribution", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.3973689875869455`*^9, 3.397368991632763*^9}, {
  3.4123216175629215`*^9, 3.4123216210879903`*^9}}],

Cell["\<\
The probability distribution function for the number of sides per polygon is \
not known analytically, but a Poisson approximation suggested by Crain and \
Miles:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412321747830237*^9, 3.4123217941868944`*^9}, {
   3.412323150116626*^9, 3.4123231564156833`*^9}, 3.412324634340835*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "[", "n", "]"}], ":=", " ", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", "1", "]"}], ",", " ", 
    RowBox[{"n", "-", "3"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"P", "[", "n", "]"}]}], "Input",
 CellChangeTimes->{{3.396262850801547*^9, 3.39626286034527*^9}, {
   3.3962629000523663`*^9, 3.3962629001525106`*^9}, {3.396263194245395*^9, 
   3.3962632477523346`*^9}, {3.396263936883256*^9, 3.396263992693507*^9}, 
   3.3962640869590545`*^9}],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"\[ExponentialE]", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "n"}], ")"}], "!"}]}]]], "Output",
 CellChangeTimes->{3.396264096142259*^9, 3.3962642336399713`*^9, 
  3.3973684346418495`*^9, 3.3979843987680254`*^9, 3.4123215906041565`*^9}]
}, Open  ]],

Cell[TextData[{
 "The variance of the number of sides per polygon is known analytically from \
Miles and is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Pi]", "2"], "-", "8"}], ")"}], "/", "2"}], 
   TraditionalForm]]],
 "; the approximate probability function has variance 1, which is close:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123231983559904`*^9, 3.412323289637246*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"n", "-", "4"}], ")"}], "2"], 
    RowBox[{"P", "[", "n", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "3", ",", " ", "\[Infinity]"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], "-", "8"}], ")"}], "/", "2"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.396262850801547*^9, 3.39626286034527*^9}, {
   3.3962629000523663`*^9, 3.3962629001525106`*^9}, {3.396263194245395*^9, 
   3.3962632477523346`*^9}, {3.396263936883256*^9, 3.396263992693507*^9}, 
   3.3962640869590545`*^9, {3.396264149969659*^9, 3.3962642055796223`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.396263214394368*^9, 3.396263225890899*^9}, {
   3.3962639591853247`*^9, 3.39626399481656*^9}, 3.396264182606589*^9, 
   3.3962642378560333`*^9, 3.397368446468856*^9, 3.3979844019025326`*^9, 
   3.412323302665981*^9}],

Cell[BoxData["0.934802200544679`"], "Output",
 CellChangeTimes->{{3.396263214394368*^9, 3.396263225890899*^9}, {
   3.3962639591853247`*^9, 3.39626399481656*^9}, 3.396264182606589*^9, 
   3.3962642378560333`*^9, 3.397368446468856*^9, 3.3979844019025326`*^9, 
   3.412323302696024*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Area and Perimeter", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.3973690026085453`*^9, 3.3973690063939886`*^9}}],

Cell["\<\
For n-sided polygons, the perimeter has a chi-square distribution with 2(n-2) \
degrees of freedom. The chi-square distribution is a special case of the \
gamma distribution:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123233250882225`*^9, 3.4123234085181885`*^9}, 
   3.412323462055171*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ChiSquareDistribution", "[", "\[Nu]", "]"}], ",", "p"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"TrueQ", "[", 
  RowBox[{
   RowBox[{"ChiSquareDistribution", "[", "\[Nu]", "]"}], " ", "\[Equal]", " ",
    
   RowBox[{"GammaDistribution", "[", 
    RowBox[{
     RowBox[{"\[Nu]", "/", "2"}], ",", " ", "2"}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.3962676216316643`*^9, 3.396267626979354*^9}, {
  3.3962679282024913`*^9, 3.396267958686325*^9}, {3.397368635120123*^9, 
  3.397368702046358*^9}, {3.397368744146896*^9, 3.3973687672000446`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     RowBox[{"-", "\[Nu]"}], "/", "2"}]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "p"}], "/", "2"}]], " ", 
   SuperscriptBox["p", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["\[Nu]", "2"]}]]}], 
  RowBox[{"Gamma", "[", 
   FractionBox["\[Nu]", "2"], "]"}]]], "Output",
 CellChangeTimes->{3.39736890807261*^9, 3.3973690270837393`*^9, 
  3.3973841110534225`*^9, 3.39798440203272*^9, 3.4123236502858334`*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.39736890807261*^9, 3.3973690270837393`*^9, 
  3.3973841110534225`*^9, 3.39798440203272*^9, 3.4123236503659487`*^9}]
}, Open  ]],

Cell["\<\
We can obtain an approximate probability density for the perimeter \
distribution by applying the approximation of Crain and Miles:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412323448856192*^9, 3.412323492318688*^9}, 
   3.41232463792599*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", "n", "]"}], ":=", " ", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", "1", "]"}], ",", " ", 
    RowBox[{"n", "-", "3"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.396262850801547*^9, 3.39626286034527*^9}, {
   3.3962629000523663`*^9, 3.3962629001525106`*^9}, {3.396263194245395*^9, 
   3.3962632477523346`*^9}, {3.396263936883256*^9, 3.396263992693507*^9}, 
   3.3962640869590545`*^9, {3.3973835164784656`*^9, 3.397383516768883*^9}}],

Cell["\<\
We input the chi-square distribution with 2(n-2) degrees of freedom:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123235008709855`*^9, 3.4123235292517953`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Nu]", " ", "=", " ", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"n", "-", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "[", 
   RowBox[{"p_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"ChiSquareDistribution", "[", "\[Nu]", "]"}], ",", "p"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.3973836378229504`*^9, 3.3973836613968477`*^9}}],

Cell[TextData[{
 "and derive the approximate pdf for polygon perimeters as\n\n",
 StyleBox["q",
  FontSlant->"Italic"],
 "(",
 StyleBox["p",
  FontSlant->"Italic"],
 ") = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "3"}], "\[Infinity]"], 
    RowBox[{
     RowBox[{"p", "(", "n", ")"}], " ", 
     RowBox[{"q", "(", 
      RowBox[{"p", ",", "n"}], ")"}]}]}], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123235342489805`*^9, 3.412323628494499*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pdfp", " ", "=", " ", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"P", "[", "n", "]"}], 
     RowBox[{"q", "[", 
      RowBox[{"p", ",", "n"}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"n", ",", " ", "3", ",", " ", "\[Infinity]"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"pdfp", ",", " ", 
   RowBox[{"{", 
    RowBox[{"p", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.3973829059605837`*^9, 3.3973829132410526`*^9}, {
   3.397382951956723*^9, 3.397382958736472*^9}, 3.3973836347485294`*^9, {
   3.397383668346842*^9, 3.397383671140859*^9}, {3.397383920439333*^9, 
   3.397383952194995*^9}, {3.397383983890571*^9, 3.3973839845214787`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    FractionBox["p", "2"]}]], " ", 
  RowBox[{"BesselI", "[", 
   RowBox[{"0", ",", 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox["p"]}]}], "]"}]}]], "Output",
 CellChangeTimes->{{3.397383935741336*^9, 3.397383952966104*^9}, 
   3.397384119135043*^9, 3.39798441163653*^9, 3.412323655413206*^9}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.397383935741336*^9, 3.397383952966104*^9}, 
   3.397384119135043*^9, 3.39798441163653*^9, 3.4123236595892115`*^9}]
}, Open  ]],

Cell["\<\
We obtain the mean, which agrees with that known analytically, and the \
variance in the usual way:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123237008285103`*^9, 3.412323738342453*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pbar", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"p", " ", "pdfp"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"p", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"pvar", "  ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"p", " ", "-", " ", "pbar"}], ")"}], "2"], " ", "pdfp"}], ",", 
    " ", 
    RowBox[{"{", 
     RowBox[{"p", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.3973839554697037`*^9, 3.397384027753643*^9}}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{{3.3973839715728593`*^9, 3.3973839925630417`*^9}, 
   3.397384029956811*^9, 3.397384124943395*^9, 3.3979844117266593`*^9, 
   3.412323688671029*^9}],

Cell[BoxData["12"], "Output",
 CellChangeTimes->{{3.3973839715728593`*^9, 3.3973839925630417`*^9}, 
   3.397384029956811*^9, 3.397384124943395*^9, 3.3979844117266593`*^9, 
   3.4123237067770643`*^9}]
}, Open  ]],

Cell["\<\
We see qualitative agreement between the pdf we have derived and the Monte \
Carlo data of Crain and Miles shown in Figure 3.7:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412323841040125*^9, 3.4123238749789267`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"pdfp", ",", " ", 
   RowBox[{"{", 
    RowBox[{"p", ",", " ", "0", ",", " ", "20"}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<p\>\"", ",", " ", "\"\<q(p)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.397385056012206*^9, 3.39738506847012*^9}, {
  3.3973851052830544`*^9, 3.397385125101552*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV02k81HsbBnD7QctjKS2W4Rz7Fk2l5XD/SjIkZAttCHMskWUYWylkqZAc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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"p\"", TraditionalForm], 
    FormBox["\"q(p)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0, 20}, {0., 0.18393972058571925`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.397385065035181*^9, 3.397385068570264*^9}, {
   3.3973851199942083`*^9, 3.3973851375594654`*^9}, 3.3979844118568463`*^9, 
   3.412323837094451*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PDF of Area", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.3974730795939007`*^9, 3.3974730816668816`*^9}}],

Cell[TextData[{
 "We derive the probability density of the areas of random rectangles with \
sides drawn from independent and identical exponential distributions, so ",
 StyleBox["a",
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "x"], " ", 
    SubscriptBox["g", "y"]}], TraditionalForm]]],
 ". The probability density of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "x"], " "}], TraditionalForm]]],
 "is defined in terms of the exponential pdf only; that of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "y"], TraditionalForm]]],
 "= ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "/", 
    SubscriptBox["g", "x"]}], TraditionalForm]]],
 " is defined using a variable transform:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412323911701731*^9, 3.4123240720222607`*^9}, 
   3.412324644315178*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pdfgx", " ", "=", " ", 
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", 
      RowBox[{"1", "/", "gbar"}], "]"}], ",", " ", "gx"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdfgy", " ", "=", " ", 
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", 
      RowBox[{"1", "/", "gbar"}], "]"}], ",", " ", "gy"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gy", " ", "=", " ", 
   RowBox[{"a", "/", "gx"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdfgy", " ", "=", " ", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"gy", ",", " ", "a"}], "]"}], " ", "pdfgy"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.3974654350616035`*^9, 3.397465491082157*^9}, {
  3.397472602537928*^9, 3.39747260675399*^9}, {3.39747321897432*^9, 
  3.39747323884289*^9}}],

Cell[TextData[{
 "The probability density of  ",
 StyleBox["a",
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "x"], " ", 
    SubscriptBox["g", "y"]}], TraditionalForm]]],
 " is obtained by integrating our pdfs over the domain 0 \[LessEqual] ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "x"], " ", "\[LessEqual]", " ", "\[Infinity]"}], 
   TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123240793528013`*^9, 3.4123241320686035`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pdfa", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"pdfgx", " ", "pdfgy"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"gx", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
    
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"gbar", ">", " ", "0"}], " ", "&&", " ", 
      RowBox[{"a", "\[GreaterEqual]", " ", "0"}]}]}]}], " ", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"TrueQ", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"pdfa", ",", " ", 
     RowBox[{"{", 
      RowBox[{"a", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
     
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"gbar", ">", " ", "0"}]}]}], "]"}], " ", "\[Equal]", " ", "1"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.397465536437374*^9, 3.397465619697096*^9}, {
   3.397469967599072*^9, 3.397470050728606*^9}, {3.3974711395242176`*^9, 
   3.397471149518589*^9}, 3.3974711898866353`*^9, {3.397472648383851*^9, 
   3.397472684986483*^9}, {3.3974736107276335`*^9, 3.3974736151740274`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox["a"]}], "gbar"]}], "]"}]}], 
  SuperscriptBox["gbar", "2"]]], "Output",
 CellChangeTimes->{
  3.397473620261342*^9, 3.397475911896552*^9, 3.3974779473133373`*^9, 
   3.3974779810017796`*^9, 3.3975390748303905`*^9, 3.397539982104987*^9, 
   3.3979844130886173`*^9, {3.4112058228733406`*^9, 3.4112058422912626`*^9}}],\


Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.397473620261342*^9, 3.397475911896552*^9, 
  3.3974779473133373`*^9, 3.3974779810017796`*^9, 3.3975390748303905`*^9, 
  3.397539982104987*^9, 3.3979844130886173`*^9, 3.4112058228733406`*^9, 
  3.41120585468909*^9}]
}, Open  ]],

Cell["\<\
We obtain the mean, variance and coefficient of variation in the usual way:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123241505652*^9, 3.4123241698429203`*^9}, 
   3.4123246497429824`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"abar", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"a", " ", "pdfa"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"a", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"gbar", ">", " ", "0"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"avar", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", " ", "-", "abar"}], ")"}], "2"], "pdfa"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"a", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"gbar", ">", " ", "0"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"CVa", " ", "=", 
  RowBox[{"PowerExpand", "[", " ", 
   RowBox[{
    SqrtBox["avar"], "/", "abar"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.397471134086398*^9, 3.3974711647104335`*^9}, {
  3.3974727855210447`*^9, 3.3974728570338755`*^9}}],

Cell[BoxData[
 SuperscriptBox["gbar", "2"]], "Output",
 CellChangeTimes->{3.3974739848455887`*^9, 3.397475924835157*^9, 
  3.3974779477840147`*^9, 3.397477993770139*^9, 3.3975390867975984`*^9, 
  3.3975399943325696`*^9, 3.3979844261373806`*^9, 3.4112058236144066`*^9, 
  3.4112058557406015`*^9}],

Cell[BoxData[
 RowBox[{"3", " ", 
  SuperscriptBox["gbar", "4"]}]], "Output",
 CellChangeTimes->{3.3974739848455887`*^9, 3.397475924835157*^9, 
  3.3974779477840147`*^9, 3.397477993770139*^9, 3.3975390867975984`*^9, 
  3.3975399943325696`*^9, 3.3979844261373806`*^9, 3.4112058236144066`*^9, 
  3.411205870772216*^9}],

Cell[BoxData[
 SqrtBox["3"]], "Output",
 CellChangeTimes->{3.3974739848455887`*^9, 3.397475924835157*^9, 
  3.3974779477840147`*^9, 3.397477993770139*^9, 3.3975390867975984`*^9, 
  3.3975399943325696`*^9, 3.3979844261373806`*^9, 3.4112058236144066`*^9, 
  3.411205870772216*^9}]
}, Open  ]],

Cell["\<\
Our pdf closely resembles that of a gamma distribution with the same mean and \
variance: \
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123242154985695`*^9, 3.4123242366990547`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pdfa", "/.", 
      RowBox[{"gbar", "\[Rule]", "1"}]}], ",", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"GammaDistribution", "[", 
        RowBox[{
         RowBox[{"1", "/", "3"}], ",", " ", "3"}], "]"}], ",", " ", "a"}], 
      "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", " ", "0", ",", " ", "5"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", " ", "Dashed"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<a\>\"", ",", " ", "\"\<g(a)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.39747293231212*^9, 3.3974730151912947`*^9}, {
  3.3974737255427294`*^9, 3.3974737346558332`*^9}, {3.3974737835761776`*^9, 
  3.397473788423147*^9}, {3.3974754164941983`*^9, 3.3974754334786205`*^9}, {
  3.3974758236797023`*^9, 3.3974758733110685`*^9}, {3.411205809413987*^9, 
  3.4112058155928717`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl1Hk01fn/B3BcKVtZRqVoVMoa2kZRPT+lRIZRQwkRqRtNUsqeTJF0I2uW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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwl03k0lYv7BXAiFWXsKspUCpFyc68Q+0UqFVcjaSCZUil1TVGKTEnhqiTz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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"a\"", TraditionalForm], 
    FormBox["\"g(a)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0, 5}, {0, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{3.3974758164493055`*^9, 3.397475942059925*^9, 
  3.3974779510086513`*^9, 3.3974780108847485`*^9, 3.397539103101042*^9, 
  3.3975400103255663`*^9, 3.3979844439029264`*^9, 3.411205826568654*^9, 
  3.411205870982518*^9}]
}, Open  ]],

Cell["\<\
A convenient linear measure of the size of polygonal voids is the radius of a \
circle with the same area. We obtain the pdf of pore radii using a variable \
transform:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412324249106896*^9, 3.4123243012418623`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"\[Pi]", " ", 
    SuperscriptBox["r", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pdfr", " ", "=", " ", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"a", ",", " ", "r"}], "]"}], "pdfa"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.3974773429242687`*^9, 3.397477415358424*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", "\[Pi]", " ", "r", " ", 
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox["\[Pi]"], " ", "r"}], "gbar"]}], "]"}]}], 
  SuperscriptBox["gbar", "2"]]], "Output",
 CellChangeTimes->{
  3.397477349063096*^9, {3.3974774033311296`*^9, 3.397477415809072*^9}, 
   3.3974777255644784`*^9, 3.397478010944835*^9, 3.397539103161128*^9, 
   3.3975400103455954`*^9, 3.397984443912941*^9}]
}, Open  ]],

Cell["and obtain the mean variance and coefficient of variation:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123243115667086`*^9, 3.412324321841483*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"rbar", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"r", " ", "pdfr"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"r", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"gbar", ">", "0"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"rvar", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "-", "rbar"}], ")"}], "2"], " ", "pdfr"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"r", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"gbar", ">", "0"}]}]}], "]"}]}], "\n", 
 RowBox[{"cvr", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{"PowerExpand", "[", 
    RowBox[{
     SqrtBox["rvar"], "/", "rbar"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "cvr", "]"}]}], "Input",
 CellChangeTimes->{{3.397477482424861*^9, 3.39747751699457*^9}, {
   3.397477564282566*^9, 3.3974775645629697`*^9}, 3.3974776026477327`*^9, 
   3.3974776440172195`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"gbar", " ", 
   SqrtBox["\[Pi]"]}], "4"]], "Output",
 CellChangeTimes->{
  3.397477487281845*^9, 3.39747751781575*^9, 3.3974775654943085`*^9, {
   3.3974776050311604`*^9, 3.39747763532472*^9}, 3.397478012266736*^9, 
   3.3975391043928995`*^9, 3.3975400116674957`*^9, 3.3979844452548704`*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["gbar", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", "\[Pi]"], "-", 
    FractionBox["\[Pi]", "16"]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.397477487281845*^9, 3.39747751781575*^9, 3.3974775654943085`*^9, {
   3.3974776050311604`*^9, 3.39747763532472*^9}, 3.397478012266736*^9, 
   3.3975391043928995`*^9, 3.3975400116674957`*^9, 3.3979844737258096`*^9}],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   RowBox[{"16", "-", 
    SuperscriptBox["\[Pi]", "2"]}]], "\[Pi]"]], "Output",
 CellChangeTimes->{
  3.397477487281845*^9, 3.39747751781575*^9, 3.3974775654943085`*^9, {
   3.3974776050311604`*^9, 3.39747763532472*^9}, 3.397478012266736*^9, 
   3.3975391043928995`*^9, 3.3975400116674957`*^9, 3.3979844737258096`*^9}],

Cell[BoxData["0.7881236820940001`"], "Output",
 CellChangeTimes->{
  3.397477487281845*^9, 3.39747751781575*^9, 3.3974775654943085`*^9, {
   3.3974776050311604`*^9, 3.39747763532472*^9}, 3.397478012266736*^9, 
   3.3975391043928995`*^9, 3.3975400116674957`*^9, 3.3979844737258096`*^9}]
}, Open  ]],

Cell["\<\
Again, the probability density is well approximated by a gamma distribution \
with the same mean and variance:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123243512437615`*^9, 3.4123243808363132`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pdfr", "/.", 
      RowBox[{"gbar", "\[Rule]", "1"}]}], ",", " ", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"GammaDistribution", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          SuperscriptBox["cvr", "2"]}], ",", " ", 
         RowBox[{
          RowBox[{
           SuperscriptBox["cvr", 
            RowBox[{"2", " "}]], "rbar"}], "/.", 
          RowBox[{"gbar", "\[Rule]", "1"}]}]}], "]"}], ",", " ", "r"}], 
      "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"r", ",", " ", "0", ",", " ", "2"}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", " ", "Dashed"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<r\>\"", ",", " ", "\"\<f(r)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.39753967052696*^9, 3.397539862723325*^9}, 
   3.3975399079283266`*^9, {3.3975399500989647`*^9, 3.3975399559273453`*^9}}],\


Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1mk4VV0bB3CkKBLNZJ6ahCZJ6V9UilKmQkghRcaQ9DQg1GNoEopQUSQd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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwV1nk0VW0bBvBUopQpcyJD3rwhKanQVYZIRYNC6SRElKgkZIgTUoYGUyUp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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"r\"", TraditionalForm], 
    FormBox["\"f(r)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.397539863244074*^9, 3.3975399089397807`*^9, 
  3.397539956758541*^9, 3.3975400380153823`*^9, 3.3979844738760257`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3.4 Intrinsic Correlation", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.3978856790323267`*^9, 3.3978856828878703`*^9}, {
  3.412324426942611*^9, 3.4123244320799985`*^9}}],

Cell[TextData[{
 "We investigate the correlation between the adjacent sides of polygonal \
voids using numerical methods. We begin with a small process of only 5 lines \
allowing inspection of the outputs. Once our code is developed, we can \
increase the number of lines in our Poisson process and suppress the output. \
The repeated use of ",
 StyleBox["SeedRandom", "Input"],
 " in the following code allows us to increase the number of lines whilst \
retaining the original set. So, for example, if we change ",
 StyleBox["nlines", "Input"],
 " to 6 instead of 5, then we get the original 5 lines and one other."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412324465468008*^9, 3.4123245466146913`*^9}, 
   3.4123246529275618`*^9, {3.412324696049568*^9, 3.4123247771662083`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nlines", " ", "=", "5"}], ";", 
  RowBox[{"nseed", " ", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SeedRandom", "[", "nseed", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xi", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", " ", 
     RowBox[{"{", "nlines", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SeedRandom", "[", 
  RowBox[{"nseed", "+", "1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yi", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", " ", 
     RowBox[{"{", "nlines", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"SeedRandom", "[", 
  RowBox[{"nseed", "+", "2"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]i", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", " ", 
       RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", " ", 
     RowBox[{"{", "nlines", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"lines", " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Tan", "[", "\[Theta]i", "]"}], 
     RowBox[{"(", 
      RowBox[{"x", " ", "-", " ", "xi"}], ")"}]}], " ", "+", " ", "yi"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.3978001405740643`*^9, 3.397800196744834*^9}, {
   3.397800229682195*^9, 3.3978002732748785`*^9}, 3.3978034482202253`*^9, 
   3.3978054657012205`*^9, 3.3978055146315794`*^9, {3.397812305246003*^9, 
   3.397812305726694*^9}, 3.3978159915366287`*^9, {3.39781604734688*^9, 
   3.3978160478476*^9}, 3.3978167348254256`*^9, {3.397817413611472*^9, 
   3.39781741472307*^9}, 3.397819446424514*^9, 3.3978215717505827`*^9, {
   3.3978216478900657`*^9, 3.3978216482305555`*^9}, 3.397821859784755*^9, 
   3.397822180545987*^9, {3.3978228466838465`*^9, 3.397822846844077*^9}, 
   3.3978234150210752`*^9, {3.397823508195053*^9, 3.3978235086256723`*^9}, {
   3.3978838631712465`*^9, 3.397883863341491*^9}, 3.397883893895426*^9, 
   3.3978857252187395`*^9}],

Cell[TextData[{
 "To obtain the lengths of polygon sides, we first find the coordinates of \
the points of intersection of our random lines. We obtain first the ",
 StyleBox["x",
  FontSlant->"Italic"],
 "-coordinate:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412324805557032*^9, 3.4123248640010705`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"x", "/.", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lines", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", 
         RowBox[{"lines", "[", 
          RowBox[{"[", "j", "]"}], "]"}]}], ",", " ", "x"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "1", ",", " ", 
      RowBox[{"nlines", "-", "1"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"j", ",", " ", 
      RowBox[{"i", "+", "1"}], ",", " ", "nlines"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.397886300916552*^9, 3.3978863028192883`*^9}, {
  3.3978865638346095`*^9, 3.397886566037778*^9}, {3.397891307425558*^9, 
  3.397891311972096*^9}, {3.397891445163616*^9, 3.3978915012041984`*^9}, {
  3.3978916785091505`*^9, 3.397891679370389*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.09333744503695396`", ",", "0.23116643655190858`", ",", 
     "0.07711626988727016`", ",", "0.12287422872782275`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.09160316900149522`", ",", "0.0943121081095906`", ",", 
     "0.09207094913030422`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03385896420063909`", ",", "0.07596845097683975`"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"-", "0.04375882132337762`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.3978863049323263`*^9, {3.3978865717459855`*^9, 3.39788659829416*^9}, 
   3.397891312502859*^9, 3.397891345440221*^9, 3.3978914513024435`*^9, {
   3.3978914890767603`*^9, 3.3978915043086624`*^9}, 3.3978916807724047`*^9, 
   3.397891716573885*^9, 3.3979043204874225`*^9, 3.397904598757555*^9, 
   3.397974466822899*^9, 3.397984473936112*^9, 3.397984658872037*^9, 
   3.3979853168381453`*^9, 3.404737646527125*^9}]
}, Open  ]],

Cell[TextData[{
 "and then the ",
 StyleBox["y",
  FontSlant->"Italic"],
 "-coordinate to yield a pair. Note that the output is a list of sublists, \
each of which gives the points of intersection on a given line. In our \
example, the first element is a sublist of length 3; these then are the three \
points of intersection on the fist line in our list:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412324892111491*^9, 3.4123249339316254`*^9}, {
  3.4123249771738048`*^9, 3.4123250249424925`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XY", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"X", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"lines", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "/.", 
        RowBox[{"x", "\[Rule]", 
         RowBox[{"X", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}]}]}], "}"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "1", ",", " ", 
      RowBox[{"nlines", "-", "1"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.397804421529776*^9, 3.397804461467203*^9}, {
   3.3978045257696657`*^9, 3.3978045713351855`*^9}, {3.397806000370037*^9, 
   3.397806012116928*^9}, {3.397806046726694*^9, 3.397806051934182*^9}, {
   3.39780847971516*^9, 3.3978085010358176`*^9}, 3.3978161160356493`*^9, 
   3.397886266136541*^9, {3.3978913227776337`*^9, 3.397891327824891*^9}, {
   3.3978916851186543`*^9, 3.3978916857395473`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.09333744503695396`", ",", "0.7710969077789549`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.23116643655190858`", ",", "0.7617965754566678`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.07711626988727016`", ",", "0.77219146936496`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"0.12287422872782275`", ",", "0.7691038444833653`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.09160316900149522`", ",", "0.8345561596900442`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.0943121081095906`", ",", "0.7354328103744576`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"0.09207094913030422`", ",", "0.8174395205702281`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.03385896420063909`", ",", "0.8646603870196286`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.07596845097683975`", ",", "0.8427071266532467`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.04375882132337762`"}], ",", "1.0305799352724034`"}], 
     "}"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.3978862665871887`*^9, 3.397886573107944*^9, 3.3978867347303457`*^9, {
   3.3978913281854095`*^9, 3.3978913455103216`*^9}, 3.397891504378763*^9, 
   3.3978916864004974`*^9, 3.3978917166439857`*^9, 3.3979043205675373`*^9, 
   3.397904598867714*^9, 3.3979744669130287`*^9, 3.3979844739461265`*^9, 
   3.3979846589621663`*^9, 3.397985316898232*^9, 3.404737646558375*^9}]
}, Open  ]],

Cell[TextData[{
 "Subsequently, we will need to know which pair of lines generated each \
crossing. We therefore associate each coordinate with an identifier {i,j} \
where the {i,j} are the positions of the equations of the lines in our list \
",
 StyleBox["lines", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412325041997016*^9, 3.412325141640296*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sourcelines", " ", "=", 
   RowBox[{"Drop", "[", " ", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", "nlines"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"j", ",", " ", 
         RowBox[{"i", "+", "1"}], ",", " ", "nlines"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"XYid1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"sourcelines", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", 
       RowBox[{"XY", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "1", ",", " ", 
       RowBox[{"nlines", "-", "1"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", " ", "1", ",", " ", 
       RowBox[{"Length", "[", 
        RowBox[{"XY", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"XYid2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Reverse", "[", 
        RowBox[{"sourcelines", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"XY", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "1", ",", " ", 
       RowBox[{"nlines", "-", "1"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", " ", "1", ",", " ", 
       RowBox[{"Length", "[", 
        RowBox[{"XY", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"XYid", " ", "=", " ", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Sort", "[", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"Join", "[", 
           RowBox[{"XYid1", ",", " ", "XYid2"}], "]"}], "]"}], ",", "2"}], 
        "]"}], ",", "2"}], "]"}], "]"}], ",", " ", 
    RowBox[{"nlines", "-", "1"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.397808867492757*^9, 3.397808992402368*^9}, {
   3.397809660192603*^9, 3.397809662045267*^9}, {3.397810098212445*^9, 
   3.397810105362726*^9}, {3.3978109934998045`*^9, 3.3978109994283295`*^9}, {
   3.3978114799693136`*^9, 3.397811481902093*^9}, {3.3978155229828815`*^9, 
   3.3978155345695424`*^9}, {3.397819024658043*^9, 3.3978190351731634`*^9}, {
   3.3978190753108788`*^9, 3.397819079687171*^9}, {3.3978191133756127`*^9, 
   3.397819116630293*^9}, 3.397819159802371*^9, 3.3978216729260654`*^9, {
   3.3978905209446545`*^9, 3.3978905312795153`*^9}, {3.3978911570192847`*^9, 
   3.3978911636187744`*^9}, 3.397891663808011*^9, {3.3978918789473667`*^9, 
   3.397891894519758*^9}, {3.3978919323241186`*^9, 3.3978919434701457`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09333744503695396`", ",", "0.7710969077789549`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.23116643655190858`", ",", "0.7617965754566678`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.07711626988727016`", ",", "0.77219146936496`"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.12287422872782275`", ",", "0.7691038444833653`"}], "}"}]}],
       "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09333744503695396`", ",", "0.7710969077789549`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09160316900149522`", ",", "0.8345561596900442`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0943121081095906`", ",", "0.7354328103744576`"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09207094913030422`", ",", "0.8174395205702281`"}], "}"}]}],
       "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.23116643655190858`", ",", "0.7617965754566678`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09160316900149522`", ",", "0.8345561596900442`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.03385896420063909`", ",", "0.8646603870196286`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.07596845097683975`", ",", "0.8427071266532467`"}], "}"}]}],
       "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.07711626988727016`", ",", "0.77219146936496`"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0943121081095906`", ",", "0.7354328103744576`"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.03385896420063909`", ",", "0.8646603870196286`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.04375882132337762`"}], ",", "1.0305799352724034`"}], 
        "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.12287422872782275`", ",", "0.7691038444833653`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09207094913030422`", ",", "0.8174395205702281`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.07596845097683975`", ",", "0.8427071266532467`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.04375882132337762`"}], ",", "1.0305799352724034`"}], 
        "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.3978905317401776`*^9, 3.3978911641194944`*^9, 3.397891664378832*^9, {
   3.3978918710159616`*^9, 3.3978918951206226`*^9}, 3.3978919445517006`*^9, 
   3.397904320657667*^9, 3.3979045989378147`*^9, 3.3979744670532303`*^9, 
   3.397984473966155*^9, 3.3979846590422816`*^9, 3.397985316948304*^9, 
   3.404737646589625*^9}]
}, Open  ]],

Cell[TextData[{
 "We remove any crossings occurring outside the unit square and replace them \
with an empty sublist. These are then removed using ",
 StyleBox["Flatten", "Input"],
 ", and the original list structure recovered using ",
 StyleBox["Partition", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123251682685857`*^9, 3.412325219301968*^9}, 
   3.412326963630189*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"XYid", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"0", "\[LessEqual]", 
            RowBox[{"XYid", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j", ",", "2", ",", "1"}], "]"}], "]"}], " ", 
            "\[LessEqual]", "1."}], " ", "&&", 
           RowBox[{"0", "\[LessEqual]", 
            RowBox[{"XYid", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j", ",", "2", ",", "2"}], "]"}], "]"}], " ", 
            "\[LessEqual]", "1."}]}], ")"}], ",", " ", 
         RowBox[{"XYid", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", " ", "1", ",", " ", 
         RowBox[{"Length", "[", 
          RowBox[{"XYid", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", " ", 
     
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "1", ",", " ", "nlines"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"XYid", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Partition", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"XYid", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
      "2"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "1", ",", " ", 
      RowBox[{"Length", "[", "XYid", "]"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.3978161569845314`*^9, 3.3978161689917965`*^9}, {
   3.3978162845279293`*^9, 3.397816333438259*^9}, 3.39782168361143*^9, 
   3.3978908717290573`*^9, {3.397890944693976*^9, 3.39789094980132*^9}, {
   3.3978923040386176`*^9, 3.3978923342520623`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09333744503695396`", ",", "0.7710969077789549`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.23116643655190858`", ",", "0.7617965754566678`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.07711626988727016`", ",", "0.77219146936496`"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.12287422872782275`", ",", "0.7691038444833653`"}], "}"}]}],
       "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09333744503695396`", ",", "0.7710969077789549`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09160316900149522`", ",", "0.8345561596900442`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0943121081095906`", ",", "0.7354328103744576`"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09207094913030422`", ",", "0.8174395205702281`"}], "}"}]}],
       "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.23116643655190858`", ",", "0.7617965754566678`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09160316900149522`", ",", "0.8345561596900442`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.03385896420063909`", ",", "0.8646603870196286`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.07596845097683975`", ",", "0.8427071266532467`"}], "}"}]}],
       "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.07711626988727016`", ",", "0.77219146936496`"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0943121081095906`", ",", "0.7354328103744576`"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.03385896420063909`", ",", "0.8646603870196286`"}], "}"}]}],
       "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.12287422872782275`", ",", "0.7691038444833653`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.09207094913030422`", ",", "0.8174395205702281`"}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.07596845097683975`", ",", "0.8427071266532467`"}], "}"}]}],
       "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.397890872670411*^9, 3.39789095039217*^9, 
  3.3978923401205006`*^9, 3.3978923756215487`*^9, 3.397904320727768*^9, 
  3.397904599027944*^9, 3.397974467193432*^9, 3.3979844739761696`*^9, 
  3.3979846591123824`*^9, 3.3979853170384336`*^9, 3.40473764666775*^9}]
}, Open  ]],

Cell["\<\
To obtain polygon side lengths, we require a sorted list, so that adjacent \
crossings occur next to each other. We append a dummy coordinate \
{{0,0},{0,0}} to each sublist so that polygon sides extending beyond the unit \
square can be removed from our subsequent analysis:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412325262764464*^9, 3.4123253536050863`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"XYid", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sort", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Reverse", "[", 
         RowBox[{"XYid", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", " ", "1", ",", " ", 
          RowBox[{"Length", "[", 
           RowBox[{"XYid", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
     ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", " ", "1", ",", " ", 
       RowBox[{"Length", "[", "XYid", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"XYid", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Append", "[", 
     RowBox[{
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"XYid", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "]"}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "1", ",", " ", "nlines"}], "}"}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.397815955564904*^9, 3.3978159664505568`*^9}, {
   3.397816462593976*^9, 3.3978164633250275`*^9}, 3.3978216917230945`*^9, 
   3.3978909694095154`*^9, {3.397894121041339*^9, 3.39789413597281*^9}, {
   3.397896353191013*^9, 3.3978963679021664`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.07711626988727016`", ",", "0.77219146936496`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.09333744503695396`", ",", "0.7710969077789549`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.12287422872782275`", ",", "0.7691038444833653`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.23116643655190858`", ",", "0.7617965754566678`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.09160316900149522`", ",", "0.8345561596900442`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.09207094913030422`", ",", "0.8174395205702281`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.09333744503695396`", ",", "0.7710969077789549`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.0943121081095906`", ",", "0.7354328103744576`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.03385896420063909`", ",", "0.8646603870196286`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.07596845097683975`", ",", "0.8427071266532467`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.09160316900149522`", ",", "0.8345561596900442`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.23116643655190858`", ",", "0.7617965754566678`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.03385896420063909`", ",", "0.8646603870196286`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.07711626988727016`", ",", "0.77219146936496`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.0943121081095906`", ",", "0.7354328103744576`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.07596845097683975`", ",", "0.8427071266532467`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.09207094913030422`", ",", "0.8174395205702281`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.12287422872782275`", ",", "0.7691038444833653`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.3978963682526703`*^9, 3.397896413587859*^9, 
  3.3979043208078833`*^9, 3.397904599128088*^9, 3.397974467273547*^9, 
  3.397984473986184*^9, 3.3979846591924973`*^9, 3.397985317118549*^9, 
  3.404737646714625*^9}]
}, Open  ]],

Cell[TextData[{
 "Each point of intersection is associated with 4 polygon sides, so is \
defined by a group of 5 coordinates. We obtain these groups of 5 coordinates \
by selecting a coordinate on a line and those on either side of it. The \
coordinates of adjacent crossings on the line generating the intersection are \
obtained using ",
 StyleBox["Position", "Input"],
 " to select lines by the identifiers we included earlier:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412325375706867*^9, 3.4123254952187166`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"G5", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XYid", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j", ",", " ", "1"}], "]"}], "]"}], ",", " ", 
       RowBox[{"XYid", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"j", "-", "1"}], ",", " ", "1"}], "]"}], "]"}], ",", " ", 
       RowBox[{"XYid", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"j", "+", "1"}], ",", " ", "1"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"XYid", "[", 
          RowBox[{"[", 
           RowBox[{"XYid", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j", ",", "2", ",", "2"}], "]"}], "]"}], "]"}],
           "]"}], "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{"Position", "[", 
             RowBox[{
              RowBox[{"XYid", "[", 
               RowBox[{"[", 
                RowBox[{"XYid", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j", ",", "2", ",", "2"}], "]"}], "]"}], 
                "]"}], "]"}], ",", " ", 
              RowBox[{"XYid", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "j", ",", "2", ",", "1"}], "]"}], "]"}]}], 
             "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", "1"}], "]"}], "]"}], 
        "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"XYid", "[", 
          RowBox[{"[", 
           RowBox[{"XYid", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j", ",", "2", ",", "2"}], "]"}], "]"}], "]"}],
           "]"}], "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{"Position", "[", 
             RowBox[{
              RowBox[{"XYid", "[", 
               RowBox[{"[", 
                RowBox[{"XYid", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j", ",", "2", ",", "2"}], "]"}], "]"}], 
                "]"}], "]"}], ",", " ", 
              RowBox[{"XYid", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "j", ",", "2", ",", "1"}], "]"}], "]"}]}], 
             "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}], "]"}], "]"}], 
        "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "  ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "1", ",", " ", "nlines"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", " ", "2", ",", " ", 
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"XYid", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}], "-", "1"}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.3978036402263165`*^9, 3.397803678611512*^9}, {
   3.3978056294867325`*^9, 3.397805705716346*^9}, {3.3978132770233507`*^9, 
   3.397813289901869*^9}, {3.397813377958488*^9, 3.3978134052978*^9}, {
   3.3978134442838593`*^9, 3.3978134791239567`*^9}, {3.3978157838780303`*^9, 
   3.3978158172359967`*^9}, 3.397816634861685*^9, {3.397816837132536*^9, 
   3.3978168390653152`*^9}, {3.397817596684718*^9, 3.397817636742318*^9}, {
   3.397819386618517*^9, 3.3978194009290943`*^9}, {3.39781952350535*^9, 
   3.397819525698504*^9}, {3.397819688031928*^9, 3.397819689453973*^9}, {
   3.397819873168141*^9, 3.397819883943635*^9}, 3.397821703510043*^9, {
   3.3978970932651873`*^9, 3.3978971499266624`*^9}, 3.3978972586830463`*^9}],

Cell[TextData[{
 "The following code picks out the groups of 5 coordinates that are \
associated with points of intersection on the first line in our list ",
 StyleBox["lines", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.41232552028476*^9, 3.4123255699762125`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G5", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.397897215731285*^9, 3.3978972454239807`*^9}, {
  3.3978974417462783`*^9, 3.3978974420166674`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.07711626988727016`", ",", "0.77219146936496`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.09333744503695396`", ",", "0.7710969077789549`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.03385896420063909`", ",", "0.8646603870196286`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.0943121081095906`", ",", "0.7354328103744576`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.09333744503695396`", ",", "0.7710969077789549`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.07711626988727016`", ",", "0.77219146936496`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"0.12287422872782275`", ",", "0.7691038444833653`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.09207094913030422`", ",", "0.8174395205702281`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.0943121081095906`", ",", "0.7354328103744576`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.12287422872782275`", ",", "0.7691038444833653`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.09333744503695396`", ",", "0.7710969077789549`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.23116643655190858`", ",", "0.7617965754566678`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.09207094913030422`", ",", "0.8174395205702281`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.23116643655190858`", ",", "0.7617965754566678`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.12287422872782275`", ",", "0.7691038444833653`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.09160316900149522`", ",", "0.8345561596900442`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.397897479290264*^9, 3.397904321128344*^9, 
  3.3979045993183613`*^9, 3.3979744674137487`*^9, 3.3979844740162272`*^9, 
  3.397984659282627*^9, 3.397985317218693*^9, 3.40473764679275*^9}]
}, Open  ]],

Cell["\<\
We apply Pythagoras' theorem to compute the polygon side lengths from the \
groups of 5 coordinates and assign a length zero to any lines extending \
beyond the unit square:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412325587401269*^9, 3.4123256279495745`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"G5", " ", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"G5", ",", "1"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sides", " ", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"G5", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[NotEqual]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], ",", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"G5", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1", ",", "1"}], "]"}], "]"}], "-", " ", 
              RowBox[{"G5", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "j", ",", "1"}], "]"}], "]"}]}], ")"}], "^",
             "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"G5", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1", ",", "2"}], "]"}], "]"}], "-", " ", 
              RowBox[{"G5", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "j", ",", "2"}], "]"}], "]"}]}], ")"}], "^",
             "2"}]}], "]"}], ",", "0"}], "]"}], ",", "  ", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "1", ",", 
       RowBox[{"Length", "[", "G5", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sides", "[", 
  RowBox[{"[", "1", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.3978036402263165`*^9, 3.397803678611512*^9}, {
   3.3978056294867325`*^9, 3.3978056972041054`*^9}, {3.39781969249835*^9, 
   3.397819696353894*^9}, 3.3978217064743056`*^9, {3.397897905372941*^9, 
   3.3978979122728624`*^9}, {3.39789795262088*^9, 3.397897970366397*^9}, 
   3.3978980628493805`*^9, {3.3978981374666753`*^9, 3.3978981376269054`*^9}, {
   3.3978981769234114`*^9, 3.397898179807558*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0.016258062255455816`", ",", "0.1020867044599468`", ",", 
   "0.0405819647497291`"}], "}"}]], "Output",
 CellChangeTimes->{3.397898198254083*^9, 3.397904321228488*^9, 
  3.397904599408491*^9, 3.397974467523907*^9, 3.3979844740262413`*^9, 
  3.3979846593827715`*^9, 3.3979853173188367`*^9, 3.404737646824*^9}]
}, Open  ]],

Cell["\<\
Each polygon side is then paired with those adjacent to it and sides of \
length zero are excluded from the analysis:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123256442229743`*^9, 3.4123256903693295`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pairs", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"sides", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"sides", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"sides", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"sides", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"sides", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"sides", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "4"}], "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"sides", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "4"}], "]"}], "]"}], ",", " ", 
           RowBox[{"sides", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "}"}]}], "}"}], ",", 
       " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", 
         RowBox[{"Length", "[", "sides", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pairs", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{"pairs", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
       RowBox[{"y", ">", "0"}]}], " ", "/;", 
      RowBox[{"x", ">", "0"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.3978202210683966`*^9, 3.3978202823965826`*^9}, 
   3.3978217235288286`*^9, {3.397898142493904*^9, 3.397898156093459*^9}, {
   3.397898569467862*^9, 3.3978985696781645`*^9}, 3.3979044810783405`*^9, 
   3.397904542927275*^9}],

Cell[TextData[{
 "We have counted each intersection twice, so we sort the list ",
 StyleBox["pairs", "Input"],
 " and remove alternate entries using ",
 StyleBox["Take", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123257068730607`*^9, 3.4123257432353473`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pairs", " ", "=", " ", 
   RowBox[{"Sort", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sort", "[", 
       RowBox[{"pairs", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"i", ",", " ", "1", ",", " ", 
        RowBox[{"Length", "[", "pairs", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"pairs", " ", "=", 
   RowBox[{"Take", "[", 
    RowBox[{"pairs", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"Length", "[", "pairs", "]"}], ",", "2"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.3978205904795837`*^9, 3.3978205929030685`*^9}, {
   3.39782063669604*^9, 3.397820638118085*^9}, {3.397820721938613*^9, 
   3.397820749688515*^9}, {3.3978208225733185`*^9, 3.397820825116976*^9}, 
   3.3978217278650637`*^9, 3.397899639095912*^9, {3.3978997341525965`*^9, 
   3.3978997461999197`*^9}}],

Cell["We may now compute the correlation:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123257613413825`*^9, 3.412325770344328*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pairsXY", " ", "=", " ", 
   RowBox[{"Transpose", "[", "pairs", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", " ", "=", " ", 
   RowBox[{"pairsXY", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Y", " ", "=", " ", 
   RowBox[{"pairsXY", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Correlation", "[", 
  RowBox[{"X", ",", "Y"}], "]"}]}], "Input",
 CellChangeTimes->{{3.397821557950739*^9, 3.3978215636088753`*^9}, 
   3.3978992568262353`*^9, {3.3979038828180847`*^9, 3.3979039533094463`*^9}}],\


Cell[BoxData["0.5843823332774744`"], "Output",
 CellChangeTimes->{3.397903965567072*^9, 3.3979043213486605`*^9, 
  3.397904599718938*^9, 3.397974468084714*^9, 3.397984474086328*^9, 
  3.39798465965316*^9, 3.3979853174590387`*^9, 3.40473764691775*^9}]
}, Open  ]],

Cell[TextData[{
 "We collect all our code into a single command ",
 StyleBox["ComputeCorr", "Input"],
 " with arguments controlling the number of lines (",
 StyleBox["nl", "Input"],
 ") and the random seed (",
 StyleBox["ns", "Input"],
 ")."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412325781590499*^9, 3.4123258500990095`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ComputeCorr", "[", 
   RowBox[{"nl_", ",", "ns_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"nlines", " ", "=", "nl"}], ";", 
    RowBox[{"nseed", " ", "=", "ns"}], ";", 
    RowBox[{"SeedRandom", "[", "nseed", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"xi", " ", "=", " ", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", " ", 
       RowBox[{"{", "nlines", "}"}]}], "]"}]}], ";", 
    RowBox[{"SeedRandom", "[", 
     RowBox[{"nseed", "+", "1"}], "]"}], ";", 
    RowBox[{"yi", " ", "=", " ", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", " ", 
       RowBox[{"{", "nlines", "}"}]}], "]"}]}], ";", 
    RowBox[{"SeedRandom", "[", 
     RowBox[{"nseed", "+", "2"}], "]"}], ";", 
    RowBox[{"\[Theta]i", " ", "=", " ", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", " ", 
         RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", " ", 
       RowBox[{"{", "nlines", "}"}]}], "]"}]}], ";", 
    RowBox[{"lines", " ", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Tan", "[", "\[Theta]i", "]"}], 
       RowBox[{"(", 
        RowBox[{"x", " ", "-", " ", "xi"}], ")"}]}], " ", "+", " ", "yi"}]}], 
    ";", 
    RowBox[{"X", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"x", "/.", 
        RowBox[{
         RowBox[{"Solve", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"lines", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", 
            RowBox[{"lines", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], ",", " ", "x"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", 
         RowBox[{"nlines", "-", "1"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"j", ",", " ", 
         RowBox[{"i", "+", "1"}], ",", " ", "nlines"}], "}"}]}], "]"}]}], ";",
     
    RowBox[{"XY", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"X", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"lines", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "/.", 
           RowBox[{"x", "\[Rule]", 
            RowBox[{"X", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}]}], "}"}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", 
         RowBox[{"nlines", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    RowBox[{"sourcelines", " ", "=", 
     RowBox[{"Drop", "[", " ", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", "j"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"i", ",", " ", "1", ",", " ", "nlines"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"j", ",", " ", 
           RowBox[{"i", "+", "1"}], ",", " ", "nlines"}], "}"}]}], "]"}], ",",
        
       RowBox[{"-", "1"}]}], "]"}]}], ";", 
    RowBox[{"XYid1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"sourcelines", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", 
         RowBox[{"XY", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", 
         RowBox[{"nlines", "-", "1"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"j", ",", " ", "1", ",", " ", 
         RowBox[{"Length", "[", 
          RowBox[{"XY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
    RowBox[{"XYid2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Reverse", "[", 
          RowBox[{"sourcelines", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "]"}], ",", 
         RowBox[{"XY", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", 
         RowBox[{"nlines", "-", "1"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"j", ",", " ", "1", ",", " ", 
         RowBox[{"Length", "[", 
          RowBox[{"XY", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
    RowBox[{"XYid", " ", "=", " ", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Sort", "[", 
        RowBox[{"Partition", "[", 
         RowBox[{
          RowBox[{"Partition", "[", 
           RowBox[{
            RowBox[{"Flatten", "[", 
             RowBox[{"Join", "[", 
              RowBox[{"XYid1", ",", " ", "XYid2"}], "]"}], "]"}], ",", "2"}], 
           "]"}], ",", "2"}], "]"}], "]"}], ",", " ", 
       RowBox[{"nlines", "-", "1"}]}], "]"}]}], ";", 
    RowBox[{"XYid", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"0", "\[LessEqual]", 
              RowBox[{"XYid", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "j", ",", "2", ",", "1"}], "]"}], "]"}], 
              " ", "\[LessEqual]", "1."}], " ", "&&", 
             RowBox[{"0", "\[LessEqual]", 
              RowBox[{"XYid", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "j", ",", "2", ",", "2"}], "]"}], "]"}], 
              " ", "\[LessEqual]", "1."}]}], ")"}], ",", " ", 
           RowBox[{"XYid", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", 
           RowBox[{"{", "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", " ", "1", ",", " ", 
           RowBox[{"Length", "[", 
            RowBox[{"XYid", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
       " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", "nlines"}], "}"}]}], "]"}]}], 
    ";", 
    RowBox[{"XYid", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Partition", "[", 
          RowBox[{
           RowBox[{"Flatten", "[", 
            RowBox[{"XYid", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
         "2"}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", 
         RowBox[{"Length", "[", "XYid", "]"}]}], "}"}]}], "]"}]}], ";", 
    RowBox[{"XYid", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sort", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Reverse", "[", 
           RowBox[{"XYid", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}], "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", " ", "1", ",", " ", 
            RowBox[{"Length", "[", 
             RowBox[{"XYid", "[", 
              RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
       ",", " ", 
       RowBox[{"{", 
        RowBox[{"j", ",", " ", "1", ",", " ", 
         RowBox[{"Length", "[", "XYid", "]"}]}], "}"}]}], "]"}]}], ";", 
    RowBox[{"XYid", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Append", "[", 
        RowBox[{
         RowBox[{"Prepend", "[", 
          RowBox[{
           RowBox[{"XYid", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "]"}], " ", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", "nlines"}], "}"}]}], "]"}]}], 
    ";", 
    RowBox[{"G5", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"XYid", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j", ",", " ", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{"XYid", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", 
            RowBox[{"j", "-", "1"}], ",", " ", "1"}], "]"}], "]"}], ",", " ", 
         
         RowBox[{"XYid", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", 
            RowBox[{"j", "+", "1"}], ",", " ", "1"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"XYid", "[", 
            RowBox[{"[", 
             RowBox[{"XYid", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "j", ",", "2", ",", "2"}], "]"}], "]"}], 
             "]"}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{
                RowBox[{"XYid", "[", 
                 RowBox[{"[", 
                  RowBox[{"XYid", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "j", ",", "2", ",", "2"}], "]"}], "]"}],
                   "]"}], "]"}], ",", " ", 
                RowBox[{"XYid", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j", ",", "2", ",", "1"}], "]"}], "]"}]}],
                "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", "1"}], "]"}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"XYid", "[", 
            RowBox[{"[", 
             RowBox[{"XYid", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "j", ",", "2", ",", "2"}], "]"}], "]"}], 
             "]"}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{
                RowBox[{"XYid", "[", 
                 RowBox[{"[", 
                  RowBox[{"XYid", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "j", ",", "2", ",", "2"}], "]"}], "]"}],
                   "]"}], "]"}], ",", " ", 
                RowBox[{"XYid", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j", ",", "2", ",", "1"}], "]"}], "]"}]}],
                "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}], "]"}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "  ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", "nlines"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", " ", "2", ",", " ", 
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"XYid", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "]"}], "-", "1"}]}], "}"}]}], 
      "]"}]}], ";", 
    RowBox[{"G5", " ", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"G5", ",", "1"}], "]"}]}], ";", 
    RowBox[{"sides", " ", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"G5", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[NotEqual]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], ",", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"G5", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1", ",", "1"}], "]"}], "]"}], "-", " ", 
                RowBox[{"G5", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j", ",", "1"}], "]"}], "]"}]}], ")"}], 
              "^", "2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"G5", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1", ",", "2"}], "]"}], "]"}], "-", " ", 
                RowBox[{"G5", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j", ",", "2"}], "]"}], "]"}]}], ")"}], 
              "^", "2"}]}], "]"}], ",", "0"}], "]"}], ",", "  ", 
         RowBox[{"{", 
          RowBox[{"j", ",", "2", ",", "5"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", 
         RowBox[{"Length", "[", "G5", "]"}]}], "}"}]}], "]"}]}], ";", 
    RowBox[{"pairs", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"sides", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", " ", 
             RowBox[{"sides", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"sides", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
             RowBox[{"sides", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"sides", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"sides", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "4"}], "]"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"sides", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "4"}], "]"}], "]"}], ",", " ", 
             RowBox[{"sides", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "}"}]}], "}"}], ",", 
         " ", 
         RowBox[{"{", 
          RowBox[{"i", ",", " ", "1", ",", " ", 
           RowBox[{"Length", "[", "sides", "]"}]}], "}"}]}], "]"}], ",", 
       "1"}], "]"}]}], ";", 
    RowBox[{"pairs", "=", 
     RowBox[{"Cases", "[", 
      RowBox[{"pairs", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
         RowBox[{"y", ">", "0"}]}], " ", "/;", 
        RowBox[{"x", ">", "0"}]}]}], "]"}]}], ";", 
    RowBox[{"pairs", " ", "=", " ", 
     RowBox[{"Sort", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sort", "[", 
         RowBox[{"pairs", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", " ", "1", ",", " ", 
          RowBox[{"Length", "[", "pairs", "]"}]}], "}"}]}], "]"}], "]"}]}], 
    ";", 
    RowBox[{"pairs", " ", "=", 
     RowBox[{"Take", "[", 
      RowBox[{"pairs", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", " ", 
         RowBox[{"Length", "[", "pairs", "]"}], ",", "2"}], "}"}]}], "]"}]}], 
    ";", 
    RowBox[{"pairsXY", " ", "=", " ", 
     RowBox[{"Transpose", "[", "pairs", "]"}]}], ";", 
    RowBox[{"X", " ", "=", " ", 
     RowBox[{"pairsXY", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";", 
    RowBox[{"Y", " ", "=", " ", 
     RowBox[{"pairsXY", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", 
    RowBox[{"Correlation", "[", 
     RowBox[{"X", ",", "Y"}], "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.3978001405740643`*^9, 3.397800196744834*^9}, {
   3.397800229682195*^9, 3.3978002732748785`*^9}, 3.3978034482202253`*^9, 
   3.3978054657012205`*^9, 3.3978055146315794`*^9, {3.397812305246003*^9, 
   3.397812305726694*^9}, 3.3978159915366287`*^9, {3.39781604734688*^9, 
   3.3978160478476*^9}, 3.3978167348254256`*^9, {3.397817413611472*^9, 
   3.39781741472307*^9}, 3.397819446424514*^9, 3.3978215717505827`*^9, {
   3.3978216478900657`*^9, 3.3978216482305555`*^9}, 3.397821859784755*^9, 
   3.397822180545987*^9, {3.3978228466838465`*^9, 3.397822846844077*^9}, 
   3.3978234150210752`*^9, {3.397823508195053*^9, 3.3978235086256723`*^9}, {
   3.3978838631712465`*^9, 3.397883863341491*^9}, 3.397883893895426*^9, 
   3.3978857252187395`*^9, {3.3978990993497953`*^9, 3.397899163542099*^9}, {
   3.3978999343104095`*^9, 3.3978999554708366`*^9}, {3.397900908401083*^9, 
   3.3979009096628976`*^9}, 3.397901573257099*^9, {3.397904232420789*^9, 
   3.397904267681491*^9}, {3.397904486115584*^9, 3.39790451671959*^9}, {
   3.397904563056219*^9, 3.397904574873211*^9}, {3.3979046248851247`*^9, 
   3.3979046264073133`*^9}, {3.397904695787077*^9, 3.3979047338317823`*^9}, {
   3.3979047837135086`*^9, 3.397904853073243*^9}, {3.404737580089625*^9, 
   3.404737596714625*^9}}],

Cell["\<\
We see that the choice of random seed has little influence on the correlation \
that we compute for a process of 50 lines in the unit square:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412325883627221*^9, 3.412325910866389*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ComputeCorr", "[", 
    RowBox[{"50", ",", "i"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", " ", "1", ",", " ", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3979047382781763`*^9, 3.3979047508061905`*^9}, {
  3.3979048746142178`*^9, 3.3979049193685713`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5980261477156433`", ",", "0.6072140861338264`", ",", 
   "0.6168770897263962`", ",", "0.6401216525167691`", ",", 
   "0.602859781427574`", ",", "0.6253690310302124`", ",", 
   "0.627029690994911`", ",", "0.5893159722003777`", ",", 
   "0.5931093678767482`", ",", "0.6019464450547973`"}], "}"}]], "Output",
 CellChangeTimes->{{3.397904746830474*^9, 3.3979047514571266`*^9}, {
   3.3979048661019773`*^9, 3.397904875144981*^9}, {3.3979049093441567`*^9, 
   3.3979049245560303`*^9}, 3.397908414844819*^9, 3.397974477237875*^9, 
   3.3979844792237153`*^9, 3.397984667694723*^9, 3.397985324839651*^9, 
   3.404737652089625*^9}]
}, Open  ]],

Cell["\<\
The coefficient of variation of polygon sides is close to 1, in agreement \
with theory:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412325921792099*^9, 3.4123259450956078`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ComputeCorr", "[", 
   RowBox[{"200", ",", " ", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sides", "=", 
   RowBox[{"DeleteCases", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", "sides", "]"}], ",", " ", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"Mean", "[", "sides", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"StandardDeviation", "[", "sides", "]"}], "/", "m"}]}], "Input",
 CellChangeTimes->{{3.397821762554946*^9, 3.3978218422895985`*^9}, {
   3.3979003514101696`*^9, 3.3979003694861617`*^9}, {3.3979006244628*^9, 
   3.3979007007324705`*^9}, {3.397900735151963*^9, 3.3979007542894816`*^9}, 
   3.3979009412783585`*^9, {3.397908826707048*^9, 3.397908842750117*^9}}],

Cell[BoxData["1.013197088536595`"], "Output",
 CellChangeTimes->{{3.3978991733662252`*^9, 3.397899185383506*^9}, 
   3.3979006625976353`*^9, 3.3979006961158323`*^9, {3.3979007508144846`*^9, 
   3.3979007549804754`*^9}, 3.397900942800547*^9, 3.3979021277844706`*^9, 
   3.397908862178053*^9, 3.3979744930906706`*^9, 3.3979844956072736`*^9, 
   3.3979846856505423`*^9, 3.3979853413433824`*^9, 3.404737667324*^9}]
}, Open  ]],

Cell["\<\
and the polygon side distribution is well described by an exponential \
distribution with the same mean:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412325950733715*^9, 3.412325982769781*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<Histograms`\>\"", "]"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Histogram", "[", 
    RowBox[{"sides", ",", " ", 
     RowBox[{"HistogramScale", "\[Rule]", "1"}], ",", 
     RowBox[{"HistogramCategories", "\[Rule]", "50"}]}], "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"ExponentialDistribution", "[", 
        RowBox[{"1", "/", "m"}], "]"}], ",", " ", "x"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", ".1"}], "}"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Thickness", "[", "0.005", "]"}]}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.3979007034563875`*^9, 3.3979007212419615`*^9}, {
  3.3979009519837523`*^9, 3.39790097212271*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0., 0}, {0.002, 113.58354136179737`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.002, 0}, {0.004, 84.12240681759491}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.004, 0}, {0.006, 65.24920375312043}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.006, 0}, {0.008, 51.99276921752604}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.008, 0}, {0.010000000000000002`, 41.576999225273305`}]}, \

    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.009999999999999998, 0}, {0.012, 30.88146681587329}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.012, 0}, {0.014000000000000002`, 25.479900146337265`}]}, \

    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.013999999999999999`, 0}, {0.016, 18.55040027545838}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.016, 0}, {0.018000000000000002`, 15.451493500903833`}]}, \

    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.018000000000000002`, 0}, \
{0.020000000000000004`, 11.814582077989163`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.019999999999999997`, 0}, {0.022, 9.447361625204449}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.022, 0}, {0.024, 6.73581819746922}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.024, 0}, {0.026000000000000002`, 5.5737281570112716`}]}, \

    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.026000000000000002`, 0}, \
{0.028000000000000004`, 4.04579495566842}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.027999999999999997`, 0}, {0.03, 3.852113282258762}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.03, 0}, {0.032, 2.3241800809158972`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.032, 0}, {0.034, 1.6785745028837034`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.034, 0}, {0.036000000000000004`, 1.614013945080484}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.036000000000000004`, 0}, \
{0.038000000000000006`, 1.3988120857364243`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.038, 0}, {0.04, 0.8177670655074453}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.04, 0}, {0.042, 0.6456055780321936}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.041999999999999996`, 0}, {0.044, 0.5595248342945697}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.044, 0}, {0.046, 0.43040371868812904`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.046, 0}, {0.048, 0.4519239046225355}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.048, 0}, {0.05, 0.2582422312128774}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.05, 0}, {0.052000000000000005`, 0.17216148747525162`}]}, \

    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.052000000000000005`, 0}, \
{0.054000000000000006`, 0.3012826030816914}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.054, 0}, {0.056, 0.17216148747525162`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.056, 0}, {0.058, 0.19368167340965808`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.057999999999999996`, 0}, {0.06, 0.1506413015408457}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.06, 0}, {0.062, 0.19368167340965808`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.062, 0}, {0.064, 0.08608074373762581}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.064, 0}, {0.066, 0.043040371868812904`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.066, 0}, {0.068, 0.08608074373762581}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.068, 0}, {0.07, 0.021520185934406452`}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.07, 0}, {0.07200000000000001, 0}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.07200000000000001, 0}, \
{0.07400000000000001, 0.0215201859344066}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], RectangleBox[{0.074, 0}, {0.076, 0}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], RectangleBox[{0.076, 0}, {0.078, 0}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], RectangleBox[{0.078, 0}, {0.08, 0}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], RectangleBox[{0.08, 0}, {0.082, 0}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], RectangleBox[{0.082, 0}, {0.084, 0}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.084, 0}, {0.08600000000000001, 0}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], RectangleBox[{0.086, 0}, {0.088, 0}]}, 
    {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
     EdgeForm[GrayLevel[0]], 
     RectangleBox[{0.088, 0}, {0.09, 0.021520185934406452`}]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJwV13c0V/8fB3DZJCRZyVZ8M0rJKJ5X9qhskhBCspOWUPYK2SR77/1RqIzS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      "]]}}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->None,
  AxesOrigin->{0., 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0., 0.09}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{0., 
      FormBox["0", TraditionalForm]}, {0.02, 
      FormBox["0.02`", TraditionalForm]}, {0.04, 
      FormBox["0.04`", TraditionalForm]}, {0.06, 
      FormBox["0.06`", TraditionalForm]}, {0.08, 
      FormBox["0.08`", TraditionalForm]}}, Automatic},
  TicksStyle->{}]], "Output",
 CellChangeTimes->{
  3.3979007271104*^9, 3.3979008154474225`*^9, {3.3979008565865774`*^9, 
   3.3979008698156*^9}, {3.3979009539866323`*^9, 3.3979009735347404`*^9}, 
   3.397902134203701*^9, 3.397909077397523*^9, 3.397974495414011*^9, 
   3.397984496037893*^9, 3.3979846875032063`*^9, 3.397985343015787*^9, 
   3.404737668870875*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztXQ2MFVcVnn0z7+2yINLiz7b8dKmUAlVYIOuyRWjttrBS1oUuVRKs6Yo1
uyb9CaCSSgyNEWKwIWkbbdOmtCnWVlFLmtKgtW1KpK0hYpo2+NcQtIoxbUgk
ajCa8X7n3nPn3jfz3pv33szse8tumHnv3Zl77jnn3vNzzzkzDAxvH7nt9uHt
o1uGO9dsHb5rZHTLts7Vd24VTW6L47SMOI7z504H333xVZ188c8fxQktlb9v
xEcOXV1qcB0Jhu5x6EIOXz18u7ryzV7Ehd7K3Vx9y4pqbr5SEjFEH551p8Yl
1Jwrgou/3qogRGG2vByEQnFzKVxw9CQGaW4t7KmauHwkSl5FtjYTU6KWdVmU
2kqhxJ9XZ8Oa6NVfu/BUzYgyCJRlQfSqcpNlXZy1kMlclCWpogbDkZyoKaYE
lqGgv0Wp6eBqed1fdF9Adskx1AK9WIL1TbB03pje9ZOyrfPMmX9ce+LXf8Hh
7MC5RfaZjA9i4eclPw0g/rHj7+JwPDrbbfmItnruy2KMRsbl6YO/E78OPHVS
XNl776t+52UD/je/dZSOrduOiGvDwz9R91+z8iEcTied8/6K3n3+yhUPcDu+
OzP9xYu25V66845nHXf/nt0v79r/6HEcTo7OEhAGEYcAIc7XBRf0zQtwbgkt
r3E/G1nhkqNzwX/ltb9j7v1p75/nP/jwb2jWv7HrZZ70Nasf1ZM+hc4E5tXR
kWfkDOPcKufvrh/98A0t6m10dtvOn/+vVgldEWpiTUTbwolpT6KvnOJW/8Wj
Z2iKH9n/BsndFXM3Q0T9nu7dziSaUw/f/e5l91D7gvlfdEk4C/6ll6yilSEO
zOf806fPQqG7EZPWPzG5aeHiqis/PvS2/4HpXTSJYpL8ZUt3iukloTyx5QsH
IYpQuKxo1x995RRmresPv3830kRPTFmCuOSpDXIGIyoMp/+5Ww6KVkxP679v
6HuEpweTM3LombcwNR3vvfdP5+0J9tptbWYbHYcOnyLr9NWv/dzftOkpj7ha
8Ps++TDslH/7Hc/5HR/uZY6+M8FQu83z29qmg0OkNnp79rqG/waVD40CXS9u
EzcLAH+9kFnYGlp/wkeGV+SvHzzgSN55ZzYMPvGDe3a9wF7PWYNjBHT884lW
iv+hD3b7V867FWvJVR7iVQtHwRYyPOcuzJWUU20wCDAGgjuiTa+c7937naOw
z/CP/3WBcChHToXre147KRvhbyqWuNBJzBLnPxcIP4SeaW/vgA7hLRbcBLgI
tHf63/hng6vY8NgTb/q3fekQs+HkLZufhv6Ydu7ceccfj2wohCzM/d89DuuS
CzQoLQIdacuNRzZ4ug17U+HYMflw6ODzQWEQ+d54JL9Ae2v4Xxw/gx0VPhhp
SqI7Px68Co41IRABW6ioxYYILgIROqnZJ3hSpEhz/GxJ1w4pz6BvcrPTGmzQ
IKRin0s0glbsfXntTml2MqWWnjmjT8e4IZ+FwtTceKDRU3dDKoW5AX1nb/zU
/v7XX/uTpG1a89LGETPs29atfRy0IWRN4Rai7aLmpS2nruz59i8pAIJ1if07
SJneTGSFNebdO18kcjBlmDpt/qc3vhkMqIFAISoFSoRPQzoS7ZHUNPwsSSUo
NioIN2slmMvlXb8p6fH8KZNnQdGBlj0PPfg6kdDRHCS46m5kAhC7EyQglEwk
XNIcJOQMEpR3dOvzh39LJFzaqCSEI9JQT+zcIbAKlGdI9PNyw+KY1Sn5RiOJ
msRXIQy8kii3pJWUIoaqSoxSIvMzqvQl12iESgUGrJC5PPXZm5+0ltwsSU0r
fcQqE6I2yvbkxpQuQgEeDdO04/sHTsi5my3xbyvCvnnmzIOBgccGupAwI0Qv
a3ayXMq/CJIoTUtYdho6o7ois0Yij00rtn9qZ4/ItklhVHlaI2lFNq0I2EMZ
9nTvRvyRSJjTeHaJzehzPztNdgg7AThpQPHyRkA37N2j1Aj+MLiLeJ82NQ2K
L5LNwBWJv2Om/96A+CKCzvsN8LkkvtnunmTKx6OUT2/PXoqjCI8j2Do0BCvz
7CFwLiawpPMaAT8Kk5PHonQroRau7R0T1AqFqdhN4YCD1TioaWMLzsnZnD+2
eLnqrISVCigJrwVjixfbEiiO9YMHIKV6KhsCNVfr4tmz+iXLFmaj08IbP+xb
WdMKJzWETBZM8pRa5dTRxRddpTVq5sV6en+FAwl8oPTTr999hBo+OmbowAFF
qQWS6tgmjQ062rYgoQ3O7Lv/vmNypj42JriAFWAJWBMk2DPHhZYweAGeEG8w
9KLs0RD2i9mhtyyLslEurv+Ryz/D9Mt5WJwdA3jDc+Sld6DxLQZkjobLsf+A
FV3Z4ZAzWIGNlHBVNSsyR8OlZzCg1mfO6JOsWJImDvmQiRN+gMBl3drHxf3C
xOmIg7k0ogJm6W7rw6ZYRRuspPOS0ug5WcZRPAtbwVFmKJwsPbyxwIKoseJf
Eer8bGCqXN1336+Io1iB+F3E1XwR+wKWRj81mVCU1MYRjheEFMIagWMQZyqH
WYpSxAEk4bKatEdK0dggy4WYKuuPHbm6rYIEpSvgnumeUPAXw3SnqftoSEoC
Cj6Q75rBkEKlwthaBjfVIV2q0VaRdDnJH093vGVLd7LbHR6vbo+K25SkIWoj
R+lJhypuU7VrQSFXSuOxSwRTodwROd7ydMfDEzbQB3M6N2QyHpf8trd3pDqe
6d7x1p21XcpDokin2EVJeciNQ09q+xg1ZA3iF46NI/0Nuka//Cz9dhInrnR1
EJZpVmOiEgnplVBMPakxXWWLUQmsimsMW5wYZVaQBk9aYDCU+lHDilSGgYFD
WFgbucSG0UEVqGI7n/qJxMcwuRUeowZp0pBNBiWMPTk2JncI/MpEwYeWUbLg
Q8snMfCuP/V9c+xlsyo52KjFVN6kBTutBLjytYJY3ipzs5ZZSQEbdSSkreTG
NWOKjtrRBmGlOtGpaktb5OggqRJGwg3GS3T7x0iyF4nH7QjwtcZ6LHpJFHMh
6dlgXJD2V/XKFi6tWiKSKZnj8fhpEyHv1nj1yDnDRqYMroHDxrom2OGolhIg
wj1h0Bwww5MpCYPmgmdgHwW6vJ1kLwgJNdQILOna4eTqQ9FyRchEqeQLNVxX
N0jOXZCRTQYkXuIBVa4tXk0gtXtB5UuWKu6rCx5XIAS6tD545JYIePSYeO3w
PIaHOkgq7MaP6+P7aASAEt4qmBACUB0uzCddY1o7KGYRXrxTOyhqY+5ITt9Q
Gxy8RkJld+uCg4ppayXVCAePIij21AVH2EbJG98Pwym5fLhNaeyAK6urw4Lb
VPwl4EqNcNRGOZCrGuEgTiK0cbA9qRIOuz94IAa2YfGibRLOmtrghLyHNYYn
U6NnzbA55yb24RbsFN1WHppNp+e1ZzW0WfED39CMiIWYWlOGh0fgQBHWZNEI
GdDHDg8kK/vRERwr9okSWLIEPqfeRXOMg1KsuSrKaDjIxXHRUDCvopyGYXEh
KjhfLyyWScCsChbXR3GCC+Wn3Lc/WrNbjhgO2AO8iIJ+rK2EvNWdfQkdd6mu
O9dQ6aqY6rpzOmv5W2/+rYbuVF8qumsntGL3vNkdbIMfK5l9Y+y+5OGIYRFU
qrbvpl+88Ed+FC7c15hk3YOd98BEVhxNu5nITMJLp27rYnezkprxutHLEcxd
S7xuIf8zXjeTJ1V0w3qxNi0Vu1GbvU4GKvfBww3W+hiInmOXHmOzVkMM6HM6
N7DMxO6jtEvgHsXos2zpTjjigbou08dMA4pxnv/K9sOyz6eVkfK00VJ/QfCk
vFVhyMo4Q2NYkEtY/KjX/se1k0XxOIhsVkMqdzjYJCQ4pNQo0gzjPRh4ATJd
HkydLMSe8AZQvZTS4yQ7eHiSHfb0irmbLSrV/3jAf8HiK78Mi6OCut5tsLRQ
FNfI6chejD7sj2lHO0YfZFORBCQWhfqE42BKWCnkG9VFRrpo36lLyZVvHAs+
5+ghRzG74PkldFFvVIjThTmFnVvMLswo5ahV6mLyKWYXk10xu5jcKtWFZ4TZ
hGEsb7MMfOaTkR4Od7ELLBWfSpeGDUT3NRhWdV+WW8G5qvuycAoWxuvL1WWz
Z/XzwwlKtqI5g2/84FVQMHSTeZ92ouAx6BDfUGgSXThYNmYbQnDoWQDTOx8K
3cLhYjwHVuIWLufXRWPhW9ih0sE7dYtR38l/WmMXpz8IECy/5ZIPmZp+kqW+
GXLxZwVVj50ODsm0jSb8qD5VF9Za/ksZ8MX/dU5Z2Hm9qm5KCGKAbRCEs7BN
xKxaxQQKfJUm1JKV8P/CYQczw9el5110Xb4TyZVPPTtOEM682bou9weybDLi
uicTIpgYPiJRsMU0o+tOy/8B5bkQ9A==\
\>"]]
}, Open  ]],

Cell["\<\
We track the evolution of a stable correlation for a process with an \
increasing number of lines. \
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123260272537456`*^9, 3.412326050627355*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nl", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "6", ",", "7", ",", "8", ",", "9", ",", "10", ",", "12", ",", 
     "14", ",", "16", ",", "18", ",", "20", ",", "30", ",", "40", ",", "50", 
     ",", "75", ",", "100", ",", "125", ",", "150", ",", "200", ",", "500"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"evolve", " ", "=", " ", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"nl", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"ComputeCorr", "[", 
         RowBox[{
          RowBox[{"nl", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "1"}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", " ", "1", ",", " ", 
          RowBox[{"Length", "[", "nl", "]"}]}], "}"}]}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", "evolve", "]"}]}], "Input",
 CellChangeTimes->{{3.3979091692596145`*^9, 3.3979092015360255`*^9}, {
  3.397974357605853*^9, 3.39797436049*^9}, {3.412326010970331*^9, 
  3.4123260121820736`*^9}}],

Cell[CellGroupData[{

Cell[" Sorted Independent Polygon Sides", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.397976121445821*^9, 3.3979761256919265`*^9}, 
   3.4123245686563854`*^9, {3.4123260619436274`*^9, 3.412326069624672*^9}}],

Cell[TextData[{
 "The process of sorting itself induces correlation between random variables. \
For comparison then we must derive the correlation between sorted independent \
exponentially distributed random variables.\nThe marginal probabilities of ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["y ",
  FontSlant->"Italic"],
 "are:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412326090334451*^9, 3.4123260948008738`*^9}, {
  3.4123266976677537`*^9, 3.4123267583750467`*^9}, {3.4123267945570736`*^9, 
  3.412326812162389*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pdfx", " ", "=", " ", 
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{"1", " ", "-", " ", 
       RowBox[{"CDF", "[", 
        RowBox[{
         RowBox[{"ExponentialDistribution", "[", "1", "]"}], ",", "x"}], 
        "]"}]}], ")"}], 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"ExponentialDistribution", "[", "1", "]"}], ",", "x"}], 
      "]"}]}], ",", " ", 
    RowBox[{"x", ">", "0"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"pdfy", " ", "=", " ", 
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{"CDF", "[", 
       RowBox[{
        RowBox[{"ExponentialDistribution", "[", "1", "]"}], ",", "y"}], "]"}],
       ")"}], 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"ExponentialDistribution", "[", "1", "]"}], ",", "y"}], 
      "]"}]}], ",", " ", 
    RowBox[{"y", ">", "0"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.3979832901238737`*^9, 3.3979833805539055`*^9}}],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "x"}]]}]], "Output",
 CellChangeTimes->{{3.3979833449527135`*^9, 3.3979833815753746`*^9}, 
   3.397984687813653*^9, 3.397985343326234*^9, 3.404737669027125*^9}],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "y"}]], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "y"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.3979833449527135`*^9, 3.3979833815753746`*^9}, 
   3.397984687813653*^9, 3.397985343326234*^9, 3.404737669027125*^9}]
}, Open  ]],

Cell["and the mean and variance are:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412326825972246*^9, 3.41232683091936*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"xbar", " ", "=", " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"x", " ", "pdfx"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}]}], 
     "]"}]}], ",", 
   RowBox[{"xvar", " ", "=", " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", " ", "-", " ", "xbar"}], ")"}], "2"], " ", "pdfx"}], 
      ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}]}], 
     "]"}]}], ",", 
   RowBox[{"ybar", " ", "=", " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"y", " ", "pdfy"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"y", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}]}], 
     "]"}]}], ",", 
   RowBox[{"yvar", " ", "=", " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"y", " ", "-", " ", "ybar"}], ")"}], "2"], " ", "pdfy"}], 
      ",", " ", 
      RowBox[{"{", 
       RowBox[{"y", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}]}], 
     "]"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.397983562896101*^9, 3.3979836378538847`*^9}, {
  3.3979842580456767`*^9, 3.397984279506536*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "4"], ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["5", "4"]}], "}"}]], "Output",
 CellChangeTimes->{{3.397983579680235*^9, 3.397983638254461*^9}, 
   3.397984280888523*^9, 3.397984691869485*^9, 3.397985346470755*^9, 
   3.404737672808375*^9}]
}, Open  ]],

Cell[TextData[{
 "The mean ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    RowBox[{"x", " ", "y"}], "_"], TraditionalForm]]],
 " is unaffected by the process of sorting and equals 1, so the covariance \
is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4123268412442064`*^9, 3.412326875102893*^9}, 
   3.4123269290905232`*^9, 3.412326972993653*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"covariance", " ", "=", " ", 
  RowBox[{"1", " ", "-", " ", 
   RowBox[{"xbar", " ", "ybar"}]}]}]], "Input",
 CellChangeTimes->{{3.397983670610987*^9, 3.397983675608173*^9}, {
  3.3979845987355647`*^9, 3.39798460031784*^9}}],

Cell[BoxData[
 FractionBox["1", "4"]], "Output",
 CellChangeTimes->{3.397983710207925*^9, 3.3979846167314415`*^9, 
  3.3979846920397296`*^9, 3.397985346721115*^9, 3.40473767291775*^9}]
}, Open  ]],

Cell["The correlation is therefore:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412326879439128*^9, 3.412326889293298*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"\[Rho]", " ", "=", " ", 
  RowBox[{"covariance", "/", 
   SqrtBox[
    RowBox[{"xvar", " ", "yvar"}]]}]}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "\[Rho]", "]"}]}], "Input",
 CellChangeTimes->{{3.397983691981717*^9, 3.397983706933216*^9}, {
  3.3979846104524126`*^9, 3.397984612475322*^9}, {3.397984685109765*^9, 
  3.39798468719276*^9}}],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["5"]]], "Output",
 CellChangeTimes->{{3.39798370737385*^9, 3.3979837109489903`*^9}, 
   3.3979846177028384`*^9, 3.3979846920797873`*^9, 3.3979853468212595`*^9, 
   3.404737672964625*^9}],

Cell[BoxData["0.4472135954999579`"], "Output",
 CellChangeTimes->{{3.39798370737385*^9, 3.3979837109489903`*^9}, 
   3.3979846177028384`*^9, 3.3979846920797873`*^9, 3.3979853468212595`*^9, 
   3.404737672964625*^9}]
}, Open  ]],

Cell["\<\
Which is less than we have obtained for adjacent polygon sides arising from a \
Poisson line process.\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4123268958126717`*^9, 3.412326924103352*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{616, 750},
WindowMargins->{{36, Automatic}, {Automatic, 46}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 110, 2, 73, "Title"],
Cell[703, 27, 143, 2, 36, "Subtitle"],
Cell[849, 31, 148, 2, 29, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1022, 37, 182, 3, 75, "Section"],
Cell[CellGroupData[{
Cell[1229, 44, 173, 3, 37, "Subsection"],
Cell[1405, 49, 512, 20, 65, "Text"],
Cell[CellGroupData[{
Cell[1942, 73, 1552, 34, 142, "Input"],
Cell[3497, 109, 21124, 352, 388, "Output"]
}, Open  ]],
Cell[24636, 464, 263, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[24924, 473, 1420, 29, 82, "Input"],
Cell[26347, 504, 37536, 623, 388, 21047, 351, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[63898, 1130, 514, 13, 85, "Text"],
Cell[CellGroupData[{
Cell[64437, 1147, 1269, 25, 62, "Input"],
Cell[65709, 1174, 1041, 20, 188, "Output"]
}, Open  ]],
Cell[66765, 1197, 402, 8, 66, "Text"],
Cell[CellGroupData[{
Cell[67192, 1209, 1484, 26, 102, "Input"],
Cell[68679, 1237, 269, 4, 40, "Output"],
Cell[68951, 1243, 314, 6, 40, "Output"],
Cell[69268, 1251, 339, 7, 55, "Output"]
}, Open  ]],
Cell[69622, 1261, 513, 14, 66, "Text"],
Cell[CellGroupData[{
Cell[70160, 1279, 308, 6, 41, "Input"],
Cell[70471, 1287, 1008, 32, 60, "Output"]
}, Open  ]],
Cell[71494, 1322, 323, 7, 48, "Text"],
Cell[CellGroupData[{
Cell[71842, 1333, 734, 16, 102, "Input"],
Cell[72579, 1351, 621, 15, 60, "Output"],
Cell[73203, 1368, 3771, 96, 251, "Output"],
Cell[76977, 1466, 196, 3, 40, "Output"]
}, Open  ]],
Cell[77188, 1472, 381, 7, 65, "Text"],
Cell[77572, 1481, 2251, 46, 142, "Input"],
Cell[79826, 1529, 352, 8, 66, "Text"],
Cell[80181, 1539, 1937, 43, 82, "Input"],
Cell[82121, 1584, 253, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[82399, 1593, 919, 21, 82, "Input"],
Cell[83321, 1616, 17483, 387, 371, "Output"]
}, Open  ]],
Cell[100819, 2006, 677, 17, 106, "Text"],
Cell[CellGroupData[{
Cell[101521, 2027, 2378, 60, 202, "Input"],
Cell[103902, 2089, 11531, 220, 257, 4362, 103, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[115448, 2312, 470, 11, 65, "Text"],
Cell[115921, 2325, 534, 13, 64, "Input"],
Cell[CellGroupData[{
Cell[116480, 2342, 1121, 29, 102, "Input"],
Cell[117604, 2373, 5137, 92, 253, 2184, 42, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[122790, 2471, 204, 3, 37, "Subsection"],
Cell[122997, 2476, 1302, 33, 83, "Text"],
Cell[CellGroupData[{
Cell[124324, 2513, 841, 24, 85, "Input"],
Cell[125168, 2539, 353, 8, 56, "Output"],
Cell[125524, 2549, 237, 3, 40, "Output"]
}, Open  ]],
Cell[125776, 2555, 712, 22, 29, "Text"],
Cell[CellGroupData[{
Cell[126513, 2581, 177, 4, 41, "Input"],
Cell[126693, 2587, 354, 8, 56, "Output"]
}, Open  ]],
Cell[127062, 2598, 319, 10, 34, "Text"],
Cell[CellGroupData[{
Cell[127406, 2612, 581, 16, 71, "Input"],
Cell[127990, 2630, 354, 9, 65, "Output"],
Cell[128347, 2641, 231, 3, 40, "Output"]
}, Open  ]],
Cell[128593, 2647, 286, 10, 34, "Text"],
Cell[CellGroupData[{
Cell[128904, 2661, 198, 4, 41, "Input"],
Cell[129105, 2667, 363, 9, 65, "Output"]
}, Open  ]],
Cell[129483, 2679, 563, 18, 50, "Text"],
Cell[CellGroupData[{
Cell[130071, 2701, 404, 11, 62, "Input"],
Cell[130478, 2714, 1293, 38, 129, "Output"]
}, Open  ]],
Cell[131786, 2755, 377, 10, 50, "Text"],
Cell[CellGroupData[{
Cell[132188, 2769, 2122, 37, 82, "Input"],
Cell[134313, 2808, 713, 14, 61, "Output"]
}, Open  ]],
Cell[135041, 2825, 167, 3, 29, "Text"],
Cell[CellGroupData[{
Cell[135233, 2832, 1724, 37, 107, "Input"],
Cell[136960, 2871, 1183, 29, 83, "Output"]
}, Open  ]],
Cell[138158, 2903, 381, 12, 53, "Text"],
Cell[CellGroupData[{
Cell[138564, 2919, 623, 16, 86, "Input"],
Cell[139190, 2937, 1891, 53, 108, "Output"]
}, Open  ]],
Cell[141096, 2993, 193, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[141314, 3002, 1119, 29, 130, "Input"],
Cell[142436, 3033, 405, 10, 55, "Output"],
Cell[142844, 3045, 383, 9, 55, "Output"],
Cell[143230, 3056, 265, 4, 40, "Output"]
}, Open  ]],
Cell[143510, 3063, 244, 9, 34, "Text"],
Cell[CellGroupData[{
Cell[143779, 3076, 1243, 32, 130, "Input"],
Cell[145027, 3111, 475, 12, 55, "Output"],
Cell[145505, 3125, 493, 13, 55, "Output"],
Cell[146001, 3140, 343, 7, 58, "Output"]
}, Open  ]],
Cell[146359, 3150, 284, 8, 47, "Text"],
Cell[CellGroupData[{
Cell[146668, 3162, 763, 18, 102, "Input"],
Cell[147434, 3182, 2249, 62, 100, "Output"]
}, Open  ]],
Cell[149698, 3247, 134, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[149857, 3253, 952, 23, 76, "Input"],
Cell[150812, 3278, 553, 8, 40, "Output"]
}, Open  ]],
Cell[151380, 3289, 138, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[151543, 3295, 1566, 32, 96, "Input"],
Cell[153112, 3329, 989, 18, 55, "Output"]
}, Open  ]],
Cell[154116, 3350, 293, 9, 34, "Text"],
Cell[CellGroupData[{
Cell[154434, 3363, 361, 7, 43, "Input"],
Cell[154798, 3372, 499, 15, 55, "Output"]
}, Open  ]],
Cell[155312, 3390, 198, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[155535, 3399, 2544, 74, 292, "Input"],
Cell[158082, 3475, 389, 9, 40, "Output"],
Cell[158474, 3486, 17895, 327, 264, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[176430, 3820, 179, 3, 75, "Section"],
Cell[CellGroupData[{
Cell[176634, 3827, 154, 3, 37, "Subsection"],
Cell[176791, 3832, 364, 7, 47, "Text"],
Cell[177158, 3841, 876, 26, 122, "Input"],
Cell[178037, 3869, 158, 2, 29, "Text"],
Cell[178198, 3873, 361, 10, 41, "Input"],
Cell[178562, 3885, 140, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[178727, 3891, 544, 14, 62, "Input"],
Cell[179274, 3907, 72656, 1128, 384, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[251979, 5041, 182, 3, 37, "Subsection"],
Cell[252164, 5046, 518, 9, 83, "Text"],
Cell[CellGroupData[{
Cell[252707, 5059, 139, 2, 27, "Subsubsection"],
Cell[252849, 5063, 451, 16, 34, "Text"],
Cell[CellGroupData[{
Cell[253325, 5083, 349, 8, 70, "Input"],
Cell[253677, 5093, 669, 12, 60, "Output"],
Cell[254349, 5107, 669, 12, 60, "Output"]
}, Open  ]],
Cell[255033, 5122, 449, 14, 49, "Text"],
Cell[CellGroupData[{
Cell[255507, 5140, 2467, 63, 302, "Input"],
Cell[257979, 5206, 1660, 40, 72, "Output"],
Cell[259642, 5248, 657, 10, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[260348, 5264, 136, 2, 27, "Subsubsection"],
Cell[260487, 5268, 387, 14, 32, "Text"],
Cell[CellGroupData[{
Cell[260899, 5286, 681, 16, 41, "Input"],
Cell[261583, 5304, 632, 10, 40, "Output"]
}, Open  ]],
Cell[262230, 5317, 311, 10, 34, "Text"],
Cell[CellGroupData[{
Cell[262566, 5331, 553, 13, 49, "Input"],
Cell[263122, 5346, 672, 12, 60, "Output"]
}, Open  ]],
Cell[263809, 5361, 386, 12, 31, "Text"],
Cell[CellGroupData[{
Cell[264220, 5377, 1546, 29, 82, "Input"],
Cell[265769, 5408, 1629, 35, 54, "Output"],
Cell[267401, 5445, 857, 12, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[268307, 5463, 134, 2, 27, "Subsubsection"],
Cell[268444, 5467, 298, 7, 48, "Text"],
Cell[CellGroupData[{
Cell[268767, 5478, 1018, 20, 82, "Input"],
Cell[269788, 5500, 2245, 50, 86, "Output"]
}, Open  ]],
Cell[272048, 5553, 336, 12, 38, "Text"],
Cell[CellGroupData[{
Cell[272409, 5569, 786, 19, 82, "Input"],
Cell[273198, 5590, 1827, 47, 86, "Output"]
}, Open  ]],
Cell[275040, 5640, 235, 7, 29, "Text"],
Cell[CellGroupData[{
Cell[275300, 5651, 681, 15, 49, "Input"],
Cell[275984, 5668, 4318, 79, 264, "Output"]
}, Open  ]],
Cell[280317, 5750, 205, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[280547, 5759, 3051, 80, 299, "Input"],
Cell[283601, 5841, 16397, 314, 269, "Output"]
}, Open  ]],
Cell[300013, 6158, 185, 4, 29, "Text"],
Cell[CellGroupData[{
Cell[300223, 6166, 1929, 36, 96, "Input"],
Cell[302155, 6204, 977, 22, 55, "Output"]
}, Open  ]],
Cell[303147, 6229, 272, 6, 47, "Text"],
Cell[CellGroupData[{
Cell[303444, 6239, 136, 2, 41, "Input"],
Cell[303583, 6243, 602, 16, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[304222, 6264, 284, 4, 41, "Input"],
Cell[304509, 6270, 737, 20, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[305283, 6295, 844, 23, 111, "Input"],
Cell[306132, 6321, 558, 12, 55, "Output"]
}, Open  ]],
Cell[306705, 6336, 371, 7, 47, "Text"],
Cell[CellGroupData[{
Cell[307101, 6347, 1259, 29, 96, "Input"],
Cell[308363, 6378, 603, 15, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[309003, 6398, 690, 16, 41, "Input"],
Cell[309696, 6416, 847, 16, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[310592, 6438, 128, 2, 27, "Subsubsection"],
Cell[310723, 6442, 1067, 34, 106, "Text"],
Cell[CellGroupData[{
Cell[311815, 6480, 906, 21, 86, "Input"],
Cell[312724, 6503, 263, 5, 58, "Output"]
}, Open  ]],
Cell[313002, 6511, 135, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[313162, 6517, 371, 7, 41, "Input"],
Cell[313536, 6526, 479, 7, 55, "Output"]
}, Open  ]],
Cell[314030, 6536, 156, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[314211, 6542, 388, 10, 65, "Input"],
Cell[314602, 6554, 286, 6, 59, "Output"],
Cell[314891, 6562, 290, 6, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[315218, 6573, 160, 3, 41, "Input"],
Cell[315381, 6578, 465, 14, 59, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[315907, 6599, 191, 3, 37, "Subsection"],
Cell[316101, 6604, 607, 18, 101, "Text"],
Cell[CellGroupData[{
Cell[316733, 6626, 330, 7, 41, "Input"],
Cell[317066, 6635, 277, 6, 40, "Output"]
}, Open  ]],
Cell[317358, 6644, 313, 9, 29, "Text"],
Cell[CellGroupData[{
Cell[317696, 6657, 454, 11, 41, "Input"],
Cell[318153, 6670, 330, 8, 40, "Output"]
}, Open  ]],
Cell[318498, 6681, 244, 9, 29, "Text"],
Cell[CellGroupData[{
Cell[318767, 6694, 346, 8, 41, "Input"],
Cell[319116, 6704, 166, 3, 57, "Output"]
}, Open  ]],
Cell[319297, 6710, 245, 7, 29, "Text"],
Cell[CellGroupData[{
Cell[319567, 6721, 204, 5, 41, "Input"],
Cell[319774, 6728, 196, 5, 67, "Output"]
}, Open  ]],
Cell[319985, 6736, 304, 9, 47, "Text"],
Cell[CellGroupData[{
Cell[320314, 6749, 556, 13, 82, "Input"],
Cell[320873, 6764, 326, 8, 67, "Output"],
Cell[321202, 6774, 220, 4, 40, "Output"],
Cell[321425, 6780, 245, 5, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[321719, 6791, 184, 3, 37, "Subsection"],
Cell[CellGroupData[{
Cell[321928, 6798, 189, 3, 27, "Subsubsection"],
Cell[322120, 6803, 346, 7, 47, "Text"],
Cell[CellGroupData[{
Cell[322491, 6814, 517, 11, 62, "Input"],
Cell[323011, 6827, 318, 8, 57, "Output"]
}, Open  ]],
Cell[323344, 6838, 443, 13, 51, "Text"],
Cell[CellGroupData[{
Cell[323812, 6855, 750, 20, 65, "Input"],
Cell[324565, 6877, 267, 4, 40, "Output"],
Cell[324835, 6883, 284, 4, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[325168, 6893, 131, 2, 27, "Subsubsection"],
Cell[325302, 6897, 312, 7, 47, "Text"],
Cell[CellGroupData[{
Cell[325639, 6908, 614, 14, 62, "Input"],
Cell[326256, 6924, 535, 16, 72, "Output"],
Cell[326794, 6942, 168, 2, 40, "Output"]
}, Open  ]],
Cell[326977, 6947, 264, 6, 47, "Text"],
Cell[327244, 6955, 508, 10, 41, "Input"],
Cell[327755, 6967, 180, 4, 29, "Text"],
Cell[327938, 6973, 440, 13, 62, "Input"],
Cell[328381, 6988, 529, 19, 67, "Text"],
Cell[CellGroupData[{
Cell[328935, 7011, 785, 19, 62, "Input"],
Cell[329723, 7032, 434, 13, 55, "Output"],
Cell[330160, 7047, 165, 2, 40, "Output"]
}, Open  ]],
Cell[330340, 7052, 209, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[330574, 7061, 652, 19, 64, "Input"],
Cell[331229, 7082, 196, 3, 40, "Output"],
Cell[331428, 7087, 199, 3, 40, "Output"]
}, Open  ]],
Cell[331642, 7093, 237, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[331904, 7102, 405, 10, 41, "Input"],
Cell[332312, 7114, 3455, 64, 259, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[335816, 7184, 124, 2, 27, "Subsubsection"],
Cell[335943, 7188, 871, 29, 71, "Text"],
Cell[336817, 7219, 902, 26, 102, "Input"],
Cell[337722, 7247, 528, 19, 32, "Text"],
Cell[CellGroupData[{
Cell[338275, 7270, 1077, 26, 82, "Input"],
Cell[339355, 7298, 472, 12, 77, "Output"],
Cell[339832, 7313, 267, 4, 40, "Output"]
}, Open  ]],
Cell[340114, 7320, 211, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[340350, 7329, 1005, 25, 91, "Input"],
Cell[341358, 7356, 295, 5, 40, "Output"],
Cell[341656, 7363, 316, 6, 40, "Output"],
Cell[341975, 7371, 278, 5, 42, "Output"]
}, Open  ]],
Cell[342268, 7379, 202, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[342495, 7388, 1150, 30, 82, "Input"],
Cell[343648, 7420, 8669, 151, 268, "Output"]
}, Open  ]],
Cell[352332, 7574, 278, 6, 47, "Text"],
Cell[CellGroupData[{
Cell[352635, 7584, 385, 10, 62, "Input"],
Cell[353023, 7596, 482, 12, 77, "Output"]
}, Open  ]],
Cell[353520, 7611, 160, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[353705, 7617, 1121, 28, 112, "Input"],
Cell[354829, 7647, 330, 7, 60, "Output"],
Cell[355162, 7656, 418, 10, 55, "Output"],
Cell[355583, 7668, 358, 8, 65, "Output"],
Cell[355944, 7678, 285, 4, 40, "Output"]
}, Open  ]],
Cell[356244, 7685, 222, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[356491, 7694, 1111, 31, 108, "Input"],
Cell[357607, 7728, 10558, 181, 261, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[368226, 7916, 188, 3, 37, "Subsection"],
Cell[368417, 7921, 790, 14, 121, "Text"],
Cell[369210, 7937, 2117, 51, 182, "Input"],
Cell[371330, 7990, 316, 8, 47, "Text"],
Cell[CellGroupData[{
Cell[371671, 8002, 936, 24, 62, "Input"],
Cell[372610, 8028, 965, 22, 60, "Output"]
}, Open  ]],
Cell[373590, 8053, 507, 11, 65, "Text"],
Cell[CellGroupData[{
Cell[374122, 8068, 994, 23, 62, "Input"],
Cell[375119, 8093, 1659, 46, 98, "Output"]
}, Open  ]],
Cell[376793, 8142, 376, 9, 66, "Text"],
Cell[CellGroupData[{
Cell[377194, 8155, 3077, 80, 202, "Input"],
Cell[380274, 8237, 5059, 160, 212, "Output"]
}, Open  ]],
Cell[385348, 8400, 397, 10, 67, "Text"],
Cell[CellGroupData[{
Cell[385770, 8414, 1932, 51, 122, "Input"],
Cell[387705, 8467, 4499, 142, 193, "Output"]
}, Open  ]],
Cell[392219, 8612, 385, 7, 65, "Text"],
Cell[CellGroupData[{
Cell[392629, 8623, 1730, 49, 122, "Input"],
Cell[394362, 8674, 6241, 202, 269, "Output"]
}, Open  ]],
Cell[400618, 8879, 529, 10, 84, "Text"],
Cell[401150, 8891, 3568, 90, 162, "Input"],
Cell[404721, 8983, 288, 7, 48, "Text"],
Cell[CellGroupData[{
Cell[405034, 8994, 199, 4, 41, "Input"],
Cell[405236, 9000, 2356, 69, 155, "Output"]
}, Open  ]],
Cell[407607, 9072, 283, 6, 47, "Text"],
Cell[CellGroupData[{
Cell[407915, 9082, 2080, 54, 182, "Input"],
Cell[409998, 9138, 361, 7, 40, "Output"]
}, Open  ]],
Cell[410374, 9148, 229, 5, 47, "Text"],
Cell[410606, 9155, 2088, 59, 142, "Input"],
Cell[412697, 9216, 284, 8, 49, "Text"],
Cell[412984, 9226, 957, 25, 62, "Input"],
Cell[413944, 9253, 137, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[414106, 9259, 602, 15, 102, "Input"],
Cell[414713, 9277, 250, 3, 40, "Output"]
}, Open  ]],
Cell[414978, 9283, 339, 10, 49, "Text"],
Cell[415320, 9295, 17091, 454, 1142, "Input"],
Cell[432414, 9751, 249, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[432688, 9760, 344, 8, 41, "Input"],
Cell[433035, 9770, 666, 12, 60, "Output"]
}, Open  ]],
Cell[433716, 9785, 198, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[433939, 9794, 806, 18, 102, "Input"],
Cell[434748, 9814, 410, 5, 40, "Output"]
}, Open  ]],
Cell[435173, 9822, 212, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[435410, 9831, 885, 20, 122, "Input"],
Cell[436298, 9853, 26358, 473, 252, 21540, 392, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[462671, 10329, 209, 5, 47, "Text"],
Cell[462883, 10336, 1098, 27, 142, "Input"],
Cell[CellGroupData[{
Cell[464006, 10367, 220, 3, 27, "Subsubsection"],
Cell[464229, 10372, 552, 14, 83, "Text"],
Cell[CellGroupData[{
Cell[464806, 10390, 1009, 30, 142, "Input"],
Cell[465818, 10422, 272, 6, 40, "Output"],
Cell[466093, 10430, 365, 9, 40, "Output"]
}, Open  ]],
Cell[466473, 10442, 129, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[466627, 10448, 1335, 40, 108, "Input"],
Cell[467965, 10490, 343, 9, 55, "Output"]
}, Open  ]],
Cell[468323, 10502, 358, 11, 29, "Text"],
Cell[CellGroupData[{
Cell[468706, 10517, 247, 5, 41, "Input"],
Cell[468956, 10524, 184, 3, 55, "Output"]
}, Open  ]],
Cell[469155, 10530, 129, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[469309, 10536, 367, 8, 69, "Input"],
Cell[469679, 10546, 229, 5, 59, "Output"],
Cell[469911, 10553, 215, 3, 40, "Output"]
}, Open  ]],
Cell[470141, 10559, 211, 5, 47, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

